/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.concur.resource.OSharedContainer;
import com.orientechnologies.common.concur.resource.OSharedContainerImpl;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

public abstract class OStorageAbstract
implements OStorage,
OSharedContainer {
    public static final ThreadGroup storageThreadGroup;
    protected final String url;
    protected final String mode;
    protected final OReadersWriterSpinLock stateLock;
    protected volatile OStorageConfiguration configuration;
    protected volatile OCurrentStorageComponentsFactory componentsFactory;
    protected String name;
    private final AtomicLong version = new AtomicLong();
    protected volatile OStorage.STATUS status = OStorage.STATUS.CLOSED;
    protected final OSharedContainerImpl sharedContainer = new OSharedContainerImpl();

    public OStorageAbstract(String name, String iURL, String mode) {
        this.name = this.normalizeName(name);
        if (OStringSerializerHelper.contains(this.name, ',')) {
            throw new IllegalArgumentException("Invalid character in storage name: " + this.name);
        }
        this.url = iURL;
        this.mode = mode;
        this.stateLock = new OReadersWriterSpinLock();
    }

    protected String normalizeName(String name) {
        if (OStringSerializerHelper.contains(name, '/')) {
            if (OStringSerializerHelper.contains(name = name.substring(name.lastIndexOf("/") + 1), '\\')) {
                return name.substring(name.lastIndexOf("\\") + 1);
            }
            return name;
        }
        if (OStringSerializerHelper.contains(name, '\\')) {
            if (OStringSerializerHelper.contains(name = name.substring(name.lastIndexOf("\\") + 1), '/')) {
                return name.substring(name.lastIndexOf("/") + 1);
            }
            return name;
        }
        return name;
    }

    @Override
    public OStorage getUnderlying() {
        return this;
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isClosed() {
        return this.status == OStorage.STATUS.CLOSED;
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return ppos != null && !ORecordVersionHelper.isTombstone(ppos.recordVersion);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void close() {
        this.close(false, false);
    }

    @Override
    public void close(boolean iForce, boolean onDelete) {
        this.sharedContainer.clearResources();
    }

    @Override
    public boolean existsResource(String iName) {
        return this.sharedContainer.existsResource(iName);
    }

    @Override
    public <T> T removeResource(String iName) {
        return this.sharedContainer.removeResource(iName);
    }

    @Override
    public <T> T getResource(String iName, Callable<T> iCallback) {
        return this.sharedContainer.getResource(iName, iCallback);
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public boolean dropCluster(String iClusterName) {
        return this.dropCluster(this.getClusterIdByName(iClusterName));
    }

    @Override
    public long countRecords() {
        long tot = 0L;
        for (OCluster oCluster : this.getClusterInstances()) {
            if (oCluster == null) continue;
            tot += oCluster.getEntries() - oCluster.getTombstonesCount();
        }
        return tot;
    }

    public String toString() {
        return this.url != null ? this.url : "?";
    }

    @Override
    public OStorage.STATUS getStatus() {
        return this.status;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isAssigningClusterIds() {
        return true;
    }

    @Override
    public OCurrentStorageComponentsFactory getComponentsFactory() {
        return this.componentsFactory;
    }

    @Override
    public void shutdown() {
        this.close(true, false);
    }

    static {
        ThreadGroup parentThreadGroup;
        ThreadGroup parentThreadGroupBackup = parentThreadGroup = Thread.currentThread().getThreadGroup();
        boolean found = false;
        while (parentThreadGroup.getParent() != null) {
            if (parentThreadGroup.equals(Orient.instance().getThreadGroup())) {
                parentThreadGroup = parentThreadGroup.getParent();
                found = true;
                break;
            }
            parentThreadGroup = parentThreadGroup.getParent();
        }
        if (!found) {
            parentThreadGroup = parentThreadGroupBackup;
        }
        storageThreadGroup = new ThreadGroup(parentThreadGroup, "OrientDB Storage");
    }
}

