/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.chm;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.chm.Admittor;
import com.orientechnologies.orient.core.storage.cache.chm.LRUList;
import com.orientechnologies.orient.core.storage.cache.chm.PageKey;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

final class WTinyLFUPolicy {
    private static final int EDEN_PERCENT = 20;
    private static final int PROBATIONARY_PERCENT = 20;
    private volatile int maxSize;
    private final ConcurrentHashMap<PageKey, OCacheEntry> data;
    private final Admittor admittor;
    private final AtomicInteger cacheSize;
    private final LRUList eden = new LRUList();
    private final LRUList probation = new LRUList();
    private final LRUList protection = new LRUList();
    private int maxEdenSize;
    private int maxProtectedSize;
    private int maxSecondLevelSize;

    WTinyLFUPolicy(ConcurrentHashMap<PageKey, OCacheEntry> data, Admittor admittor, AtomicInteger cacheSize) {
        this.data = data;
        this.admittor = admittor;
        this.cacheSize = cacheSize;
    }

    public void setMaxSize(int maxSize) {
        if (this.eden.size() + this.protection.size() + this.probation.size() > maxSize) {
            throw new IllegalStateException("Can set maximum cache size to " + maxSize + " because current cache size is bigger than requested");
        }
        this.maxSize = maxSize;
        this.calculateMaxSizes();
        this.admittor.ensureCapacity(maxSize);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    void onAccess(OCacheEntry cacheEntry) {
        this.admittor.increment(PageKey.hashCode(cacheEntry.getFileId(), cacheEntry.getPageIndex()));
        if (!cacheEntry.isDead()) {
            if (this.probation.contains(cacheEntry)) {
                this.probation.remove(cacheEntry);
                this.protection.moveToTheTail(cacheEntry);
                if (this.protection.size() > this.maxProtectedSize) {
                    cacheEntry = this.protection.poll();
                    this.probation.moveToTheTail(cacheEntry);
                }
            } else if (this.protection.contains(cacheEntry)) {
                this.protection.moveToTheTail(cacheEntry);
            } else if (this.eden.contains(cacheEntry)) {
                this.eden.moveToTheTail(cacheEntry);
            }
        }
        assert (this.eden.size() <= this.maxEdenSize);
        assert (this.protection.size() <= this.maxProtectedSize);
        assert (this.probation.size() + this.protection.size() <= this.maxSecondLevelSize);
    }

    void onAdd(OCacheEntry cacheEntry) {
        this.admittor.increment(PageKey.hashCode(cacheEntry.getFileId(), cacheEntry.getPageIndex()));
        if (cacheEntry.isAlive()) {
            assert (!this.eden.contains(cacheEntry));
            assert (!this.probation.contains(cacheEntry));
            assert (!this.protection.contains(cacheEntry));
            this.eden.moveToTheTail(cacheEntry);
            this.purgeEden();
        }
        assert (this.eden.size() <= this.maxEdenSize);
        assert (this.protection.size() <= this.maxProtectedSize);
        assert (this.probation.size() + this.protection.size() <= this.maxSecondLevelSize);
    }

    private void purgeEden() {
        while (this.eden.size() > this.maxEdenSize) {
            OCachePointer pointer;
            boolean removed;
            int victimFrequency;
            OCacheEntry candidate = this.eden.poll();
            assert (candidate != null);
            if (this.probation.size() + this.protection.size() < this.maxSecondLevelSize) {
                this.probation.moveToTheTail(candidate);
                continue;
            }
            OCacheEntry victim = this.probation.peek();
            int candidateKeyHashCode = PageKey.hashCode(candidate.getFileId(), candidate.getPageIndex());
            int victimKeyHashCode = PageKey.hashCode(victim.getFileId(), victim.getPageIndex());
            int candidateFrequency = this.admittor.frequency(candidateKeyHashCode);
            if (candidateFrequency >= (victimFrequency = this.admittor.frequency(victimKeyHashCode))) {
                this.probation.poll();
                this.probation.moveToTheTail(candidate);
                if (victim.freeze()) {
                    removed = this.data.remove(new PageKey(victim.getFileId(), victim.getPageIndex()), victim);
                    victim.makeDead();
                    if (removed) {
                        this.cacheSize.decrementAndGet();
                    }
                    pointer = victim.getCachePointer();
                    pointer.decrementReadersReferrer();
                    victim.clearCachePointer();
                    continue;
                }
                this.eden.moveToTheTail(victim);
                continue;
            }
            if (candidate.freeze()) {
                removed = this.data.remove(new PageKey(candidate.getFileId(), candidate.getPageIndex()), candidate);
                candidate.makeDead();
                if (removed) {
                    this.cacheSize.decrementAndGet();
                }
                pointer = candidate.getCachePointer();
                pointer.decrementReadersReferrer();
                candidate.clearCachePointer();
                continue;
            }
            this.eden.moveToTheTail(candidate);
        }
        assert (this.protection.size() <= this.maxProtectedSize);
    }

    void onRemove(OCacheEntry cacheEntry) {
        assert (cacheEntry.isFrozen());
        if (this.probation.contains(cacheEntry)) {
            this.probation.remove(cacheEntry);
        } else if (this.protection.contains(cacheEntry)) {
            this.protection.remove(cacheEntry);
        } else if (this.eden.contains(cacheEntry)) {
            this.eden.remove(cacheEntry);
        }
        cacheEntry.makeDead();
        OCachePointer cachePointer = cacheEntry.getCachePointer();
        cachePointer.decrementReadersReferrer();
        cacheEntry.clearCachePointer();
    }

    private void calculateMaxSizes() {
        this.maxEdenSize = this.maxSize * 20 / 100;
        this.maxProtectedSize = this.maxSize - this.maxEdenSize - (this.maxSize - this.maxEdenSize) * 20 / 100;
        this.maxSecondLevelSize = this.maxSize - this.maxEdenSize;
    }

    Iterator<OCacheEntry> eden() {
        return this.eden.iterator();
    }

    Iterator<OCacheEntry> protection() {
        return this.protection.iterator();
    }

    Iterator<OCacheEntry> probation() {
        return this.probation.iterator();
    }

    void assertSize() {
        assert (this.eden.size() + this.probation.size() + this.protection.size() == this.cacheSize.get() && this.data.size() == this.cacheSize.get() && this.cacheSize.get() <= this.maxSize);
    }

    void assertConsistency() {
        for (OCacheEntry cacheEntry : this.data.values()) {
            assert (this.eden.contains(cacheEntry) || this.protection.contains(cacheEntry) || this.probation.contains(cacheEntry));
        }
        int counter = 0;
        for (OCacheEntry cacheEntry : this.eden) {
            assert (this.data.get(new PageKey(cacheEntry.getFileId(), cacheEntry.getPageIndex())) == cacheEntry);
            ++counter;
        }
        for (OCacheEntry cacheEntry : this.probation) {
            assert (this.data.get(new PageKey(cacheEntry.getFileId(), cacheEntry.getPageIndex())) == cacheEntry);
            ++counter;
        }
        for (OCacheEntry cacheEntry : this.protection) {
            assert (this.data.get(new PageKey(cacheEntry.getFileId(), cacheEntry.getPageIndex())) == cacheEntry);
            ++counter;
        }
        assert (counter == this.data.size());
    }
}

