/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local.aoc;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class FileMap {
    private static final int MAX_PAGE_SIZE = 127;
    private static final int MAX_PAGE_VERSION = 0xFFFFFF;
    public static final byte DATA_PAGE = 0;
    public static final byte DELTA_PAGE = 1;
    private final AtomicReferenceArray<AtomicLongArray> container = new AtomicReferenceArray(32);
    private final AtomicInteger size = new AtomicInteger();

    public int allocateNewPage() {
        int index = this.size.getAndIncrement();
        long mappingEntry = this.mappingEntry(-1, 0, (byte)0, 0);
        this.doSet(index, mappingEntry);
        return index;
    }

    public void setMapping(int index, int physicalPageIndex, int pageSize, byte pageType, int pageVersion) {
        this.checkFileSize(index);
        this.validateData(physicalPageIndex, pageSize, pageType, pageVersion);
        long mappingEntry = this.mappingEntry(physicalPageIndex, pageSize, pageType, pageVersion);
        this.doSet(index, mappingEntry);
    }

    private void validateData(int physicalPageIndex, int pageSize, byte pageType, int pageVersion) {
        if (physicalPageIndex < 0) {
            throw new IllegalArgumentException("Invalid value of physical page index " + physicalPageIndex);
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Invalid value of page size " + pageSize);
        }
        if (pageSize > 127) {
            throw new IllegalArgumentException("Value of page size can not exceed 127");
        }
        if (pageType != 0 && pageType != 1) {
            throw new IllegalArgumentException("Invalid value of page type " + pageType);
        }
        if (pageVersion > 0xFFFFFF) {
            throw new IllegalArgumentException("Value of page version can not exceed " + pageVersion);
        }
        if (pageVersion < 0) {
            throw new IllegalArgumentException("Invalid value of page version " + pageVersion);
        }
    }

    public int getSize() {
        return this.size.get();
    }

    public int[] mappingData(int index) {
        int currentSize = this.size.get();
        if (index >= currentSize) {
            return null;
        }
        long mappingEntry = this.doGet(index);
        return this.mappingData(mappingEntry);
    }

    private void checkFileSize(int index) {
        int currentSize = this.size.get();
        if (index >= this.size.get()) {
            throw new IllegalArgumentException("Attempt to access index outside of file size. File size: " + currentSize + ", index " + index);
        }
    }

    private void doSet(int index, long value) {
        int containerIndex = 31 - Integer.numberOfLeadingZeros(index + 1);
        AtomicLongArray array = this.container.get(containerIndex);
        while (array == null) {
            AtomicLongArray newArray = new AtomicLongArray(1 << containerIndex);
            if (!this.container.compareAndSet(containerIndex, null, newArray)) continue;
            array = newArray;
        }
        int arrayIndex = index - ((1 << containerIndex) - 1);
        array.set(arrayIndex, value);
    }

    private long doGet(int index) {
        int containerIndex = 31 - Integer.numberOfLeadingZeros(index + 1);
        AtomicLongArray array = this.container.get(containerIndex);
        if (array == null) {
            throw new IllegalArgumentException("Attempt to access outside of file, index " + index);
        }
        int arrayIndex = index - ((1 << containerIndex) - 1);
        return array.get(arrayIndex);
    }

    private long mappingEntry(int pageIndex, int pageSize, byte pageType, int pageVersion) {
        return 0xFFFFFFFFL & (long)pageIndex | (long)pageSize << 32 | (long)pageType << 39 | (long)pageVersion << 40;
    }

    private int[] mappingData(long mappingEntry) {
        int pageIndex = (int)mappingEntry;
        int pageSize = (int)(0x7FL & mappingEntry >>> 32);
        int pageType = (int)(1L & mappingEntry >>> 39);
        int pageVersion = (int)(mappingEntry >>> 40);
        return new int[]{pageIndex, pageSize, pageType, pageVersion};
    }
}

