/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cluster;

import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpositionmapbucket.ClusterPositionMapBucketAddPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpositionmapbucket.ClusterPositionMapBucketAllocatePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpositionmapbucket.ClusterPositionMapBucketInitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpositionmapbucket.ClusterPositionMapBucketTruncateLastEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpositionmapbucket.ClusterPositionMapBucketUpdateEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpositionmapbucket.ClusterPositionMapBucketUpdateStatusPO;
import java.util.Objects;

public final class OClusterPositionMapBucket
extends ODurablePage {
    private static final int NEXT_PAGE_OFFSET = 28;
    private static final int SIZE_OFFSET = 36;
    private static final int POSITIONS_OFFSET = 40;
    public static final byte NOT_EXISTENT = 0;
    public static final byte REMOVED = 1;
    public static final byte FILLED = 2;
    public static final byte ALLOCATED = 4;
    private static final int ENTRY_SIZE = 13;
    public static final int MAX_ENTRIES = (MAX_PAGE_SIZE_BYTES - 40) / 13;

    public OClusterPositionMapBucket(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init() {
        this.setIntValue(36, 0);
        this.addPageOperation(new ClusterPositionMapBucketInitPO());
    }

    public int add(long pageIndex, int recordPosition) {
        return this.add((int)pageIndex, recordPosition, (byte)2);
    }

    public int add(int pageIndex, int recordPosition, byte status) {
        int size = this.getIntValue(36);
        int position = OClusterPositionMapBucket.entryPosition(size);
        position += this.setByteValue(position, status);
        position += this.setLongValue(position, pageIndex);
        this.setIntValue(position, recordPosition);
        this.setIntValue(36, size + 1);
        this.addPageOperation(new ClusterPositionMapBucketAddPO(pageIndex, recordPosition, status));
        return size;
    }

    public int allocate() {
        int size = this.getIntValue(36);
        int position = OClusterPositionMapBucket.entryPosition(size);
        position += this.setByteValue(position, (byte)4);
        position += this.setLongValue(position, -1L);
        this.setIntValue(position, -1);
        this.setIntValue(36, size + 1);
        this.addPageOperation(new ClusterPositionMapBucketAllocatePO());
        return size;
    }

    public void truncateLastEntry() {
        int size = this.getIntValue(36);
        int position = OClusterPositionMapBucket.entryPosition(size - 1);
        byte status = this.getByteValue(position);
        int pageIndex = (int)this.getLongValue(++position);
        int recordPosition = this.getIntValue(position += 8);
        this.setIntValue(36, size - 1);
        this.addPageOperation(new ClusterPositionMapBucketTruncateLastEntryPO(status, pageIndex, recordPosition));
    }

    public PositionEntry get(int index) {
        int size = this.getIntValue(36);
        if (index >= size) {
            return null;
        }
        int position = OClusterPositionMapBucket.entryPosition(index);
        if (this.getByteValue(position) != 2) {
            return null;
        }
        return this.readEntry(position);
    }

    public void set(int index, PositionEntry entry) {
        int size = this.getIntValue(36);
        if (index >= size) {
            throw new OStorageException("Provided index " + index + " is out of range");
        }
        int position = OClusterPositionMapBucket.entryPosition(index);
        byte flag = this.getByteValue(position);
        if (flag == 4) {
            flag = 2;
        } else if (flag != 2) {
            throw new OStorageException("Provided index " + index + " points to removed entry");
        }
        this.updateEntry(index, (int)entry.pageIndex, entry.recordPosition, flag);
    }

    public void updateEntry(int index, int pageIndex, int recordPosition, byte status) {
        int position = OClusterPositionMapBucket.entryPosition(index);
        byte oldStatus = this.getByteValue(position);
        int oldPageIndex = this.getIntValue(position + 1);
        int oldRecordPosition = this.getIntValue(position + 1 + 8);
        this.setByteValue(position, status);
        this.setLongValue(position + 1, pageIndex);
        this.setIntValue(position + 1 + 8, recordPosition);
        this.addPageOperation(new ClusterPositionMapBucketUpdateEntryPO(index, oldStatus, oldPageIndex, oldRecordPosition, status, pageIndex, recordPosition));
    }

    private static int entryPosition(int index) {
        return index * 13 + 40;
    }

    public boolean isFull() {
        return this.getIntValue(36) == MAX_ENTRIES;
    }

    public int getSize() {
        return this.getIntValue(36);
    }

    public void remove(int index) {
        int size = this.getIntValue(36);
        if (index >= size) {
            return;
        }
        int position = OClusterPositionMapBucket.entryPosition(index);
        if (this.getByteValue(position) != 2) {
            return;
        }
        this.updateStatus(index, (byte)1);
    }

    public void updateStatus(int index, byte status) {
        int position = OClusterPositionMapBucket.entryPosition(index);
        byte oldStatus = this.getByteValue(position);
        this.setByteValue(position, status);
        this.addPageOperation(new ClusterPositionMapBucketUpdateStatusPO(index, oldStatus, status));
    }

    private PositionEntry readEntry(int position) {
        long pageIndex = this.getLongValue(++position);
        int pagePosition = this.getIntValue(position += 8);
        return new PositionEntry(pageIndex, pagePosition);
    }

    public boolean exists(int index) {
        int size = this.getIntValue(36);
        if (index >= size) {
            return false;
        }
        int position = OClusterPositionMapBucket.entryPosition(index);
        return this.getByteValue(position) == 2;
    }

    public byte getStatus(int index) {
        int size = this.getIntValue(36);
        if (index >= size) {
            return 0;
        }
        int position = OClusterPositionMapBucket.entryPosition(index);
        return this.getByteValue(position);
    }

    public static final class PositionEntry {
        private final long pageIndex;
        private final int recordPosition;

        public PositionEntry(long pageIndex, int recordPosition) {
            this.pageIndex = pageIndex;
            this.recordPosition = recordPosition;
        }

        public long getPageIndex() {
            return this.pageIndex;
        }

        public int getRecordPosition() {
            return this.recordPosition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PositionEntry that = (PositionEntry)o;
            return this.pageIndex == that.pageIndex && this.recordPosition == that.recordPosition;
        }

        public int hashCode() {
            return Objects.hash(this.pageIndex, this.recordPosition);
        }

        public String toString() {
            return "PositionEntry{pageIndex=" + this.pageIndex + ", recordPosition=" + this.recordPosition + '}';
        }
    }
}

