/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cluster.v0;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v0.paginatedclusterstate.PaginatedClusterStateV0SetFreeListPagePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v0.paginatedclusterstate.PaginatedClusterStateV0SetRecordsSizePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v0.paginatedclusterstate.PaginatedClusterStateV0SetSizePO;

public final class OPaginatedClusterStateV0
extends ODurablePage {
    private static final int RECORDS_SIZE_OFFSET = 28;
    private static final int SIZE_OFFSET = 36;
    private static final int FREE_LIST_OFFSET = 44;

    public OPaginatedClusterStateV0(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void setSize(long size) {
        long oldSize = this.getLongValue(36);
        this.setLongValue(36, size);
        this.addPageOperation(new PaginatedClusterStateV0SetSizePO(oldSize, size));
    }

    public long getSize() {
        return this.getLongValue(36);
    }

    public void setRecordsSize(long recordsSize) {
        long oldRecordsSize = this.getLongValue(28);
        this.setLongValue(28, recordsSize);
        this.addPageOperation(new PaginatedClusterStateV0SetRecordsSizePO(oldRecordsSize, recordsSize));
    }

    public long getRecordsSize() {
        return this.getLongValue(28);
    }

    public void setFreeListPage(int index, long pageIndex) {
        int pageOffset = 44 + index * 8;
        int oldPageIndex = (int)this.getLongValue(pageOffset);
        this.setLongValue(pageOffset, pageIndex);
        this.addPageOperation(new PaginatedClusterStateV0SetFreeListPagePO(index, oldPageIndex, (int)pageIndex));
    }

    public long getFreeListPage(int index) {
        return this.getLongValue(44 + index * 8);
    }
}

