/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cluster.v2;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.exception.NotEmptyComponentCanNotBeRemovedException;
import com.orientechnologies.orient.core.exception.OPaginatedClusterException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPage;
import com.orientechnologies.orient.core.storage.cluster.OClusterPageDebug;
import com.orientechnologies.orient.core.storage.cluster.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedCluster;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedClusterDebug;
import com.orientechnologies.orient.core.storage.cluster.v2.OClusterPositionMapV2;
import com.orientechnologies.orient.core.storage.cluster.v2.OPaginatedClusterStateV2;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OClusterBrowseEntry;
import com.orientechnologies.orient.core.storage.impl.local.OClusterBrowsePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class OPaginatedClusterV2
extends OPaginatedCluster {
    private static final int STATE_ENTRY_INDEX = 0;
    private static final int BINARY_VERSION = 2;
    private final boolean addRidMetadata = OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getValueAsBoolean();
    private static final int DISK_PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger();
    private static final int LOWEST_FREELIST_BOUNDARY = OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger();
    private static final int FREE_LIST_SIZE = DISK_PAGE_SIZE - LOWEST_FREELIST_BOUNDARY;
    private static final int PAGE_INDEX_OFFSET = 16;
    private static final int RECORD_POSITION_MASK = 65535;
    private static final int ONE_KB = 1024;
    private final boolean systemCluster;
    private final OClusterPositionMapV2 clusterPositionMap;
    private volatile int id;
    private long fileId;
    private ORecordConflictStrategy recordConflictStrategy;

    public OPaginatedClusterV2(String name, OAbstractPaginatedStorage storage) {
        this(name, ".pcl", ".cpm", storage);
    }

    public OPaginatedClusterV2(String name, String dataExtension, String cpmExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataExtension, name + dataExtension);
        this.systemCluster = OMetadataInternal.SYSTEM_CLUSTER.contains(name);
        this.clusterPositionMap = new OClusterPositionMapV2(storage, this.getName(), this.getFullName(), cpmExtension);
    }

    @Override
    public void configure(int id, String clusterName) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.init(id, clusterName, null);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean exists() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            boolean bl;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                bl = this.isFileExists(atomicOperation, this.getFullName());
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return bl;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public int getBinaryVersion() {
        return 2;
    }

    @Override
    public OStoragePaginatedClusterConfiguration generateClusterConfig() {
        this.acquireSharedLock();
        try {
            OStoragePaginatedClusterConfiguration oStoragePaginatedClusterConfiguration = new OStoragePaginatedClusterConfiguration(this.id, this.getName(), null, true, 1.2f, 1.2f, null, null, null, Optional.ofNullable(this.recordConflictStrategy).map(ORecordConflictStrategy::getName).orElse(null), OStorageClusterConfiguration.STATUS.ONLINE, 2);
            return oStoragePaginatedClusterConfiguration;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void configure(OStorage storage, OStorageClusterConfiguration config) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.init(config.getId(), config.getName(), ((OStoragePaginatedClusterConfiguration)config).conflictStrategy);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void create(OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                this.initCusterState(atomicOperation);
                this.clusterPositionMap.create(atomicOperation);
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
            this.fileId = this.openFile(atomicOperation, this.getFullName());
            this.clusterPositionMap.open(atomicOperation);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void close(boolean flush) {
        this.acquireExclusiveLock();
        try {
            if (flush) {
                this.synch();
            }
            this.readCache.closeFile(this.fileId, flush, this.writeCache);
            this.clusterPositionMap.close(flush);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void delete(OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                long entries = this.getEntries();
                if (entries > 0L) {
                    throw new NotEmptyComponentCanNotBeRemovedException(this.getName() + " : Not empty cluster can not be deleted. Cluster has " + entries + " records");
                }
                this.deleteFile(atomicOperation, this.fileId);
                this.clusterPositionMap.delete(atomicOperation);
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public boolean isSystemCluster() {
        return this.systemCluster;
    }

    @Override
    public String compression() {
        this.acquireSharedLock();
        try {
            String string = null;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String encryption() {
        this.acquireSharedLock();
        try {
            String string = null;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition allocatePosition(byte recordType, OAtomicOperation atomicOperation) {
        return this.calculateInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                OPhysicalPosition pos;
                OPhysicalPosition oPhysicalPosition = pos = OPaginatedClusterV2.createPhysicalPosition(recordType, this.clusterPositionMap.allocate(atomicOperation), -1);
                return oPhysicalPosition;
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public OPhysicalPosition createRecord(byte[] content, int recordVersion, byte recordType, OPhysicalPosition allocatedPosition, OAtomicOperation atomicOperation) {
        return this.calculateInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                long clusterPosition;
                int entryContentLength = OPaginatedClusterV2.getEntryContentLength(content.length);
                if (entryContentLength < OClusterPage.MAX_RECORD_SIZE) {
                    long clusterPosition2;
                    byte[] entryContent = new byte[entryContentLength];
                    int entryPosition = 0;
                    entryContent[entryPosition] = recordType;
                    OIntegerSerializer.INSTANCE.serializeNative(content.length, entryContent, ++entryPosition, new Object[0]);
                    System.arraycopy(content, 0, entryContent, entryPosition += 4, content.length);
                    entryContent[entryPosition += content.length] = 1;
                    OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, ++entryPosition, new Object[0]);
                    AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                    this.updateClusterState(1L, addEntryResult.recordsSizeDiff, atomicOperation);
                    if (allocatedPosition != null) {
                        this.clusterPositionMap.update(allocatedPosition.clusterPosition, new OClusterPositionMapBucket.PositionEntry(addEntryResult.pageIndex, addEntryResult.pagePosition), atomicOperation);
                        clusterPosition2 = allocatedPosition.clusterPosition;
                    } else {
                        clusterPosition2 = this.clusterPositionMap.add(addEntryResult.pageIndex, addEntryResult.pagePosition, atomicOperation);
                    }
                    OPhysicalPosition oPhysicalPosition = OPaginatedClusterV2.createPhysicalPosition(recordType, clusterPosition2, addEntryResult.recordVersion);
                    return oPhysicalPosition;
                }
                int entrySize = content.length + 4 + 1;
                int fullEntryPosition = 0;
                byte[] fullEntry = new byte[entrySize];
                fullEntry[fullEntryPosition] = recordType;
                OIntegerSerializer.INSTANCE.serializeNative(content.length, fullEntry, ++fullEntryPosition, new Object[0]);
                System.arraycopy(content, 0, fullEntry, fullEntryPosition += 4, content.length);
                long prevPageRecordPointer = -1L;
                long firstPageIndex = -1L;
                int firstPagePosition = -1;
                int version = 0;
                int from = 0;
                int to = from + (OClusterPage.MAX_RECORD_SIZE - 1 - 8);
                int recordsSizeDiff = 0;
                do {
                    byte[] entryContent = new byte[to - from + 1 + 8];
                    System.arraycopy(fullEntry, from, entryContent, 0, to - from);
                    entryContent[entryContent.length - 8 - 1] = from > 0 ? (byte)0 : (byte)1;
                    OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, entryContent.length - 8, new Object[0]);
                    AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                    recordsSizeDiff += addEntryResult.recordsSizeDiff;
                    if (firstPageIndex == -1L) {
                        firstPageIndex = addEntryResult.pageIndex;
                        firstPagePosition = addEntryResult.pagePosition;
                        version = addEntryResult.recordVersion;
                    }
                    long addedPagePointer = OPaginatedClusterV2.createPagePointer(addEntryResult.pageIndex, addEntryResult.pagePosition);
                    if (prevPageRecordPointer >= 0L) {
                        long prevPageIndex = OPaginatedClusterV2.getPageIndex(prevPageRecordPointer);
                        int prevPageRecordPosition = OPaginatedClusterV2.getRecordPosition(prevPageRecordPointer);
                        OCacheEntry prevPageCacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false, true);
                        try {
                            OClusterPage prevPage = new OClusterPage(prevPageCacheEntry);
                            prevPage.setRecordLongValue(prevPageRecordPosition, -8, addedPagePointer);
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, prevPageCacheEntry);
                        }
                    }
                    prevPageRecordPointer = addedPagePointer;
                    from = to;
                    if ((to += OClusterPage.MAX_RECORD_SIZE - 8 - 1) <= fullEntry.length) continue;
                    to = fullEntry.length;
                } while (from < to);
                this.updateClusterState(1L, recordsSizeDiff, atomicOperation);
                if (allocatedPosition != null) {
                    this.clusterPositionMap.update(allocatedPosition.clusterPosition, new OClusterPositionMapBucket.PositionEntry(firstPageIndex, firstPagePosition), atomicOperation);
                    clusterPosition = allocatedPosition.clusterPosition;
                } else {
                    clusterPosition = this.clusterPositionMap.add(firstPageIndex, firstPagePosition, atomicOperation);
                }
                OPhysicalPosition oPhysicalPosition = OPaginatedClusterV2.createPhysicalPosition(recordType, clusterPosition, version);
                return oPhysicalPosition;
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    private static int getEntryContentLength(int grownContentSize) {
        return grownContentSize + 2 + 4 + 8;
    }

    @Override
    public ORawBuffer readRecord(long clusterPosition, boolean prefetchRecords) throws IOException {
        int pagesToPrefetch = 1;
        if (prefetchRecords) {
            pagesToPrefetch = OGlobalConfiguration.QUERY_SCAN_PREFETCH_PAGES.getValueAsInteger();
        }
        return this.readRecord(clusterPosition, pagesToPrefetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer readRecord(long clusterPosition, int pageCount) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OClusterPositionMapBucket.PositionEntry positionEntry;
            OAtomicOperation atomicOperation;
            block8: {
                ORawBuffer oRawBuffer;
                this.acquireSharedLock();
                try {
                    atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    positionEntry = this.clusterPositionMap.get(clusterPosition, pageCount, atomicOperation);
                    if (positionEntry != null) break block8;
                    oRawBuffer = null;
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oRawBuffer;
            }
            ORawBuffer oRawBuffer = this.internalReadRecord(clusterPosition, positionEntry.getPageIndex(), positionEntry.getRecordPosition(), pageCount, atomicOperation);
            this.releaseSharedLock();
            return oRawBuffer;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer internalReadRecord(long clusterPosition, long pageIndex, int recordPosition, int pageCount, OAtomicOperation atomicOperation) throws IOException {
        int recordVersion;
        if (pageCount > 1) {
            OCacheEntry stateCacheEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, false);
            try {
                OPaginatedClusterStateV2 state = new OPaginatedClusterStateV2(stateCacheEntry);
                pageCount = (int)Math.min((long)(state.getFileSize() + 1) - pageIndex, (long)pageCount);
            }
            finally {
                this.releasePageFromRead(atomicOperation, stateCacheEntry);
            }
        }
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, pageCount);
        try {
            OClusterPage localPage = new OClusterPage(cacheEntry);
            recordVersion = localPage.getRecordVersion(recordPosition);
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
        byte[] fullContent = this.readFullEntry(clusterPosition, pageIndex, recordPosition, atomicOperation, pageCount);
        if (fullContent == null) {
            return null;
        }
        int fullContentPosition = 0;
        byte recordType = fullContent[fullContentPosition];
        int readContentSize = OIntegerSerializer.INSTANCE.deserializeNative(fullContent, ++fullContentPosition);
        byte[] recordContent = Arrays.copyOfRange(fullContent, fullContentPosition += 4, fullContentPosition + readContentSize);
        return new ORawBuffer(recordContent, recordVersion, recordType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORawBuffer readRecordIfVersionIsNotLatest(long clusterPosition, int recordVersion) throws IOException, ORecordNotFoundException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            ORawBuffer oRawBuffer;
            block14: {
                this.acquireSharedLock();
                try {
                    int loadedRecordVersion;
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1, atomicOperation);
                    if (positionEntry == null) {
                        throw new ORecordNotFoundException(new ORecordId(this.id, clusterPosition), "Record for cluster with id " + this.id + " and position " + clusterPosition + " is absent.");
                    }
                    int recordPosition = positionEntry.getRecordPosition();
                    long pageIndex = positionEntry.getPageIndex();
                    OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry);
                        if (localPage.isDeleted(recordPosition)) {
                            throw new ORecordNotFoundException(new ORecordId(this.id, clusterPosition), "Record for cluster with id " + this.id + " and position " + clusterPosition + " is absent.");
                        }
                        loadedRecordVersion = localPage.getRecordVersion(recordPosition);
                    }
                    finally {
                        this.releasePageFromRead(atomicOperation, cacheEntry);
                    }
                    if (loadedRecordVersion <= recordVersion) break block14;
                    oRawBuffer = this.readRecord(clusterPosition, false);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oRawBuffer;
            }
            oRawBuffer = null;
            this.releaseSharedLock();
            return oRawBuffer;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public boolean deleteRecord(OAtomicOperation atomicOperation, long clusterPosition) {
        return this.calculateInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                long nextPagePointer;
                OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1, atomicOperation);
                if (positionEntry == null) {
                    Boolean bl = false;
                    return bl;
                }
                long pageIndex = positionEntry.getPageIndex();
                int recordPosition = positionEntry.getRecordPosition();
                int removedContentSize = 0;
                do {
                    int initialFreePageIndex;
                    boolean cacheEntryReleased = false;
                    OCacheEntry cacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry);
                        initialFreePageIndex = OPaginatedClusterV2.calculateFreePageIndex(localPage);
                        if (localPage.isDeleted(recordPosition)) {
                            if (removedContentSize == 0) {
                                cacheEntryReleased = true;
                                this.releasePageFromWrite(atomicOperation, cacheEntry);
                                Boolean bl = false;
                                return bl;
                            }
                            throw new OPaginatedClusterException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken", this);
                        }
                        if (removedContentSize == 0) {
                            this.releasePageFromWrite(atomicOperation, cacheEntry);
                            cacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
                            localPage = new OClusterPage(cacheEntry);
                        }
                        byte[] content = localPage.deleteRecord(recordPosition, true);
                        atomicOperation.addDeletedRecordPosition(this.id, cacheEntry.getPageIndex(), recordPosition);
                        assert (content != null);
                        int initialFreeSpace = localPage.getFreeSpace();
                        localPage.deleteRecord(recordPosition, true);
                        atomicOperation.addDeletedRecordPosition(this.id, cacheEntry.getPageIndex(), recordPosition);
                        removedContentSize += localPage.getFreeSpace() - initialFreeSpace;
                        nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                    }
                    finally {
                        if (!cacheEntryReleased) {
                            this.releasePageFromWrite(atomicOperation, cacheEntry);
                        }
                    }
                    this.updateFreePagesIndex(initialFreePageIndex, pageIndex, atomicOperation);
                    pageIndex = OPaginatedClusterV2.getPageIndex(nextPagePointer);
                    recordPosition = OPaginatedClusterV2.getRecordPosition(nextPagePointer);
                } while (nextPagePointer >= 0L);
                this.updateClusterState(-1L, -removedContentSize, atomicOperation);
                this.clusterPositionMap.remove(clusterPosition, atomicOperation);
                Boolean bl = true;
                return bl;
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public void updateRecord(long clusterPosition, byte[] content, int recordVersion, byte recordType, OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                int to;
                OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1, atomicOperation);
                if (positionEntry == null) {
                    return;
                }
                int nextRecordPosition = positionEntry.getRecordPosition();
                long nextPageIndex = positionEntry.getPageIndex();
                int newRecordPosition = -1;
                long newPageIndex = -1L;
                long prevPageIndex = -1L;
                int prevRecordPosition = -1;
                long nextEntryPointer = -1L;
                int from = 0;
                long sizeDiff = 0L;
                byte[] updateEntry = null;
                do {
                    int updatedEntryPosition;
                    OCacheEntry cacheEntry;
                    boolean isNew;
                    int entrySize;
                    if (updateEntry == null) {
                        if (from == 0) {
                            entrySize = Math.min(OPaginatedClusterV2.getEntryContentLength(content.length), OClusterPage.MAX_RECORD_SIZE);
                            to = entrySize - 14;
                        } else {
                            entrySize = Math.min(content.length - from + 1 + 8, OClusterPage.MAX_RECORD_SIZE);
                            to = from + entrySize - 9;
                        }
                        updateEntry = new byte[entrySize];
                        int entryPosition = 0;
                        if (from == 0) {
                            updateEntry[entryPosition] = recordType;
                            OIntegerSerializer.INSTANCE.serializeNative(content.length, updateEntry, ++entryPosition, new Object[0]);
                            entryPosition += 4;
                        }
                        System.arraycopy(content, from, updateEntry, entryPosition, to - from);
                        entryPosition += to - from;
                        if (nextPageIndex == positionEntry.getPageIndex()) {
                            updateEntry[entryPosition] = 1;
                        }
                        OLongSerializer.INSTANCE.serializeNative(-1L, updateEntry, ++entryPosition, new Object[0]);
                        assert (to >= content.length || entrySize == OClusterPage.MAX_RECORD_SIZE);
                    } else {
                        entrySize = updateEntry.length;
                        to = from == 0 ? entrySize - 14 : from + entrySize - 9;
                    }
                    int freePageIndex = -1;
                    if (nextPageIndex < 0L) {
                        FindFreePageResult findFreePageResult = this.findFreePage(entrySize, atomicOperation);
                        nextPageIndex = findFreePageResult.pageIndex;
                        freePageIndex = findFreePageResult.freePageIndex;
                        isNew = findFreePageResult.allocateNewPage;
                    } else {
                        isNew = false;
                    }
                    if (isNew) {
                        OCacheEntry stateCacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
                        try {
                            OPaginatedClusterStateV2 clusterState = new OPaginatedClusterStateV2(stateCacheEntry);
                            int fileSize = clusterState.getFileSize();
                            long filledUpTo = this.getFilledUpTo(atomicOperation, this.fileId);
                            if ((long)fileSize == filledUpTo - 1L) {
                                cacheEntry = this.addPage(atomicOperation, this.fileId);
                            } else {
                                assert ((long)fileSize < filledUpTo - 1L);
                                cacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, fileSize + 1, false, false);
                            }
                            clusterState.setFileSize(fileSize + 1);
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, stateCacheEntry);
                        }
                    } else {
                        cacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, nextPageIndex, false, true);
                    }
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry);
                        if (isNew) {
                            localPage.init();
                        }
                        int pageFreeSpace = localPage.getFreeSpace();
                        if (freePageIndex < 0) {
                            freePageIndex = OPaginatedClusterV2.calculateFreePageIndex(localPage);
                        } else assert (isNew || freePageIndex == OPaginatedClusterV2.calculateFreePageIndex(localPage));
                        if (nextRecordPosition >= 0) {
                            if (localPage.isDeleted(nextRecordPosition)) {
                                throw new OPaginatedClusterException("Record with rid " + new ORecordId(this.id, clusterPosition) + " was deleted", this);
                            }
                            int currentEntrySize = localPage.getRecordSize(nextRecordPosition);
                            nextEntryPointer = localPage.getRecordLongValue(nextRecordPosition, currentEntrySize - 8);
                            if (currentEntrySize == entrySize) {
                                localPage.replaceRecord(nextRecordPosition, updateEntry, recordVersion);
                                updatedEntryPosition = nextRecordPosition;
                            } else {
                                localPage.deleteRecord(nextRecordPosition, true);
                                atomicOperation.addDeletedRecordPosition(this.id, cacheEntry.getPageIndex(), nextRecordPosition);
                                updatedEntryPosition = localPage.getMaxRecordSize() >= entrySize ? localPage.appendRecord(recordVersion, updateEntry, -1, atomicOperation.getBookedRecordPositions(this.id, cacheEntry.getPageIndex())) : -1;
                            }
                            if (nextEntryPointer >= 0L) {
                                nextRecordPosition = OPaginatedClusterV2.getRecordPosition(nextEntryPointer);
                                nextPageIndex = OPaginatedClusterV2.getPageIndex(nextEntryPointer);
                            } else {
                                nextPageIndex = -1L;
                                nextRecordPosition = -1;
                            }
                        } else {
                            assert (localPage.getFreeSpace() >= entrySize);
                            updatedEntryPosition = localPage.appendRecord(recordVersion, updateEntry, -1, atomicOperation.getBookedRecordPositions(this.id, cacheEntry.getPageIndex()));
                            nextPageIndex = -1L;
                            nextRecordPosition = -1;
                        }
                        sizeDiff += (long)(pageFreeSpace - localPage.getFreeSpace());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    this.updateFreePagesIndex(freePageIndex, cacheEntry.getPageIndex(), atomicOperation);
                    if (updatedEntryPosition < 0) continue;
                    if (from == 0) {
                        newPageIndex = cacheEntry.getPageIndex();
                        newRecordPosition = updatedEntryPosition;
                    }
                    from = to;
                    if (prevPageIndex >= 0L) {
                        OCacheEntry prevCacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false, true);
                        try {
                            OClusterPage prevPage = new OClusterPage(prevCacheEntry);
                            prevPage.setRecordLongValue(prevRecordPosition, -8, OPaginatedClusterV2.createPagePointer(cacheEntry.getPageIndex(), updatedEntryPosition));
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, prevCacheEntry);
                        }
                    }
                    prevPageIndex = cacheEntry.getPageIndex();
                    prevRecordPosition = updatedEntryPosition;
                    updateEntry = null;
                } while (to < content.length || updateEntry != null);
                while (nextEntryPointer >= 0L) {
                    int freePagesIndex;
                    nextPageIndex = OPaginatedClusterV2.getPageIndex(nextEntryPointer);
                    nextRecordPosition = OPaginatedClusterV2.getRecordPosition(nextEntryPointer);
                    OCacheEntry cacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, nextPageIndex, false, true);
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry);
                        int freeSpace = localPage.getFreeSpace();
                        freePagesIndex = OPaginatedClusterV2.calculateFreePageIndex(localPage);
                        nextEntryPointer = localPage.getRecordLongValue(nextRecordPosition, -8);
                        localPage.deleteRecord(nextRecordPosition, true);
                        atomicOperation.addDeletedRecordPosition(this.id, cacheEntry.getPageIndex(), nextRecordPosition);
                        sizeDiff += (long)(freeSpace - localPage.getFreeSpace());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    this.updateFreePagesIndex(freePagesIndex, nextPageIndex, atomicOperation);
                }
                assert (newPageIndex >= 0L);
                assert (newRecordPosition >= 0);
                if (newPageIndex != positionEntry.getPageIndex() || newRecordPosition != positionEntry.getRecordPosition()) {
                    this.clusterPositionMap.update(clusterPosition, new OClusterPositionMapBucket.PositionEntry(newPageIndex, newRecordPosition), atomicOperation);
                }
                this.updateClusterState(0L, sizeDiff, atomicOperation);
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public long getTombstonesCount() {
        return 0L;
    }

    /*
     * Exception decompiling
     */
    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isDeleted(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getEntries() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFirstPosition() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long l;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                l = this.clusterPositionMap.getFirstPosition(atomicOperation);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastPosition() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long l;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                l = this.clusterPositionMap.getLastPosition(atomicOperation);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextPosition() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long l;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                l = this.clusterPositionMap.getNextPosition(atomicOperation);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public String getFileName() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            String string;
            this.acquireSharedLock();
            try {
                string = this.writeCache.fileNameById(this.fileId);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return string;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public long getFileId() {
        return this.fileId;
    }

    @Override
    public void synch() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                this.writeCache.flush(this.fileId);
                this.clusterPositionMap.flush();
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getRecordsSize() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                long[] clusterPositions = this.clusterPositionMap.higherPositions(position.clusterPosition, atomicOperation);
                oPhysicalPositionArray = OPaginatedClusterV2.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                long[] clusterPositions = this.clusterPositionMap.ceilingPositions(position.clusterPosition, atomicOperation);
                oPhysicalPositionArray = OPaginatedClusterV2.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                long[] clusterPositions = this.clusterPositionMap.lowerPositions(position.clusterPosition, atomicOperation);
                oPhysicalPositionArray = OPaginatedClusterV2.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                long[] clusterPositions = this.clusterPositionMap.floorPositions(position.clusterPosition, atomicOperation);
                oPhysicalPositionArray = OPaginatedClusterV2.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public ORecordConflictStrategy getRecordConflictStrategy() {
        return this.recordConflictStrategy;
    }

    @Override
    public void setRecordConflictStrategy(String stringValue) {
        this.acquireExclusiveLock();
        try {
            this.recordConflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(stringValue);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClusterState(long sizeDiff, long recordsSizeDiff, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            OPaginatedClusterStateV2 paginatedClusterState = new OPaginatedClusterStateV2(pinnedStateEntry);
            paginatedClusterState.setSize((int)((long)paginatedClusterState.getSize() + sizeDiff));
            paginatedClusterState.setRecordsSize((int)((long)paginatedClusterState.getRecordsSize() + recordsSizeDiff));
        }
        finally {
            this.releasePageFromWrite(atomicOperation, pinnedStateEntry);
        }
    }

    private void init(int id, String name, String conflictStrategy) throws IOException {
        OFileUtils.checkValidName(name);
        if (conflictStrategy != null) {
            this.recordConflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(conflictStrategy);
        }
        this.id = id;
    }

    @Override
    public void setClusterName(String newName) {
        this.acquireExclusiveLock();
        try {
            this.writeCache.renameFile(this.fileId, newName + this.getExtension());
            this.clusterPositionMap.rename(newName);
            this.setName(newName);
        }
        catch (IOException e) {
            throw OException.wrapException(new OPaginatedClusterException("Error during renaming of cluster", this), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void setEncryption(String method, String key) {
        throw new UnsupportedOperationException("Encryption should be configured on storage level.");
    }

    private static OPhysicalPosition createPhysicalPosition(byte recordType, long clusterPosition, int version) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        physicalPosition.recordType = recordType;
        physicalPosition.recordSize = -1;
        physicalPosition.clusterPosition = clusterPosition;
        physicalPosition.recordVersion = version;
        return physicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFullEntry(long clusterPosition, long pageIndex, int recordPosition, OAtomicOperation atomicOperation, int pageCount) throws IOException {
        long nextPagePointer;
        ArrayList<byte[]> recordChunks = new ArrayList<byte[]>(2);
        int contentSize = 0;
        if (pageCount > 1) {
            OCacheEntry stateCacheEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, false);
            try {
                OPaginatedClusterStateV2 state = new OPaginatedClusterStateV2(stateCacheEntry);
                pageCount = (int)Math.min((long)(state.getFileSize() + 1) - pageIndex, (long)pageCount);
            }
            finally {
                this.releasePageFromRead(atomicOperation, stateCacheEntry);
            }
        }
        boolean firstEntry = true;
        do {
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, pageCount);
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry);
                if (localPage.isDeleted(recordPosition)) {
                    if (recordChunks.isEmpty()) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    throw new OPaginatedClusterException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken", this);
                }
                byte[] content = localPage.getRecordBinaryValue(recordPosition, 0, localPage.getRecordSize(recordPosition));
                assert (content != null);
                if (firstEntry && content[content.length - 8 - 1] == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                recordChunks.add(content);
                nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                contentSize += content.length - 8 - 1;
                firstEntry = false;
            }
            finally {
                this.releasePageFromRead(atomicOperation, cacheEntry);
            }
            pageIndex = OPaginatedClusterV2.getPageIndex(nextPagePointer);
            recordPosition = OPaginatedClusterV2.getRecordPosition(nextPagePointer);
        } while (nextPagePointer >= 0L);
        return OPaginatedClusterV2.convertRecordChunksToSingleChunk(recordChunks, contentSize);
    }

    private static byte[] convertRecordChunksToSingleChunk(List<byte[]> recordChunks, int contentSize) {
        byte[] fullContent;
        if (recordChunks.size() == 1) {
            fullContent = recordChunks.get(0);
        } else {
            fullContent = new byte[contentSize + 8 + 1];
            int fullContentPosition = 0;
            for (byte[] recordChuck : recordChunks) {
                System.arraycopy(recordChuck, 0, fullContent, fullContentPosition, recordChuck.length - 8 - 1);
                fullContentPosition += recordChuck.length - 8 - 1;
            }
        }
        return fullContent;
    }

    private static long createPagePointer(long pageIndex, int pagePosition) {
        return pageIndex << 16 | (long)pagePosition;
    }

    private static int getRecordPosition(long nextPagePointer) {
        return (int)(nextPagePointer & 0xFFFFL);
    }

    private static long getPageIndex(long nextPagePointer) {
        return nextPagePointer >>> 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddEntryResult addEntry(int recordVersion, byte[] entryContent, OAtomicOperation atomicOperation) throws IOException {
        int recordSizesDiff;
        long pageIndex;
        int position;
        int finalVersion = 0;
        do {
            OCacheEntry cacheEntry;
            FindFreePageResult findFreePageResult = this.findFreePage(entryContent.length, atomicOperation);
            int freePageIndex = findFreePageResult.freePageIndex;
            pageIndex = findFreePageResult.pageIndex;
            boolean newPage = findFreePageResult.allocateNewPage;
            if (newPage) {
                OCacheEntry stateCacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
                try {
                    OPaginatedClusterStateV2 clusterState = new OPaginatedClusterStateV2(stateCacheEntry);
                    int fileSize = clusterState.getFileSize();
                    long filledUpTo = this.getFilledUpTo(atomicOperation, this.fileId);
                    if ((long)fileSize == filledUpTo - 1L) {
                        cacheEntry = this.addPage(atomicOperation, this.fileId);
                    } else {
                        assert ((long)fileSize < filledUpTo - 1L);
                        cacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, fileSize + 1, false, false);
                    }
                    clusterState.setFileSize(fileSize + 1);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, stateCacheEntry);
                }
            } else {
                cacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
            }
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry);
                if (newPage) {
                    localPage.init();
                }
                assert (newPage || freePageIndex == OPaginatedClusterV2.calculateFreePageIndex(localPage));
                int initialFreeSpace = localPage.getFreeSpace();
                position = localPage.appendRecord(recordVersion, entryContent, -1, atomicOperation.getBookedRecordPositions(this.id, cacheEntry.getPageIndex()));
                int freeSpace = localPage.getFreeSpace();
                recordSizesDiff = initialFreeSpace - freeSpace;
                if (position >= 0) {
                    finalVersion = localPage.getRecordVersion(position);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
            this.updateFreePagesIndex(freePageIndex, pageIndex, atomicOperation);
        } while (position < 0);
        return new AddEntryResult(pageIndex, position, finalVersion, recordSizesDiff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindFreePageResult findFreePage(int contentSize, OAtomicOperation atomicOperation) throws IOException {
        boolean allocateNewPage;
        long pageIndex;
        int freePageIndex = contentSize / 1024;
        if ((freePageIndex -= OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger()) < 0) {
            freePageIndex = 0;
        }
        OCacheEntry pinnedStateEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, true);
        try {
            OPaginatedClusterStateV2 freePageLists = new OPaginatedClusterStateV2(pinnedStateEntry);
            while ((pageIndex = (long)freePageLists.getFreeListPage(freePageIndex)) < 0L && ++freePageIndex < FREE_LIST_SIZE) {
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, pinnedStateEntry);
        }
        if (pageIndex < 0L) {
            int fileSize;
            OCacheEntry stateCacheEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, false);
            try {
                OPaginatedClusterStateV2 clusterState = new OPaginatedClusterStateV2(stateCacheEntry);
                fileSize = clusterState.getFileSize();
            }
            finally {
                this.releasePageFromRead(atomicOperation, stateCacheEntry);
            }
            allocateNewPage = true;
            pageIndex = fileSize + 1;
        } else {
            allocateNewPage = false;
            --freePageIndex;
        }
        return new FindFreePageResult(pageIndex, freePageIndex, allocateNewPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesIndex(int prevFreePageIndex, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        block29: {
            OCacheEntry cacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
            try {
                long oldFreePage;
                OClusterPage localPage = new OClusterPage(cacheEntry);
                int newFreePageIndex = OPaginatedClusterV2.calculateFreePageIndex(localPage);
                if (prevFreePageIndex == newFreePageIndex) {
                    return;
                }
                long nextPageIndex = localPage.getNextPage();
                long prevPageIndex = localPage.getPrevPage();
                if (prevPageIndex >= 0L) {
                    OCacheEntry prevPageCacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false, true);
                    try {
                        OClusterPage prevPage = new OClusterPage(prevPageCacheEntry);
                        assert (OPaginatedClusterV2.calculateFreePageIndex(prevPage) == prevFreePageIndex);
                        prevPage.setNextPage(nextPageIndex);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, prevPageCacheEntry);
                    }
                }
                if (nextPageIndex >= 0L) {
                    OCacheEntry nextPageCacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, nextPageIndex, false, true);
                    try {
                        OClusterPage nextPage = new OClusterPage(nextPageCacheEntry);
                        if (OPaginatedClusterV2.calculateFreePageIndex(nextPage) != prevFreePageIndex) {
                            OPaginatedClusterV2.calculateFreePageIndex(nextPage);
                        }
                        assert (OPaginatedClusterV2.calculateFreePageIndex(nextPage) == prevFreePageIndex);
                        nextPage.setPrevPage(prevPageIndex);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, nextPageCacheEntry);
                    }
                }
                localPage.setNextPage(-1L);
                localPage.setPrevPage(-1L);
                if (prevFreePageIndex < 0 && newFreePageIndex < 0) {
                    return;
                }
                if (prevFreePageIndex >= 0 && prevFreePageIndex < FREE_LIST_SIZE && prevPageIndex < 0L) {
                    this.updateFreePagesList(prevFreePageIndex, nextPageIndex, atomicOperation);
                }
                if (newFreePageIndex < 0) break block29;
                OCacheEntry pinnedStateEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, true);
                try {
                    OPaginatedClusterStateV2 clusterFreeList = new OPaginatedClusterStateV2(pinnedStateEntry);
                    oldFreePage = clusterFreeList.getFreeListPage(newFreePageIndex);
                }
                finally {
                    this.releasePageFromRead(atomicOperation, pinnedStateEntry);
                }
                if (oldFreePage >= 0L) {
                    OCacheEntry oldFreePageCacheEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, oldFreePage, false, true);
                    try {
                        OClusterPage oldFreeLocalPage = new OClusterPage(oldFreePageCacheEntry);
                        assert (OPaginatedClusterV2.calculateFreePageIndex(oldFreeLocalPage) == newFreePageIndex);
                        oldFreeLocalPage.setPrevPage(pageIndex);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, oldFreePageCacheEntry);
                    }
                    localPage.setNextPage(oldFreePage);
                    localPage.setPrevPage(-1L);
                }
                this.updateFreePagesList(newFreePageIndex, pageIndex, atomicOperation);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesList(int freeListIndex, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, 0L, true, true);
        try {
            OPaginatedClusterStateV2 paginatedClusterState = new OPaginatedClusterStateV2(pinnedStateEntry);
            paginatedClusterState.setFreeListPage(freeListIndex, (int)pageIndex);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, pinnedStateEntry);
        }
    }

    private static int calculateFreePageIndex(OClusterPage localPage) {
        int newFreePageIndex;
        if (localPage.isEmpty()) {
            newFreePageIndex = FREE_LIST_SIZE - 1;
        } else {
            newFreePageIndex = (localPage.getMaxRecordSize() - 1023) / 1024;
            newFreePageIndex -= LOWEST_FREELIST_BOUNDARY;
        }
        return newFreePageIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCusterState(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry stateEntry = this.getFilledUpTo(atomicOperation, this.fileId) == 0L ? this.addPage(atomicOperation, this.fileId) : OPaginatedClusterV2.loadPageForWrite(atomicOperation, this.fileId, 0L, false, false);
        assert (stateEntry.getPageIndex() == 0);
        try {
            OPaginatedClusterStateV2 paginatedClusterState = new OPaginatedClusterStateV2(stateEntry);
            paginatedClusterState.setSize(0);
            paginatedClusterState.setRecordsSize(0);
            paginatedClusterState.setFileSize(0);
            for (int i = 0; i < FREE_LIST_SIZE; ++i) {
                paginatedClusterState.setFreeListPage(i, -1);
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, stateEntry);
        }
    }

    private static OPhysicalPosition[] convertToPhysicalPositions(long[] clusterPositions) {
        OPhysicalPosition[] positions = new OPhysicalPosition[clusterPositions.length];
        for (int i = 0; i < positions.length; ++i) {
            OPhysicalPosition physicalPosition = new OPhysicalPosition();
            physicalPosition.clusterPosition = clusterPositions[i];
            positions[i] = physicalPosition;
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPaginatedClusterDebug readDebug(long clusterPosition) throws IOException {
        long nextPagePointer;
        OPaginatedClusterDebug debug = new OPaginatedClusterDebug();
        debug.clusterPosition = clusterPosition;
        debug.fileId = this.fileId;
        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
        OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1, atomicOperation);
        if (positionEntry == null) {
            debug.empty = true;
            return debug;
        }
        long pageIndex = positionEntry.getPageIndex();
        int recordPosition = positionEntry.getRecordPosition();
        debug.pages = new ArrayList<OClusterPageDebug>(2);
        int contentSize = 0;
        boolean firstEntry = true;
        do {
            OClusterPageDebug debugPage = new OClusterPageDebug();
            debugPage.pageIndex = pageIndex;
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry);
                if (localPage.isDeleted(recordPosition)) {
                    if (debug.pages.isEmpty()) {
                        debug.empty = true;
                        OPaginatedClusterDebug oPaginatedClusterDebug = debug;
                        return oPaginatedClusterDebug;
                    }
                    throw new OPaginatedClusterException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken", this);
                }
                debugPage.inPagePosition = recordPosition;
                debugPage.inPageSize = localPage.getRecordSize(recordPosition);
                byte[] content = localPage.getRecordBinaryValue(recordPosition, 0, debugPage.inPageSize);
                assert (content != null);
                debugPage.content = content;
                if (firstEntry && content[content.length - 8 - 1] == 0) {
                    debug.empty = true;
                    OPaginatedClusterDebug oPaginatedClusterDebug = debug;
                    return oPaginatedClusterDebug;
                }
                debug.pages.add(debugPage);
                nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                contentSize += content.length - 8 - 1;
                firstEntry = false;
            }
            finally {
                this.releasePageFromRead(atomicOperation, cacheEntry);
            }
            pageIndex = OPaginatedClusterV2.getPageIndex(nextPagePointer);
            recordPosition = OPaginatedClusterV2.getRecordPosition(nextPagePointer);
        } while (nextPagePointer >= 0L);
        debug.contentSize = contentSize;
        return debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPaginatedCluster.RECORD_STATUS getRecordStatus(long clusterPosition) throws IOException {
        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
        this.acquireSharedLock();
        try {
            byte status = this.clusterPositionMap.getStatus(clusterPosition, atomicOperation);
            switch (status) {
                case 0: {
                    OPaginatedCluster.RECORD_STATUS rECORD_STATUS = OPaginatedCluster.RECORD_STATUS.NOT_EXISTENT;
                    return rECORD_STATUS;
                }
                case 4: {
                    OPaginatedCluster.RECORD_STATUS rECORD_STATUS = OPaginatedCluster.RECORD_STATUS.ALLOCATED;
                    return rECORD_STATUS;
                }
                case 2: {
                    OPaginatedCluster.RECORD_STATUS rECORD_STATUS = OPaginatedCluster.RECORD_STATUS.PRESENT;
                    return rECORD_STATUS;
                }
                case 1: {
                    OPaginatedCluster.RECORD_STATUS rECORD_STATUS = OPaginatedCluster.RECORD_STATUS.REMOVED;
                    return rECORD_STATUS;
                }
            }
            OPaginatedCluster.RECORD_STATUS rECORD_STATUS = null;
            return rECORD_STATUS;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    public String toString() {
        return "plocal cluster: " + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClusterBrowsePage nextPage(long lastPosition) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block9: {
                OClusterBrowsePage oClusterBrowsePage;
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    OClusterPositionMapV2.OClusterPositionEntry[] nextPositions = this.clusterPositionMap.higherPositionsEntries(lastPosition, atomicOperation);
                    if (nextPositions.length <= 0) break block9;
                    long newLastPosition = nextPositions[nextPositions.length - 1].getPosition();
                    ArrayList<OClusterBrowseEntry> nexv = new ArrayList<OClusterBrowseEntry>(nextPositions.length);
                    for (OClusterPositionMapV2.OClusterPositionEntry pos : nextPositions) {
                        ORawBuffer buff = this.internalReadRecord(pos.getPosition(), pos.getPage(), pos.getOffset(), 1, atomicOperation);
                        nexv.add(new OClusterBrowseEntry(pos.getPosition(), buff));
                    }
                    oClusterBrowsePage = new OClusterBrowsePage(nexv, newLastPosition);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oClusterBrowsePage;
            }
            OClusterBrowsePage oClusterBrowsePage = null;
            this.releaseSharedLock();
            return oClusterBrowsePage;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    private static final class FindFreePageResult {
        private final long pageIndex;
        private final int freePageIndex;
        private final boolean allocateNewPage;

        private FindFreePageResult(long pageIndex, int freePageIndex, boolean allocateNewPage) {
            this.pageIndex = pageIndex;
            this.freePageIndex = freePageIndex;
            this.allocateNewPage = allocateNewPage;
        }
    }

    private static final class AddEntryResult {
        private final long pageIndex;
        private final int pagePosition;
        private final int recordVersion;
        private final int recordsSizeDiff;

        private AddEntryResult(long pageIndex, int pagePosition, int recordVersion, int recordsSizeDiff) {
            this.pageIndex = pageIndex;
            this.pagePosition = pagePosition;
            this.recordVersion = recordVersion;
            this.recordsSizeDiff = recordsSizeDiff;
        }
    }
}

