/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.disk;

import com.orientechnologies.common.collection.closabledictionary.OClosableLinkedContainer;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.serialization.types.OStringSerializer;
import com.orientechnologies.common.thread.OThreadPoolExecutorWithLogging;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.compression.impl.OZIPCompressionUtil;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OChecksumMode;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.local.OWOWCache;
import com.orientechnologies.orient.core.storage.cache.local.doublewritelog.DoubleWriteLog;
import com.orientechnologies.orient.core.storage.cache.local.doublewritelog.DoubleWriteLogGL;
import com.orientechnologies.orient.core.storage.cache.local.doublewritelog.DoubleWriteLogNoOP;
import com.orientechnologies.orient.core.storage.config.OClusterBasedStorageConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.local.paginated.StorageStartupMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.CASDiskWriteAheadLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;

public class OLocalPaginatedStorage
extends OAbstractPaginatedStorage {
    protected static final long IV_SEED = 234120934L;
    private static final String IV_EXT = ".iv";
    protected static final String IV_NAME = "data.iv";
    private static final String[] ALL_FILE_EXTENSIONS = new String[]{".cm", ".ocf", ".pls", ".pcl", ".oda", ".odh", ".otx", ".ocs", ".oef", ".oem", ".oet", ".fl", ".flb", ".iv", ".wal", ".wmr", ".hib", ".him", ".hit", ".hnb", ".cpm", ".sbt", ".irs", ".sbc", ".nbt", ".ccm", ".cd", ".bd", ".nd", ".cbt", ".mbt", ".dwl"};
    private static final int ONE_KB = 1024;
    private static final OThreadPoolExecutorWithLogging segmentAdderExecutor = new OThreadPoolExecutorWithLogging(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new SegmentAppenderFactory());
    private final int deleteMaxRetries;
    private final int deleteWaitTime;
    private final StorageStartupMetadata startupMetadata;
    private final Path storagePath;
    private final OClosableLinkedContainer<Long, OFile> files;
    private Future<?> fuzzyCheckpointTask;
    private final long walMaxSegSize;
    private final long doubleWriteLogMaxSegSize;
    private final AtomicReference<Future<Void>> segmentAppender = new AtomicReference();
    protected volatile byte[] iv;

    public OLocalPaginatedStorage(String name, String filePath, String mode, int id, OReadCache readCache, OClosableLinkedContainer<Long, OFile> files, long walMaxSegSize, long doubleWriteLogMaxSegSize) {
        super(name, filePath, mode, id);
        this.walMaxSegSize = walMaxSegSize;
        this.files = files;
        this.doubleWriteLogMaxSegSize = doubleWriteLogMaxSegSize;
        this.readCache = readCache;
        String sp = OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getPath()));
        this.storagePath = Paths.get(OIOUtils.getPathFromDatabaseName(sp), new String[0]);
        this.deleteMaxRetries = OGlobalConfiguration.FILE_DELETE_RETRY.getValueAsInteger();
        this.deleteWaitTime = OGlobalConfiguration.FILE_DELETE_DELAY.getValueAsInteger();
        this.startupMetadata = new StorageStartupMetadata(this.storagePath.resolve("dirty.fl"), this.storagePath.resolve("dirty.flb"));
    }

    @Override
    public void create(OContextConfiguration contextConfiguration) {
        try {
            this.stateLock.acquireWriteLock();
            try {
                Path storageFolder = this.storagePath;
                if (!Files.exists(storageFolder, new LinkOption[0])) {
                    Files.createDirectories(storageFolder, new FileAttribute[0]);
                }
                super.create(contextConfiguration);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    protected final String normalizeName(String name) {
        int firstIndexOf = name.lastIndexOf(47);
        int secondIndexOf = name.lastIndexOf(File.separator);
        if (firstIndexOf >= 0 || secondIndexOf >= 0) {
            return name.substring(Math.max(firstIndexOf, secondIndexOf) + 1);
        }
        return name;
    }

    @Override
    public final boolean exists() {
        try {
            if (this.status == OStorage.STATUS.OPEN) {
                return true;
            }
            return OLocalPaginatedStorage.exists(this.storagePath);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public String getURL() {
        return "plocal:" + this.url;
    }

    public final Path getStoragePath() {
        return this.storagePath;
    }

    @Override
    public String getType() {
        return "plocal";
    }

    /*
     * Exception decompiling
     */
    @Override
    public final List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iOutput, int compressionLevel, int bufferSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 26[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) {
        try {
            if (!this.isClosed()) {
                this.close(true, false);
            }
            try {
                this.stateLock.acquireWriteLock();
                File dbDir = new File(OIOUtils.getPathFromDatabaseName(OSystemVariableResolver.resolveSystemVariables(this.url)));
                File[] storageFiles = dbDir.listFiles();
                if (storageFiles != null) {
                    block9: for (File f : storageFiles) {
                        for (String ext : ALL_FILE_EXTENSIONS) {
                            if (!f.getPath().endsWith(ext)) continue;
                            f.delete();
                            continue block9;
                        }
                    }
                }
                OZIPCompressionUtil.uncompressDirectory(in, this.storagePath.toString(), iListener);
                File[] newStorageFiles = dbDir.listFiles();
                if (newStorageFiles != null) {
                    for (File f : newStorageFiles) {
                        if (f.getPath().endsWith(".wmr")) {
                            boolean renamed = f.renameTo(new File(f.getParent(), this.getName() + ".wmr"));
                            assert (renamed);
                        }
                        if (!f.getPath().endsWith(".wal")) continue;
                        String walName = f.getName();
                        int segmentIndex = walName.lastIndexOf(".", walName.length() - ".wal".length() - 1);
                        String ending = walName.substring(segmentIndex);
                        boolean renamed = f.renameTo(new File(f.getParent(), this.getName() + ending));
                        assert (renamed);
                    }
                }
                if (callable != null) {
                    try {
                        callable.call();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error on calling callback on database restore", e, new Object[0]);
                    }
                }
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
            this.open(null, null, new OContextConfiguration());
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OLogSequenceNumber copyWALToIncrementalBackup(ZipOutputStream zipOutputStream, long startSegment) throws IOException {
        File[] nonActiveSegments;
        OLogSequenceNumber lastLSN;
        long freezeId = this.getAtomicOperationsManager().freezeAtomicOperations(null, null);
        try {
            lastLSN = this.writeAheadLog.end();
            this.writeAheadLog.flush();
            this.writeAheadLog.appendNewSegment();
            nonActiveSegments = this.writeAheadLog.nonActiveSegments(startSegment);
        }
        finally {
            this.getAtomicOperationsManager().releaseAtomicOperations(freezeId);
        }
        for (File nonActiveSegment : nonActiveSegments) {
            try (FileInputStream fileInputStream = new FileInputStream(nonActiveSegment);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                ZipEntry entry = new ZipEntry(nonActiveSegment.getName());
                zipOutputStream.putNextEntry(entry);
                try {
                    int br;
                    byte[] buffer = new byte[4096];
                    while ((br = bufferedInputStream.read(buffer)) >= 0) {
                        zipOutputStream.write(buffer, 0, br);
                    }
                }
                finally {
                    zipOutputStream.closeEntry();
                }
            }
        }
        return lastLSN;
    }

    @Override
    protected File createWalTempDirectory() {
        File walDirectory = new File(this.storagePath.toFile(), "walIncrementalBackupRestoreDirectory");
        if (walDirectory.exists()) {
            OFileUtils.deleteRecursively(walDirectory);
        }
        if (!walDirectory.mkdirs()) {
            throw new OStorageException("Can not create temporary directory to store files created during incremental backup");
        }
        return walDirectory;
    }

    @Override
    protected void addFileToDirectory(String name, InputStream stream, File directory) throws IOException {
        byte[] buffer = new byte[4096];
        int rb = -1;
        int bl = 0;
        File walBackupFile = new File(directory, name);
        try (FileOutputStream outputStream = new FileOutputStream(walBackupFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
            while (true) {
                if (bl < buffer.length && (rb = stream.read(buffer, bl, buffer.length - bl)) > -1) {
                    bl += rb;
                    continue;
                }
                bufferedOutputStream.write(buffer, 0, bl);
                bl = 0;
                if (rb < 0) break;
            }
        }
    }

    @Override
    protected OWriteAheadLog createWalFromIBUFiles(File directory, OContextConfiguration contextConfiguration, Locale locale, byte[] iv) throws IOException {
        String aesKeyEncoded = contextConfiguration.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY);
        byte[] aesKey = Optional.ofNullable(aesKeyEncoded).map(keyEncoded -> Base64.getDecoder().decode((String)keyEncoded)).orElse(null);
        return new CASDiskWriteAheadLog(this.name, this.storagePath, directory.toPath(), contextConfiguration.getValueAsInteger(OGlobalConfiguration.WAL_CACHE_SIZE), contextConfiguration.getValueAsInteger(OGlobalConfiguration.WAL_BUFFER_SIZE), aesKey, iv, contextConfiguration.getValueAsLong(OGlobalConfiguration.WAL_SEGMENTS_INTERVAL) * 60L * 1000000000L, (long)(contextConfiguration.getValueAsInteger(OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE) * 1024) * 1024L, 10, true, locale, OGlobalConfiguration.WAL_MAX_SIZE.getValueAsLong() * 1024L * 1024L, OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L, contextConfiguration.getValueAsInteger(OGlobalConfiguration.WAL_COMMIT_TIMEOUT), contextConfiguration.getValueAsBoolean(OGlobalConfiguration.WAL_KEEP_SINGLE_SEGMENT), contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_CALL_FSYNC), contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_PRINT_WAL_PERFORMANCE_STATISTICS), contextConfiguration.getValueAsInteger(OGlobalConfiguration.STORAGE_PRINT_WAL_PERFORMANCE_INTERVAL));
    }

    @Override
    protected OAbstractPaginatedStorage.StartupMetadata checkIfStorageDirty() throws IOException {
        if (this.startupMetadata.exists()) {
            this.startupMetadata.open();
        } else {
            this.startupMetadata.create();
            this.startupMetadata.makeDirty();
        }
        return new OAbstractPaginatedStorage.StartupMetadata(this.startupMetadata.getLastTxId(), this.startupMetadata.getTxMetadata());
    }

    @Override
    protected void initConfiguration(OAtomicOperation atomicOperation, OContextConfiguration contextConfiguration) throws IOException {
        if (!OClusterBasedStorageConfiguration.exists(this.writeCache) && Files.exists(this.storagePath.resolve("database.ocf"), new LinkOption[0])) {
            OStorageConfigurationSegment oldConfig = new OStorageConfigurationSegment(this);
            oldConfig.load(contextConfiguration);
            OClusterBasedStorageConfiguration atomicConfiguration = new OClusterBasedStorageConfiguration(this);
            atomicConfiguration.create(atomicOperation, contextConfiguration, oldConfig);
            this.configuration = atomicConfiguration;
            oldConfig.close();
            Files.deleteIfExists(this.storagePath.resolve("database.ocf"));
        }
        if (this.configuration == null) {
            this.configuration = new OClusterBasedStorageConfiguration(this);
            ((OClusterBasedStorageConfiguration)this.configuration).load(contextConfiguration);
        }
    }

    @Override
    protected Map<String, Object> preCloseSteps() {
        Map<String, Object> params = super.preCloseSteps();
        if (this.fuzzyCheckpointTask != null) {
            this.fuzzyCheckpointTask.cancel(false);
        }
        return params;
    }

    @Override
    protected void postCloseStepsAfterLock(Map<String, Object> params) {
        super.postCloseStepsAfterLock(params);
    }

    @Override
    protected void preCreateSteps() throws IOException {
        this.startupMetadata.create();
    }

    @Override
    protected void postCloseSteps(boolean onDelete, boolean jvmError, long lastTxId) throws IOException {
        if (onDelete) {
            this.startupMetadata.delete();
        } else {
            if (!jvmError) {
                this.startupMetadata.setLastTxId(lastTxId);
                this.startupMetadata.setTxMetadata(this.getLastMetadata().orElse(null));
                this.startupMetadata.clearDirty();
            }
            this.startupMetadata.close();
        }
    }

    @Override
    protected void postDeleteSteps() {
        String databasePath = OIOUtils.getPathFromDatabaseName(OSystemVariableResolver.resolveSystemVariables(this.url));
        OLocalPaginatedStorage.deleteFilesFromDisc(this.name, this.deleteMaxRetries, this.deleteWaitTime, databasePath);
    }

    public static void deleteFilesFromDisc(String name, int maxRetries, int waitTime, String databaseDirectory) {
        File dbDir = new File(databaseDirectory);
        if (!dbDir.exists() || !dbDir.isDirectory()) {
            dbDir = dbDir.getParentFile();
        }
        for (int i = 0; i < maxRetries; ++i) {
            if (dbDir != null && dbDir.exists() && dbDir.isDirectory()) {
                int notDeletedFiles = 0;
                File[] storageFiles = dbDir.listFiles();
                if (storageFiles == null) continue;
                block1: for (File f : storageFiles) {
                    for (String ext : ALL_FILE_EXTENSIONS) {
                        if (!f.getPath().endsWith(ext)) continue;
                        if (f.delete()) continue block1;
                        ++notDeletedFiles;
                        continue block1;
                    }
                }
                if (notDeletedFiles == 0) {
                    if (!dbDir.delete()) {
                        OLogManager.instance().error(OLocalPaginatedStorage.class, "Cannot delete storage directory with path " + dbDir.getAbsolutePath() + " because directory is not empty. Files: " + Arrays.toString(dbDir.listFiles()), null, new Object[0]);
                    }
                    return;
                }
            } else {
                return;
            }
            OLogManager.instance().debug(OLocalPaginatedStorage.class, "Cannot delete database files because they are still locked by the OrientDB process: waiting %d ms and retrying %d/%d...", waitTime, i, maxRetries);
        }
        throw new OStorageException("Cannot delete database '" + name + "' located in: " + dbDir + ". Database files seem locked");
    }

    @Override
    protected void makeStorageDirty() throws IOException {
        this.startupMetadata.makeDirty();
    }

    @Override
    protected void clearStorageDirty() throws IOException {
        this.startupMetadata.clearDirty();
    }

    @Override
    protected boolean isDirty() {
        return this.startupMetadata.isDirty();
    }

    @Override
    protected boolean isWriteAllowedDuringIncrementalBackup() {
        return true;
    }

    @Override
    protected void initIv() throws IOException {
        try (RandomAccessFile ivFile = new RandomAccessFile(this.storagePath.resolve(IV_NAME).toAbsolutePath().toFile(), "rw");){
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            XXHashFactory hashFactory = XXHashFactory.fastestInstance();
            XXHash64 hash64 = hashFactory.hash64();
            long hash = hash64.hash(iv, 0, iv.length, 234120934L);
            ivFile.write(iv);
            ivFile.writeLong(hash);
            ivFile.getFD().sync();
            this.iv = iv;
        }
    }

    @Override
    protected void readIv() throws IOException {
        Path ivPath = this.storagePath.resolve(IV_NAME).toAbsolutePath();
        if (!Files.exists(ivPath, new LinkOption[0])) {
            OLogManager.instance().info((Object)this, "IV file is absent, will create new one.", new Object[0]);
            this.initIv();
            return;
        }
        try (RandomAccessFile ivFile = new RandomAccessFile(ivPath.toFile(), "r");){
            byte[] iv = new byte[16];
            ivFile.readFully(iv);
            long storedHash = ivFile.readLong();
            XXHashFactory hashFactory = XXHashFactory.fastestInstance();
            XXHash64 hash64 = hashFactory.hash64();
            long expectedHash = hash64.hash(iv, 0, iv.length, 234120934L);
            if (storedHash != expectedHash) {
                throw new OStorageException("iv data are broken");
            }
            this.iv = iv;
        }
    }

    @Override
    protected byte[] getIv() {
        return this.iv;
    }

    @Override
    protected void initWalAndDiskCache(OContextConfiguration contextConfiguration) throws IOException, InterruptedException {
        String aesKeyEncoded = contextConfiguration.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY);
        byte[] aesKey = Optional.ofNullable(aesKeyEncoded).map(keyEncoded -> Base64.getDecoder().decode((String)keyEncoded)).orElse(null);
        this.fuzzyCheckpointTask = fuzzyCheckpointExecutor.scheduleWithFixedDelay(new PeriodicFuzzyCheckpoint(), contextConfiguration.getValueAsInteger(OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL), contextConfiguration.getValueAsInteger(OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL), TimeUnit.SECONDS);
        String configWalPath = contextConfiguration.getValueAsString(OGlobalConfiguration.WAL_LOCATION);
        Path walPath = configWalPath == null ? null : Paths.get(configWalPath, new String[0]);
        CASDiskWriteAheadLog diskWriteAheadLog = new CASDiskWriteAheadLog(this.name, this.storagePath, walPath, contextConfiguration.getValueAsInteger(OGlobalConfiguration.WAL_CACHE_SIZE), contextConfiguration.getValueAsInteger(OGlobalConfiguration.WAL_BUFFER_SIZE), aesKey, this.iv, contextConfiguration.getValueAsLong(OGlobalConfiguration.WAL_SEGMENTS_INTERVAL) * 60L * 1000000000L, this.walMaxSegSize, 10, true, Locale.getDefault(), contextConfiguration.getValueAsLong(OGlobalConfiguration.WAL_MAX_SIZE) * 1024L * 1024L, contextConfiguration.getValueAsLong(OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT) * 1024L * 1024L, contextConfiguration.getValueAsInteger(OGlobalConfiguration.WAL_COMMIT_TIMEOUT), contextConfiguration.getValueAsBoolean(OGlobalConfiguration.WAL_KEEP_SINGLE_SEGMENT), contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_CALL_FSYNC), contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_PRINT_WAL_PERFORMANCE_STATISTICS), contextConfiguration.getValueAsInteger(OGlobalConfiguration.STORAGE_PRINT_WAL_PERFORMANCE_INTERVAL));
        diskWriteAheadLog.addLowDiskSpaceListener(this);
        this.writeAheadLog = diskWriteAheadLog;
        this.writeAheadLog.addFullCheckpointListener(this);
        diskWriteAheadLog.addSegmentOverflowListener(segment -> {
            if (this.status != OStorage.STATUS.OPEN) {
                return;
            }
            Future<Void> oldAppender = this.segmentAppender.get();
            if (oldAppender == null || oldAppender.isDone()) {
                Future<Void> appender = segmentAdderExecutor.submit(new SegmentAdder(segment, diskWriteAheadLog));
                if (this.segmentAppender.compareAndSet(oldAppender, appender)) {
                    return;
                }
                appender.cancel(false);
            }
        });
        int pageSize = contextConfiguration.getValueAsInteger(OGlobalConfiguration.DISK_CACHE_PAGE_SIZE) * 1024;
        long diskCacheSize = contextConfiguration.getValueAsLong(OGlobalConfiguration.DISK_CACHE_SIZE) * 1024L * 1024L;
        long writeCacheSize = (long)((double)contextConfiguration.getValueAsInteger(OGlobalConfiguration.DISK_WRITE_CACHE_PART) / 100.0 * (double)diskCacheSize);
        DoubleWriteLog doubleWriteLog = contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_USE_DOUBLE_WRITE_LOG) ? new DoubleWriteLogGL(this.doubleWriteLogMaxSegSize) : new DoubleWriteLogNoOP();
        OWOWCache wowCache = new OWOWCache(pageSize, OByteBufferPool.instance(null), this.writeAheadLog, doubleWriteLog, contextConfiguration.getValueAsInteger(OGlobalConfiguration.DISK_WRITE_CACHE_PAGE_FLUSH_INTERVAL), contextConfiguration.getValueAsInteger(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT), writeCacheSize, this.storagePath, this.getName(), OStringSerializer.INSTANCE, this.files, this.getId(), contextConfiguration.getValueAsEnum(OGlobalConfiguration.STORAGE_CHECKSUM_MODE, OChecksumMode.class), this.iv, aesKey, contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_CALL_FSYNC), contextConfiguration.getValueAsBoolean(OGlobalConfiguration.DISK_USE_NATIVE_OS_API));
        wowCache.addLowDiskSpaceListener(this);
        wowCache.loadRegisteredFiles();
        wowCache.addBackgroundExceptionListener(this);
        wowCache.addPageIsBrokenListener(this);
        this.writeCache = wowCache;
    }

    public static boolean exists(Path path) {
        try {
            boolean[] exists = new boolean[1];
            if (Files.exists(path, new LinkOption[0])) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                    stream.forEach(p -> {
                        String fileName = p.getFileName().toString();
                        if (fileName.equals("database.ocf") || fileName.startsWith("config") && fileName.endsWith(".bd") || fileName.startsWith("dirty.fl") || fileName.startsWith("dirty.flb")) {
                            exists[0] = true;
                        }
                    });
                }
                return exists[0];
            }
            return false;
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during fetching list of files"), e);
        }
    }

    private static final class SegmentAppenderFactory
    implements ThreadFactory {
        private SegmentAppenderFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(OAbstractPaginatedStorage.storageThreadGroup, r, "Segment adder thread");
        }
    }

    private final class SegmentAdder
    implements Callable<Void> {
        private final long segment;
        private final CASDiskWriteAheadLog wal;

        private SegmentAdder(long segment, CASDiskWriteAheadLog wal) {
            this.segment = segment;
            this.wal = wal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() {
            try {
                if (OLocalPaginatedStorage.this.status != OStorage.STATUS.OPEN) {
                    return null;
                }
                OLocalPaginatedStorage.this.stateLock.acquireReadLock();
                try {
                    if (OLocalPaginatedStorage.this.status != OStorage.STATUS.OPEN) {
                        Void void_ = null;
                        return void_;
                    }
                    long freezeId = OLocalPaginatedStorage.this.atomicOperationsManager.freezeComponentOperations();
                    try {
                        this.wal.appendSegment(this.segment + 1L);
                    }
                    finally {
                        OLocalPaginatedStorage.this.atomicOperationsManager.releaseComponentOperations(freezeId);
                    }
                    OLocalPaginatedStorage.this.atomicOperationsTable.compactTable();
                    return null;
                }
                finally {
                    OLocalPaginatedStorage.this.stateLock.releaseReadLock();
                }
            }
            catch (Exception e) {
                OLogManager.instance().errorNoDb(this, "Error during addition of new segment in storage %s.", e, OLocalPaginatedStorage.this.getName());
                throw e;
            }
        }
    }

    private class PeriodicFuzzyCheckpoint
    implements Runnable {
        private PeriodicFuzzyCheckpoint() {
        }

        @Override
        public final void run() {
            try {
                OLocalPaginatedStorage.this.makeFuzzyCheckpoint();
            }
            catch (RuntimeException e) {
                OLogManager.instance().error(this, "Error during fuzzy checkpoint", e, new Object[0]);
            }
        }
    }
}

