/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.concur.lock.ONotThreadRWLockManager;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OSimpleRWLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OHighLevelException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.ModifiableLongProfileHookValue;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OUTF8Serializer;
import com.orientechnologies.common.thread.OScheduledThreadPoolExecutorWithLogging;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.types.OModifiableLong;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfigurationUpdateListener;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDeleter;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.encryption.OEncryptionFactory;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OInvalidDatabaseNameException;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.exception.OJVMErrorException;
import com.orientechnologies.orient.core.exception.OLowDiskSpaceException;
import com.orientechnologies.orient.core.exception.OPageIsBrokenException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.ORetryQueryException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OStorageExistsException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.OIndexEngine;
import com.orientechnologies.orient.core.index.engine.OMultiValueIndexEngine;
import com.orientechnologies.orient.core.index.engine.OSingleValueIndexEngine;
import com.orientechnologies.orient.core.index.engine.OV1IndexEngine;
import com.orientechnologies.orient.core.index.engine.v1.OCellBTreeMultiValueIndexEngine;
import com.orientechnologies.orient.core.index.engine.v1.OCellBTreeSingleValueIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.query.OQueryAbstract;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.sharding.auto.OAutoShardingIndexEngine;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OIdentifiableStorage;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OBackgroundExceptionListener;
import com.orientechnologies.orient.core.storage.cluster.OOfflineCluster;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedCluster;
import com.orientechnologies.orient.core.storage.config.OClusterBasedStorageConfiguration;
import com.orientechnologies.orient.core.storage.impl.local.AtomicOperationIdGen;
import com.orientechnologies.orient.core.storage.impl.local.OBackgroundNewDelta;
import com.orientechnologies.orient.core.storage.impl.local.OCheckpointRequestListener;
import com.orientechnologies.orient.core.storage.impl.local.OClusterBrowsePage;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorageComponent;
import com.orientechnologies.orient.core.storage.impl.local.OIndexEngineCallback;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.OPageIsBrokenListener;
import com.orientechnologies.orient.core.storage.impl.local.OStorageRecoverListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.AtomicOperationsTable;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.MetaDataRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractCheckPointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartMetadataRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileDeletedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OHighLevelTransactionChangeRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ONonTxOperationPerformedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OPaginatedClusterFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageBrokenException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.common.WriteableWALRecord;
import com.orientechnologies.orient.core.storage.index.engine.OHashTableIndexEngine;
import com.orientechnologies.orient.core.storage.index.engine.OSBTreeIndexEngine;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsaiLocal;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainerSBTree;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManagerAbstract;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManagerShared;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionData;
import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.tx.OTxMetadataHolder;
import com.orientechnologies.orient.core.tx.OTxMetadataHolderImpl;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;

public abstract class OAbstractPaginatedStorage
extends OStorageAbstract
implements OLowDiskSpaceListener,
OCheckpointRequestListener,
OIdentifiableStorage,
OBackgroundExceptionListener,
OFreezableStorageComponent,
OPageIsBrokenListener {
    private static final int WAL_RESTORE_REPORT_INTERVAL = 30000;
    private static final Comparator<ORecordOperation> COMMIT_RECORD_OPERATION_COMPARATOR = Comparator.comparing(o -> o.getRecord().getIdentity());
    protected static final OScheduledThreadPoolExecutorWithLogging fuzzyCheckpointExecutor = new OScheduledThreadPoolExecutorWithLogging(1, new FuzzyCheckpointThreadFactory());
    public static final int STORAGE_CONFIGURATION_INDEX_ID = -1;
    private final OSimpleRWLockManager<ORID> lockManager;
    protected final OSBTreeCollectionManagerShared sbTreeCollectionManager;
    private final OLockManager<ORID> recordVersionManager;
    private final Map<String, OCluster> clusterMap = new HashMap<String, OCluster>();
    private final List<OCluster> clusters = new ArrayList<OCluster>();
    private volatile ThreadLocal<OStorageTransaction> transaction;
    private final AtomicBoolean checkpointInProgress = new AtomicBoolean();
    private final AtomicBoolean walVacuumInProgress = new AtomicBoolean();
    private final AtomicReference<Error> jvmError = new AtomicReference();
    protected volatile OWriteAheadLog writeAheadLog;
    private OStorageRecoverListener recoverListener;
    protected volatile OReadCache readCache;
    protected volatile OWriteCache writeCache;
    private volatile ORecordConflictStrategy recordConflictStrategy = (ORecordConflictStrategy)Orient.instance().getRecordConflictStrategy().getDefaultImplementation();
    private volatile int defaultClusterId = -1;
    protected volatile OAtomicOperationsManager atomicOperationsManager;
    private volatile boolean wereNonTxOperationsPerformedInPreviousOpen;
    private volatile OLowDiskSpaceInformation lowDiskSpace;
    private volatile boolean modificationLock;
    private volatile boolean readLock;
    private final Set<OPair<String, Long>> brokenPages = Collections.newSetFromMap(new ConcurrentHashMap(0));
    private volatile Throwable dataFlushException;
    private final int id;
    private final Map<String, OBaseIndexEngine> indexEngineNameMap = new HashMap<String, OBaseIndexEngine>();
    private final List<OBaseIndexEngine> indexEngines = new ArrayList<OBaseIndexEngine>();
    private final AtomicOperationIdGen idGen = new AtomicOperationIdGen();
    private boolean wereDataRestoredAfterOpen;
    private UUID uuid;
    private volatile byte[] lastMetadata = null;
    private long fullCheckpointCount = 0L;
    private final OModifiableLong recordCreated = new OModifiableLong();
    private final OModifiableLong recordUpdated = new OModifiableLong();
    private final OModifiableLong recordRead = new OModifiableLong();
    private final OModifiableLong recordDeleted = new OModifiableLong();
    private final OModifiableLong recordScanned = new OModifiableLong();
    private final OModifiableLong recordRecycled = new OModifiableLong();
    private final OModifiableLong recordConflict = new OModifiableLong();
    private final OModifiableLong txBegun = new OModifiableLong();
    private final OModifiableLong txCommit = new OModifiableLong();
    private final OModifiableLong txRollback = new OModifiableLong();
    private final AtomicInteger sessionCount = new AtomicInteger(0);
    private final AtomicLong lastCloseTime = new AtomicLong(System.currentTimeMillis());
    protected AtomicOperationsTable atomicOperationsTable;
    private final Set<Thread> blockedThreads = Collections.newSetFromMap(new WeakHashMap());

    public OAbstractPaginatedStorage(String name, String filePath, String mode, int id) {
        super(name, filePath, mode);
        this.id = id;
        this.lockManager = new ONotThreadRWLockManager<ORID>();
        this.recordVersionManager = new OPartitionedLockManager<ORID>();
        this.registerProfilerHooks();
        this.sbTreeCollectionManager = new OSBTreeCollectionManagerShared(this);
    }

    private static void checkPageSizeAndRelatedParametersInGlobalConfiguration() {
        int pageSize = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
        int freeListBoundary = OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger() * 1024;
        int maxKeySize = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
        if (freeListBoundary > pageSize / 2) {
            throw new OStorageException("Value of parameter " + OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getKey() + " should be at least 2 times bigger than value of parameter " + OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getKey() + " but real values are :" + OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getKey() + " = " + pageSize + " , " + OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getKey() + " = " + freeListBoundary);
        }
        if (maxKeySize > pageSize / 4) {
            throw new OStorageException("Value of parameter " + OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getKey() + " should be at least 4 times bigger than value of parameter " + OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getKey() + " but real values are :" + OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getKey() + " = " + pageSize + " , " + OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getKey() + " = " + maxKeySize);
        }
    }

    private static TreeMap<String, OTransactionIndexChanges> getSortedIndexOperations(OTransactionInternal clientTx) {
        return new TreeMap<String, OTransactionIndexChanges>(clientTx.getIndexOperations());
    }

    @Override
    public final void open(String iUserName, String iUserPassword, OContextConfiguration contextConfiguration) {
        this.open(contextConfiguration);
    }

    public final void open(OContextConfiguration contextConfiguration) {
        try {
            this.stateLock.acquireReadLock();
            try {
                if (this.status == OStorage.STATUS.OPEN) {
                    return;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
            this.stateLock.acquireWriteLock();
            try {
                if (this.status == OStorage.STATUS.OPEN) {
                    return;
                }
                if (!this.exists()) {
                    throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
                }
                this.initLockingStrategy(contextConfiguration);
                this.readIv();
                this.initWalAndDiskCache(contextConfiguration);
                this.transaction = new ThreadLocal();
                StartupMetadata startupMetadata = this.checkIfStorageDirty();
                long lastTxId = startupMetadata.lastTxId;
                if (lastTxId > 0L) {
                    this.idGen.setStartId(lastTxId + 1L);
                } else {
                    this.idGen.setStartId(0L);
                }
                this.atomicOperationsTable = new AtomicOperationsTable(contextConfiguration.getValueAsInteger(OGlobalConfiguration.STORAGE_ATOMIC_OPERATIONS_TABLE_COMPACTION_LIMIT), this.idGen.getLastId() + 1L);
                this.atomicOperationsManager = new OAtomicOperationsManager(this, contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_TRACK_PAGE_OPERATIONS_IN_TX), contextConfiguration.getValueAsInteger(OGlobalConfiguration.STORAGE_PAGE_OPERATIONS_CACHE_SIZE) * 1024 * 1024, this.atomicOperationsTable);
                this.recoverIfNeeded();
                this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> {
                    if (OClusterBasedStorageConfiguration.exists(this.writeCache)) {
                        this.configuration = new OClusterBasedStorageConfiguration(this);
                        ((OClusterBasedStorageConfiguration)this.configuration).load(contextConfiguration);
                    }
                    this.initConfiguration(atomicOperation, contextConfiguration);
                    String uuid = this.configuration.getUuid();
                    if (uuid == null) {
                        uuid = UUID.randomUUID().toString();
                        this.configuration.setUuid(atomicOperation, uuid);
                    }
                    this.uuid = UUID.fromString(uuid);
                    this.checkPageSizeAndRelatedParameters();
                    this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
                    this.openClusters();
                    this.openIndexes();
                    this.checkRidBagsPresence(atomicOperation);
                    this.status = OStorage.STATUS.OPEN;
                    String cs = this.configuration.getConflictStrategy();
                    if (cs != null) {
                        this.doSetConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(cs), atomicOperation);
                    }
                    if (this.lastMetadata == null) {
                        this.lastMetadata = startupMetadata.txMetadata;
                    }
                });
            }
            catch (RuntimeException e) {
                try {
                    if (this.writeCache != null) {
                        this.readCache.closeStorage(this.writeCache);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.writeAheadLog.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.postCloseSteps(false, false, this.idGen.getLastId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.status = OStorage.STATUS.CLOSED;
                throw e;
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        OLogManager.instance().infoNoDb(this, "Storage '%s' is opened under OrientDB distribution : %s", this.getURL(), OConstants.getVersion());
    }

    protected abstract void readIv() throws IOException;

    protected abstract byte[] getIv();

    private void initLockingStrategy(OContextConfiguration contextConfiguration) {
        String lockKind = contextConfiguration.getValueAsString(OGlobalConfiguration.STORAGE_PESSIMISTIC_LOCKING);
        if ("modification".equals(lockKind)) {
            this.modificationLock = true;
        } else if ("readwrite".equals(lockKind)) {
            this.modificationLock = true;
            this.readLock = true;
        }
    }

    public final void handleJVMError(Error e) {
        if (this.jvmError.compareAndSet(null, e)) {
            OLogManager.instance().errorNoDb(this, "JVM error was thrown", e, new Object[0]);
        }
    }

    @Override
    public final String getCreatedAtVersion() {
        return this.configuration.getCreatedAtVersion();
    }

    protected final void openIndexes() {
        OStorageConfiguration.IndexEngineData engineData;
        OCurrentStorageComponentsFactory cf = this.componentsFactory;
        if (cf == null) {
            throw new OStorageException("Storage '" + this.name + "' is not properly initialized");
        }
        Set<String> indexNames = this.configuration.indexEngines();
        int counter = 0;
        for (String indexName : indexNames) {
            engineData = this.configuration.getIndexEngine(indexName, -1);
            if (counter > engineData.getIndexId()) continue;
            counter = engineData.getIndexId() + 1;
        }
        for (String indexName : indexNames) {
            engineData = this.configuration.getIndexEngine(indexName, counter);
            OBaseIndexEngine engine = OIndexes.createIndexEngine(engineData.getIndexId(), engineData.getName(), engineData.getAlgorithm(), engineData.getIndexType(), engineData.getDurableInNonTxMode(), this, engineData.getVersion(), engineData.getApiVersion(), engineData.isMultivalue(), engineData.getEngineProperties());
            OEncryption encryption = engineData.getEncryption() == null || engineData.getEncryption().toLowerCase(this.configuration.getLocaleInstance()).equals("nothing") ? null : OEncryptionFactory.INSTANCE.getEncryption(engineData.getEncryption(), engineData.getEncryptionOptions());
            if (engineData.getApiVersion() < 1) {
                ((OIndexEngine)engine).load(engineData.getName(), cf.binarySerializerFactory.getObjectSerializer(engineData.getValueSerializerId()), engineData.isAutomatic(), cf.binarySerializerFactory.getObjectSerializer(engineData.getKeySerializedId()), engineData.getKeyTypes(), engineData.isNullValuesSupport(), engineData.getKeySize(), engineData.getEngineProperties(), encryption);
            } else {
                ((OV1IndexEngine)engine).load(engineData.getName(), engineData.getKeySize(), engineData.getKeyTypes(), cf.binarySerializerFactory.getObjectSerializer(engineData.getKeySerializedId()), encryption);
            }
            this.indexEngineNameMap.put(engineData.getName(), engine);
            while (engineData.getIndexId() >= this.indexEngines.size()) {
                this.indexEngines.add(null);
            }
            this.indexEngines.set(engineData.getIndexId(), engine);
            ++counter;
        }
    }

    protected final void openClusters() throws IOException {
        List<OStorageClusterConfiguration> configurationClusters = this.configuration.getClusters();
        for (int i = 0; i < configurationClusters.size(); ++i) {
            OStorageClusterConfiguration clusterConfig = configurationClusters.get(i);
            if (clusterConfig != null) {
                int pos = this.createClusterFromConfig(clusterConfig);
                try {
                    if (pos == -1) {
                        this.clusters.get(i).open();
                        continue;
                    }
                    if (clusterConfig.getName().equals("default")) {
                        this.defaultClusterId = pos;
                    }
                    this.clusters.get(pos).open();
                }
                catch (FileNotFoundException e) {
                    OLogManager.instance().warn((Object)this, "Error on loading cluster '" + configurationClusters.get(i).getName() + "' (" + i + "): file not found. It will be excluded from current database '" + this.getName() + "'.", e, new Object[0]);
                    this.clusterMap.remove(configurationClusters.get(i).getName().toLowerCase(this.configuration.getLocaleInstance()));
                    this.setCluster(i, null);
                }
                continue;
            }
            this.setCluster(i, null);
        }
    }

    private void checkRidBagsPresence(OAtomicOperation operation) {
        for (OCluster cluster : this.clusters) {
            int clusterId = cluster.getId();
            if (this.sbTreeCollectionManager.isComponentPresent(operation, clusterId)) continue;
            OLogManager.instance().info((Object)this, "Cluster with id %d does not have associated rid bag, fixing ...", new Object[0]);
            this.sbTreeCollectionManager.createComponent(operation, clusterId);
        }
    }

    public void open(OToken iToken, OContextConfiguration configuration) {
        this.open(iToken.getUserName(), "", configuration);
    }

    @Override
    public void create(OContextConfiguration contextConfiguration) {
        OAbstractPaginatedStorage.checkPageSizeAndRelatedParametersInGlobalConfiguration();
        try {
            this.stateLock.acquireWriteLock();
            try {
                if (this.name == null) {
                    throw new OInvalidDatabaseNameException("Database name can not be null");
                }
                if (this.name.isEmpty()) {
                    throw new OInvalidDatabaseNameException("Database name can not be empty");
                }
                Pattern namePattern = Pattern.compile("[^\\w\\d$_-]+");
                Matcher matcher = namePattern.matcher(this.name);
                if (matcher.find()) {
                    throw new OInvalidDatabaseNameException("Only letters, numbers, `$`, `_` and `-` are allowed in database name. Provided name :`" + this.name + "`");
                }
                if (this.status != OStorage.STATUS.CLOSED) {
                    throw new OStorageExistsException("Cannot create new storage '" + this.getURL() + "' because it is not closed");
                }
                if (this.exists()) {
                    throw new OStorageExistsException("Cannot create new storage '" + this.getURL() + "' because it already exists");
                }
                this.uuid = UUID.randomUUID();
                this.initLockingStrategy(contextConfiguration);
                this.initIv();
                this.initWalAndDiskCache(contextConfiguration);
                this.atomicOperationsTable = new AtomicOperationsTable(contextConfiguration.getValueAsInteger(OGlobalConfiguration.STORAGE_ATOMIC_OPERATIONS_TABLE_COMPACTION_LIMIT), this.idGen.getLastId() + 1L);
                this.atomicOperationsManager = new OAtomicOperationsManager(this, contextConfiguration.getValueAsBoolean(OGlobalConfiguration.STORAGE_TRACK_PAGE_OPERATIONS_IN_TX), contextConfiguration.getValueAsInteger(OGlobalConfiguration.STORAGE_PAGE_OPERATIONS_CACHE_SIZE) * 1024 * 1024, this.atomicOperationsTable);
                this.transaction = new ThreadLocal();
                this.preCreateSteps();
                this.makeStorageDirty();
                this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> {
                    this.configuration = new OClusterBasedStorageConfiguration(this);
                    ((OClusterBasedStorageConfiguration)this.configuration).create(atomicOperation, contextConfiguration);
                    this.configuration.setUuid(atomicOperation, this.uuid.toString());
                    this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
                    this.status = OStorage.STATUS.OPEN;
                    this.doAddCluster(atomicOperation, "internal");
                    ((OClusterBasedStorageConfiguration)this.configuration).setCreationVersion(atomicOperation, OConstants.getVersion());
                    ((OClusterBasedStorageConfiguration)this.configuration).setPageSize(atomicOperation, OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024);
                    ((OClusterBasedStorageConfiguration)this.configuration).setFreeListBoundary(atomicOperation, OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger() * 1024);
                    ((OClusterBasedStorageConfiguration)this.configuration).setMaxKeySize(atomicOperation, OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger());
                    this.doAddCluster(atomicOperation, "index");
                    this.doAddCluster(atomicOperation, "manindex");
                    this.defaultClusterId = this.doAddCluster(atomicOperation, "default");
                    if (this.jvmError.get() == null) {
                        this.clearStorageDirty();
                    }
                    this.postCreateSteps();
                    this.doCreateRecord(atomicOperation, new ORecordId(0, -1L), new byte[]{0, 0, 0, 0}, 0, (byte)98, null, this.doGetAndCheckCluster(0), null);
                });
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OStorageException("Storage creation was interrupted"), e);
            }
            catch (OStorageException e) {
                this.close();
                throw e;
            }
            catch (IOException e) {
                this.close();
                throw OException.wrapException(new OStorageException("Error on creation of storage '" + this.name + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        OLogManager.instance().infoNoDb(this, "Storage '%s' is created under OrientDB distribution : %s", this.getURL(), OConstants.getVersion());
    }

    protected abstract void initIv() throws IOException;

    private void checkPageSizeAndRelatedParameters() {
        int pageSize = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
        int freeListBoundary = OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger() * 1024;
        int maxKeySize = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
        if (this.configuration.getPageSize() != -1 && this.configuration.getPageSize() != pageSize) {
            throw new OStorageException("Storage is created with value of " + OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getKey() + " parameter equal to " + this.configuration.getPageSize() + " but current value is " + pageSize);
        }
        if (this.configuration.getFreeListBoundary() != -1 && this.configuration.getFreeListBoundary() != freeListBoundary) {
            throw new OStorageException("Storage is created with value of " + OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getKey() + " parameter equal to " + this.configuration.getFreeListBoundary() + " but current value is " + freeListBoundary);
        }
        if (this.configuration.getMaxKeySize() != -1 && this.configuration.getMaxKeySize() != maxKeySize) {
            throw new OStorageException("Storage is created with value of " + OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getKey() + " parameter equal to " + this.configuration.getMaxKeySize() + " but current value is " + maxKeySize);
        }
    }

    @Override
    public final boolean isClosed() {
        this.stateLock.acquireReadLock();
        try {
            boolean bl = super.isClosed();
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    @Override
    public final void close(boolean force, boolean onDelete) {
        try {
            this.doClose(force, onDelete);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public final void delete() {
        try {
            long timer = Orient.instance().getProfiler().startChrono();
            this.stateLock.acquireWriteLock();
            try {
                this.close(true, true);
                this.postDeleteSteps();
            }
            finally {
                this.stateLock.releaseWriteLock();
                Orient.instance().getProfiler().stopChrono("db." + this.name + ".drop", "Drop a database", timer, "db.*.drop");
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean check(boolean verbose, OCommandOutputListener listener) {
        try {
            listener.onMessage("Check of storage is started...");
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                long lockId = this.atomicOperationsManager.freezeAtomicOperations(null, null);
                try {
                    this.checkOpenness();
                    this.checkIfThreadIsBlocked();
                    long start = System.currentTimeMillis();
                    OPageDataVerificationError[] pageErrors = this.writeCache.checkStoredPages(verbose ? listener : null);
                    String errors = pageErrors.length > 0 ? pageErrors.length + " with errors." : " without errors.";
                    listener.onMessage("Check of storage completed in " + (System.currentTimeMillis() - start) + "ms. " + errors);
                    boolean bl = pageErrors.length == 0;
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                    return bl;
                }
                catch (Throwable throwable) {
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                    throw throwable;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int addCluster(String clusterName, Object ... parameters) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                this.makeStorageDirty();
                int n = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.doAddCluster(atomicOperation, clusterName));
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error in creation of new cluster '" + clusterName), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int addCluster(String clusterName, int requestedId) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                if (requestedId < 0) {
                    throw new OConfigurationException("Cluster id must be positive!");
                }
                if (requestedId < this.clusters.size() && this.clusters.get(requestedId) != null) {
                    throw new OConfigurationException("Requested cluster ID [" + requestedId + "] is occupied by cluster with name [" + this.clusters.get(requestedId).getName() + "]");
                }
                this.makeStorageDirty();
                int n = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.doAddCluster(atomicOperation, clusterName, requestedId));
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error in creation of new cluster '" + clusterName + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean dropCluster(int clusterId) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                if (clusterId < 0) throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
                if (clusterId >= this.clusters.size()) {
                    throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
                }
                boolean bl = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> {
                    if (this.dropClusterInternal(atomicOperation, clusterId)) {
                        return false;
                    }
                    ((OClusterBasedStorageConfiguration)this.configuration).dropCluster(atomicOperation, clusterId);
                    this.sbTreeCollectionManager.deleteComponentByClusterId(atomicOperation, clusterId);
                    return true;
                });
                return bl;
            }
            catch (Exception e) {
                throw OException.wrapException(new OStorageException("Error while removing cluster '" + clusterId + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private void checkClusterId(int clusterId) {
        if (clusterId < 0 || clusterId >= this.clusters.size()) {
            throw new OStorageException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClusterNameById(int clusterId) {
        this.checkOpenness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkClusterId(clusterId);
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                this.throwClusterDoesNotExist(clusterId);
            }
            String string = cluster.getName();
            this.stateLock.releaseReadLock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getClusterRecordsSizeById(int clusterId) {
        this.checkOpenness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkClusterId(clusterId);
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                this.throwClusterDoesNotExist(clusterId);
            }
            long l = cluster.getRecordsSize();
            this.stateLock.releaseReadLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getClusterRecordsSizeByName(String clusterName) {
        Objects.requireNonNull(clusterName);
        this.checkOpenness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OCluster cluster = this.clusterMap.get(clusterName.toLowerCase(this.configuration.getLocaleInstance()));
            if (cluster == null) {
                this.throwClusterDoesNotExist(clusterName);
            }
            long l = cluster.getRecordsSize();
            this.stateLock.releaseReadLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClusterRecordConflictStrategy(int clusterId) {
        this.checkOpenness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkClusterId(clusterId);
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                this.throwClusterDoesNotExist(clusterId);
            }
            String string = Optional.ofNullable(cluster.getRecordConflictStrategy()).map(ORecordConflictStrategy::getName).orElse(null);
            this.stateLock.releaseReadLock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClusterEncryption(int clusterId) {
        this.checkOpenness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkClusterId(clusterId);
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                this.throwClusterDoesNotExist(clusterId);
            }
            String string = cluster.encryption();
            this.stateLock.releaseReadLock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSystemCluster(int clusterId) {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkClusterId(clusterId);
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                this.throwClusterDoesNotExist(clusterId);
            }
            boolean bl = cluster.isSystemCluster();
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastClusterPosition(int clusterId) {
        this.checkOpenness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkClusterId(clusterId);
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                this.throwClusterDoesNotExist(clusterId);
            }
            long l = cluster.getLastPosition();
            this.stateLock.releaseReadLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getClusterNextPosition(int clusterId) {
        this.checkOpenness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkClusterId(clusterId);
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                this.throwClusterDoesNotExist(clusterId);
            }
            long l = cluster.getNextPosition();
            this.stateLock.releaseReadLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPaginatedCluster.RECORD_STATUS getRecordStatus(ORID rid) {
        this.checkOpenness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            int clusterId = rid.getClusterId();
            this.checkClusterId(clusterId);
            OCluster cluster = this.clusters.get(clusterId);
            if (cluster == null) {
                this.throwClusterDoesNotExist(clusterId);
            }
            OPaginatedCluster.RECORD_STATUS rECORD_STATUS = ((OPaginatedCluster)cluster).getRecordStatus(rid.getClusterPosition());
            this.stateLock.releaseReadLock();
            return rECORD_STATUS;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private void throwClusterDoesNotExist(int clusterId) {
        throw new OStorageException("Cluster with id " + clusterId + " does not exist inside of storage " + this.name);
    }

    private void throwClusterDoesNotExist(String clusterName) {
        throw new OStorageException("Cluster with name `" + clusterName + "` does not exist inside of storage " + this.name);
    }

    @Override
    public final int getId() {
        return this.id;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    private boolean setClusterStatus(OAtomicOperation atomicOperation, OCluster cluster, OStorageClusterConfiguration.STATUS iStatus) throws IOException {
        OCluster newCluster;
        if (iStatus == OStorageClusterConfiguration.STATUS.OFFLINE && cluster instanceof OOfflineCluster || iStatus == OStorageClusterConfiguration.STATUS.ONLINE && !(cluster instanceof OOfflineCluster)) {
            return false;
        }
        int clusterId = cluster.getId();
        if (iStatus == OStorageClusterConfiguration.STATUS.OFFLINE) {
            cluster.close(true);
            newCluster = new OOfflineCluster(this, clusterId, cluster.getName());
            boolean configured = false;
            for (OStorageClusterConfiguration clusterConfiguration : this.configuration.getClusters()) {
                if (clusterConfiguration.getId() != cluster.getId()) continue;
                newCluster.configure(this, clusterConfiguration);
                configured = true;
                break;
            }
            if (!configured) {
                throw new OStorageException("Can not configure offline cluster with id " + clusterId);
            }
        } else {
            newCluster = OPaginatedClusterFactory.createCluster(cluster.getName(), this.configuration.getVersion(), cluster.getBinaryVersion(), this);
            newCluster.configure(clusterId, cluster.getName());
            newCluster.open();
        }
        this.clusterMap.put(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()), newCluster);
        this.clusters.set(clusterId, newCluster);
        ((OClusterBasedStorageConfiguration)this.configuration).setClusterStatus(atomicOperation, clusterId, iStatus);
        return true;
    }

    @Override
    public final OSBTreeCollectionManager getSBtreeCollectionManager() {
        return this.sbTreeCollectionManager;
    }

    public OReadCache getReadCache() {
        return this.readCache;
    }

    public OWriteCache getWriteCache() {
        return this.writeCache;
    }

    @Override
    public final long count(int iClusterId) {
        return this.count(iClusterId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final long count(int clusterId, boolean countTombstones) {
        try {
            if (clusterId == -1) {
                throw new OStorageException("Cluster Id " + clusterId + " is invalid in database '" + this.name + "'");
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                OCluster cluster = this.clusters.get(clusterId);
                if (cluster == null) {
                    long l = 0L;
                    return l;
                }
                if (countTombstones) {
                    long l = cluster.getEntries();
                    return l;
                }
                long l = cluster.getEntries() - cluster.getTombstonesCount();
                return l;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final long[] getClusterDataRange(int iClusterId) {
        try {
            if (iClusterId == -1) {
                return new long[]{-1L, -1L};
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                if (this.clusters.get(iClusterId) != null) {
                    long[] lArray = new long[]{this.clusters.get(iClusterId).getFirstPosition(), this.clusters.get(iClusterId).getLastPosition()};
                    return lArray;
                }
                long[] lArray = OCommonConst.EMPTY_LONG_ARRAY;
                return lArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cannot retrieve information about data range"), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public OLogSequenceNumber getLSN() {
        try {
            return this.writeAheadLog.end();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public final long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    @Override
    public final void onException(Throwable e) {
        this.dataFlushException = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<OBackgroundNewDelta> extractTransactionsFromWal(List<OTransactionId> transactionsMetadata) {
        ArrayList<OTransactionData> finished = new ArrayList<OTransactionData>();
        this.stateLock.acquireReadLock();
        try {
            HashSet<OTransactionId> transactionsToRead = new HashSet<OTransactionId>(transactionsMetadata);
            OLogSequenceNumber beginLsn = this.writeAheadLog.end();
            HashMap<Long, OTransactionData> units = new HashMap<Long, OTransactionData>();
            this.writeAheadLog.addCutTillLimit(beginLsn);
            try {
                List<WriteableWALRecord> records = this.writeAheadLog.next(beginLsn, 1000);
                while (true) {
                    Iterator<WriteableWALRecord> iterator;
                    if (!records.isEmpty()) {
                        iterator = records.iterator();
                    } else {
                        Optional<OBackgroundNewDelta> optional;
                        if (transactionsToRead.isEmpty()) {
                            optional = Optional.of(new OBackgroundNewDelta(finished));
                            return optional;
                        }
                        optional = Optional.empty();
                        return optional;
                    }
                    while (iterator.hasNext()) {
                        OWALRecord oWALRecord = iterator.next();
                        if (oWALRecord instanceof OFileCreatedWALRecord) {
                            Optional<OBackgroundNewDelta> optional = Optional.empty();
                            return optional;
                        }
                        if (oWALRecord instanceof OFileDeletedWALRecord) {
                            Optional<OBackgroundNewDelta> optional = Optional.empty();
                            return optional;
                        }
                        if (oWALRecord instanceof OAtomicUnitStartMetadataRecord) {
                            byte[] meta = ((OAtomicUnitStartMetadataRecord)oWALRecord).getMetadata();
                            OTxMetadataHolder data = OTxMetadataHolderImpl.read(meta);
                            if (transactionsToRead.contains(data.getId())) {
                                long unitId = ((OAtomicUnitStartMetadataRecord)oWALRecord).getOperationUnitId();
                                units.put(unitId, new OTransactionData(data.getId()));
                            }
                            transactionsToRead.remove(data.getId());
                        }
                        if (oWALRecord instanceof OAtomicUnitEndRecord) {
                            long opId = ((OAtomicUnitEndRecord)oWALRecord).getOperationUnitId();
                            OTransactionData opes = (OTransactionData)units.remove(opId);
                            finished.add(opes);
                        }
                        if (oWALRecord instanceof OHighLevelTransactionChangeRecord) {
                            byte[] data = ((OHighLevelTransactionChangeRecord)oWALRecord).getData();
                            long unitId = ((OHighLevelTransactionChangeRecord)oWALRecord).getOperationUnitId();
                            OTransactionData tx = (OTransactionData)units.get(unitId);
                            if (tx != null) {
                                tx.addRecord(data);
                            }
                        }
                        if (!transactionsToRead.isEmpty() || !units.isEmpty()) continue;
                        Optional<OBackgroundNewDelta> optional = Optional.of(new OBackgroundNewDelta(finished));
                        return optional;
                    }
                    records = this.writeAheadLog.next(records.get(records.size() - 1).getLsn(), 1000);
                }
            }
            finally {
                this.writeAheadLog.removeCutTillLimit(beginLsn);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error of reading of records from  WAL"), e);
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serializeDeltaContent(OutputStream stream, OCommandOutputListener outputListener, SortedSet<ORID> sortedRids, OLogSequenceNumber lsn) {
        try {
            this.stateLock.acquireReadLock();
            int totalRecords = sortedRids.size();
            OLogManager.instance().info((Object)this, "Exporting records after LSN=%s. Found %d records", lsn, totalRecords);
            long lockId = this.atomicOperationsManager.freezeAtomicOperations(null, null);
            try (DataOutputStream dataOutputStream = new DataOutputStream(stream);){
                dataOutputStream.writeLong(sortedRids.size());
                long exportedRecord = 1L;
                for (ORID rid : sortedRids) {
                    OCluster cluster = this.clusters.get(rid.getClusterId());
                    dataOutputStream.writeInt(rid.getClusterId());
                    dataOutputStream.writeLong(rid.getClusterPosition());
                    if (cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition())) == null) {
                        dataOutputStream.writeBoolean(true);
                        OLogManager.instance().debug((Object)this, "Exporting deleted record %s", rid);
                    } else {
                        ORawBuffer rawBuffer = cluster.readRecord(rid.getClusterPosition(), false);
                        assert (rawBuffer != null);
                        dataOutputStream.writeBoolean(false);
                        dataOutputStream.writeInt(rawBuffer.version);
                        dataOutputStream.writeByte(rawBuffer.recordType);
                        dataOutputStream.writeInt(rawBuffer.buffer.length);
                        dataOutputStream.write(rawBuffer.buffer);
                        OLogManager.instance().debug((Object)this, "Exporting modified record rid=%s type=%d size=%d v=%d - buffer size=%d", rid, rawBuffer.recordType, rawBuffer.buffer.length, rawBuffer.version, dataOutputStream.size());
                    }
                    if (outputListener != null) {
                        outputListener.onMessage("exporting record " + exportedRecord + "/" + totalRecords);
                    }
                    ++exportedRecord;
                }
            }
            finally {
                this.atomicOperationsManager.releaseAtomicOperations(lockId);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long count(int[] iClusterIds, boolean countTombstones) {
        this.checkOpenness();
        long tot = 0L;
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            for (int iClusterId : iClusterIds) {
                OCluster c;
                if (iClusterId >= this.clusters.size()) {
                    throw new OConfigurationException("Cluster id " + iClusterId + " was not found in database '" + this.name + "'");
                }
                if (iClusterId <= -1 || (c = this.clusters.get(iClusterId)) == null) continue;
                tot += c.getEntries() - (countTombstones ? 0L : c.getTombstonesCount());
            }
            long l = tot;
            this.stateLock.releaseReadLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OStorageOperationResult<OPhysicalPosition> createRecord(ORecordId rid, byte[] content, int recordVersion, byte recordType, ORecordCallback<Long> callback) {
        this.checkOpenness();
        this.checkIfThreadIsBlocked();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        OCluster cluster = this.doGetAndCheckCluster(rid.getClusterId());
        if (this.transaction.get() != null) {
            OAtomicOperation atomicOperation2 = OAtomicOperationsManager.getCurrentOperation();
            return this.doCreateRecord(atomicOperation2, rid, content, recordVersion, recordType, callback, cluster, null);
        }
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OStorageOperationResult oStorageOperationResult = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.doCreateRecord(atomicOperation, rid, content, recordVersion, recordType, callback, cluster, null));
            this.stateLock.releaseReadLock();
            return oStorageOperationResult;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ORecordMetadata getRecordMetadata(ORID rid) {
        try {
            if (rid.isNew()) {
                throw new OStorageException("Passed record with id " + rid + " is new and cannot be stored.");
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                OCluster cluster = this.doGetAndCheckCluster(rid.getClusterId());
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
                if (ppos == null) {
                    ORecordMetadata oRecordMetadata = null;
                    return oRecordMetadata;
                }
                ORecordMetadata oRecordMetadata = new ORecordMetadata(rid, ppos.recordVersion);
                return oRecordMetadata;
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Retrieval of record  '" + rid + "' cause: " + ioe.getMessage(), ioe, new Object[0]);
                return null;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDeleted(ORID rid) {
        try {
            if (rid.isNew()) {
                throw new OStorageException("Passed record with id " + rid + " is new and cannot be stored.");
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                OCluster cluster = this.doGetAndCheckCluster(rid.getClusterId());
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                boolean bl = cluster.isDeleted(new OPhysicalPosition(rid.getClusterPosition()));
                return bl;
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Retrieval of record  '" + rid + "' cause: " + ioe.getMessage(), ioe, new Object[0]);
                return false;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<OClusterBrowsePage> browseCluster(int clusterId) {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            final int finalClusterId = clusterId == -1 ? this.defaultClusterId : clusterId;
            Iterator<OClusterBrowsePage> iterator = new Iterator<OClusterBrowsePage>(){
                private OClusterBrowsePage page;
                private long lastPos = -1L;

                @Override
                public boolean hasNext() {
                    if (this.page == null) {
                        this.page = OAbstractPaginatedStorage.this.nextPage(finalClusterId, this.lastPos);
                        if (this.page != null) {
                            this.lastPos = this.page.getLastPosition();
                        }
                    }
                    return this.page != null;
                }

                @Override
                public OClusterBrowsePage next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    OClusterBrowsePage curPage = this.page;
                    this.page = null;
                    return curPage;
                }
            };
            this.stateLock.releaseReadLock();
            return iterator;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClusterBrowsePage nextPage(int clusterId, long lastPosition) {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            OCluster cluster = this.doGetAndCheckCluster(clusterId);
            OClusterBrowsePage oClusterBrowsePage = cluster.nextPage(lastPosition);
            this.stateLock.releaseReadLock();
            return oClusterBrowsePage;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private OCluster doGetAndCheckCluster(int clusterId) {
        this.checkClusterSegmentIndexRange(clusterId);
        OCluster cluster = this.clusters.get(clusterId);
        if (cluster == null) {
            throw new IllegalArgumentException("Cluster " + clusterId + " is null");
        }
        return cluster;
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId rid, String iFetchPlan, boolean iIgnoreCache, boolean prefetchRecords, ORecordCallback<ORawBuffer> iCallback) {
        try {
            return new OStorageOperationResult<ORawBuffer>(this.readRecord(rid, prefetchRecords));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public final OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(ORecordId rid, String fetchPlan, boolean ignoreCache, int recordVersion) throws ORecordNotFoundException {
        try {
            return new OStorageOperationResult<ORawBuffer>(this.readRecordIfNotLatest(rid, recordVersion));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public final OStorageOperationResult<Integer> updateRecord(ORecordId rid, boolean updateContent, byte[] content, int version, byte recordType, int mode, ORecordCallback<Integer> callback) {
        try {
            this.checkOpenness();
            assert (this.transaction.get() == null);
            this.stateLock.acquireReadLock();
            try {
                Lock lock = this.recordVersionManager.acquireExclusiveLock(rid);
                try {
                    this.checkOpenness();
                    this.checkIfThreadIsBlocked();
                    this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                    OCluster cluster = this.doGetAndCheckCluster(rid.getClusterId());
                    OStorageOperationResult oStorageOperationResult = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.doUpdateRecord(atomicOperation, rid, updateContent, content, version, recordType, callback, cluster));
                    lock.unlock();
                    return oStorageOperationResult;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public OStorageTransaction getStorageTransaction() {
        return this.transaction.get();
    }

    public final OAtomicOperationsManager getAtomicOperationsManager() {
        return this.atomicOperationsManager;
    }

    public OWriteAheadLog getWALInstance() {
        return this.writeAheadLog;
    }

    public AtomicOperationIdGen getIdGen() {
        return this.idGen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final OStorageOperationResult<Boolean> deleteRecord(ORecordId rid, int version, int mode, ORecordCallback<Boolean> callback) {
        this.checkOpenness();
        assert (this.transaction.get() == null);
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            OCluster cluster = this.doGetAndCheckCluster(rid.getClusterId());
            OStorageOperationResult oStorageOperationResult = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.doDeleteRecord(atomicOperation, rid, version, cluster));
            this.stateLock.releaseReadLock();
            return oStorageOperationResult;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    @Override
    public final Set<String> getClusterNames() {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            this.stateLock.releaseReadLock();
            return hashSet;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int getClusterIdByName(String clusterName) {
        try {
            this.checkOpenness();
            if (clusterName == null) {
                throw new IllegalArgumentException("Cluster name is null");
            }
            if (clusterName.length() == 0) {
                throw new IllegalArgumentException("Cluster name is empty");
            }
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                OCluster segment = this.clusterMap.get(clusterName.toLowerCase(this.configuration.getLocaleInstance()));
                if (segment != null) {
                    int n = segment.getId();
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public void preallocateRids(OTransactionInternal clientTx) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            Collection<ORecordOperation> entries = clientTx.getRecordOperations();
            TreeMap<Integer, OCluster> clustersToLock = new TreeMap<Integer, OCluster>();
            TreeSet<ORecordOperation> newRecords = new TreeSet<ORecordOperation>(COMMIT_RECORD_OPERATION_COMPARATOR);
            for (ORecordOperation txEntry : entries) {
                if (txEntry.type != 3) continue;
                newRecords.add(txEntry);
                int clusterId = txEntry.getRID().getClusterId();
                clustersToLock.put(clusterId, this.doGetAndCheckCluster(clusterId));
            }
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                this.makeStorageDirty();
                this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> {
                    OAbstractPaginatedStorage.lockClusters(clustersToLock);
                    for (ORecordOperation txEntry : newRecords) {
                        OPhysicalPosition ppos;
                        ORecordId rid;
                        ORecord rec = txEntry.getRecord();
                        if (!rec.getIdentity().isPersistent()) {
                            if (!rec.isDirty()) continue;
                            rid = (ORecordId)rec.getIdentity().copy();
                            ORecordId oldRID = rid.copy();
                            OCluster cluster = this.doGetAndCheckCluster(rid.getClusterId());
                            ppos = cluster.allocatePosition(ORecordInternal.getRecordType(rec), atomicOperation);
                            rid.setClusterPosition(ppos.clusterPosition);
                            clientTx.updateIdentityAfterCommit(oldRID, rid);
                            continue;
                        }
                        rid = (ORecordId)rec.getIdentity();
                        OPaginatedCluster cluster = (OPaginatedCluster)this.doGetAndCheckCluster(rid.getClusterId());
                        OPaginatedCluster.RECORD_STATUS recordStatus = cluster.getRecordStatus(rid.getClusterPosition());
                        if (recordStatus == OPaginatedCluster.RECORD_STATUS.NOT_EXISTENT) {
                            ppos = cluster.allocatePosition(ORecordInternal.getRecordType(rec), atomicOperation);
                            while (ppos.clusterPosition < rid.getClusterPosition()) {
                                ppos = cluster.allocatePosition(ORecordInternal.getRecordType(rec), atomicOperation);
                            }
                            if (ppos.clusterPosition == rid.getClusterPosition()) continue;
                            throw new OConcurrentCreateException(rid, new ORecordId(rid.getClusterId(), ppos.clusterPosition));
                        }
                        if (recordStatus != OPaginatedCluster.RECORD_STATUS.PRESENT && recordStatus != OPaginatedCluster.RECORD_STATUS.REMOVED) continue;
                        ppos = cluster.allocatePosition(ORecordInternal.getRecordType(rec), atomicOperation);
                        throw new OConcurrentCreateException(rid, new ORecordId(rid.getClusterId(), ppos.clusterPosition));
                    }
                });
            }
            catch (IOException | RuntimeException ioe) {
                throw OException.wrapException(new OStorageException("Could not preallocate RIDs"), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public List<ORecordOperation> commit(OTransactionInternal clientTx) {
        return this.commit(clientTx, false);
    }

    public List<ORecordOperation> commitPreAllocated(OTransactionInternal clientTx) {
        return this.commit(clientTx, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ORecordOperation> commit(OTransactionInternal transaction, boolean allocated) {
        try {
            this.checkOpenness();
            this.txBegun.increment();
            ODatabaseDocumentInternal database = transaction.getDatabase();
            OIndexManagerAbstract indexManager = database.getMetadata().getIndexManagerInternal();
            TreeMap<String, OTransactionIndexChanges> indexOperations = OAbstractPaginatedStorage.getSortedIndexOperations(transaction);
            database.getMetadata().makeThreadLocalSchemaSnapshot();
            Collection<ORecordOperation> recordOperations = transaction.getRecordOperations();
            TreeMap<Integer, OCluster> clustersToLock = new TreeMap<Integer, OCluster>();
            IdentityHashMap<ORecordOperation, Integer> clusterOverrides = new IdentityHashMap<ORecordOperation, Integer>(8);
            TreeSet<ORecordOperation> newRecords = new TreeSet<ORecordOperation>(COMMIT_RECORD_OPERATION_COMPARATOR);
            for (ORecordOperation recordOperation : recordOperations) {
                OImmutableClass class_;
                ORecord record;
                if ((recordOperation.type == 3 || recordOperation.type == 1) && (record = recordOperation.getRecord()) instanceof ODocument) {
                    ((ODocument)record).validate();
                }
                if (recordOperation.type == 1 || recordOperation.type == 2) {
                    int clusterId = recordOperation.getRecord().getIdentity().getClusterId();
                    clustersToLock.put(clusterId, this.doGetAndCheckCluster(clusterId));
                    continue;
                }
                if (recordOperation.type != 3) continue;
                newRecords.add(recordOperation);
                record = recordOperation.getRecord();
                ORID oRID = record.getIdentity();
                int n = oRID.getClusterId();
                if (record.isDirty() && n == -1 && record instanceof ODocument && (class_ = ODocumentInternal.getImmutableSchemaClass((ODocument)record)) != null) {
                    n = class_.getClusterForNewInstance((ODocument)record);
                    clusterOverrides.put(recordOperation, n);
                }
                clustersToLock.put(n, this.doGetAndCheckCluster(n));
            }
            ArrayList<ORecordOperation> result = new ArrayList<ORecordOperation>(8);
            this.stateLock.acquireReadLock();
            try {
                if (this.modificationLock) {
                    ArrayList<ORID> recordLocks = new ArrayList<ORID>();
                    for (ORecordOperation oRecordOperation : recordOperations) {
                        if (oRecordOperation.type != 1 && oRecordOperation.type != 2) continue;
                        recordLocks.add(oRecordOperation.getRID());
                    }
                    Set<ORID> locked = transaction.getLockedRecords();
                    if (locked != null) {
                        recordLocks.removeAll(locked);
                    }
                    Collections.sort(recordLocks);
                    for (ORID oRID : recordLocks) {
                        this.acquireWriteLock(oRID);
                    }
                }
                try {
                    this.checkOpenness();
                    this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                    this.checkIfThreadIsBlocked();
                    this.makeStorageDirty();
                    boolean rollback = false;
                    this.startStorageTx(transaction);
                    try {
                        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                        OAbstractPaginatedStorage.lockClusters(clustersToLock);
                        this.checkReadOnlyConditions();
                        IdentityHashMap<ORecordOperation, OPhysicalPosition> identityHashMap = new IdentityHashMap<ORecordOperation, OPhysicalPosition>(8);
                        for (ORecordOperation recordOperation : newRecords) {
                            ORecord rec = recordOperation.getRecord();
                            if (allocated) {
                                if (rec.getIdentity().isPersistent()) {
                                    identityHashMap.put(recordOperation, new OPhysicalPosition(rec.getIdentity().getClusterPosition()));
                                    continue;
                                }
                                throw new OStorageException("Impossible to commit a transaction with not valid rid in pre-allocated commit");
                            }
                            if (!rec.isDirty() || rec.getIdentity().isPersistent()) continue;
                            ORecordId rid = (ORecordId)rec.getIdentity().copy();
                            ORecordId oldRID = rid.copy();
                            Integer clusterOverride = (Integer)clusterOverrides.get(recordOperation);
                            int clusterId = Optional.ofNullable(clusterOverride).orElseGet(rid::getClusterId);
                            OCluster cluster = this.doGetAndCheckCluster(clusterId);
                            OPhysicalPosition physicalPosition = cluster.allocatePosition(ORecordInternal.getRecordType(rec), atomicOperation);
                            rid.setClusterId(cluster.getId());
                            if (rid.getClusterPosition() > -1L) {
                                while (rid.getClusterPosition() > physicalPosition.clusterPosition) {
                                    physicalPosition = cluster.allocatePosition(ORecordInternal.getRecordType(rec), atomicOperation);
                                }
                                if (rid.getClusterPosition() != physicalPosition.clusterPosition) {
                                    throw new OConcurrentCreateException(rid, new ORecordId(rid.getClusterId(), physicalPosition.clusterPosition));
                                }
                            }
                            identityHashMap.put(recordOperation, physicalPosition);
                            rid.setClusterPosition(physicalPosition.clusterPosition);
                            transaction.updateIdentityAfterCommit(oldRID, rid);
                        }
                        this.lockRidBags(clustersToLock, indexOperations, indexManager, database);
                        this.checkReadOnlyConditions();
                        for (ORecordOperation recordOperation : recordOperations) {
                            this.commitEntry(atomicOperation, recordOperation, (OPhysicalPosition)identityHashMap.get(recordOperation), database.getSerializer());
                            result.add(recordOperation);
                        }
                        OAbstractPaginatedStorage.lockIndexes(indexOperations);
                        this.checkReadOnlyConditions();
                        this.commitIndexes(indexOperations);
                    }
                    catch (IOException | RuntimeException e) {
                        rollback = true;
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw OException.wrapException(new OStorageException("Error during transaction commit"), e);
                    }
                    finally {
                        if (rollback) {
                            this.rollback(transaction);
                        } else {
                            this.endStorageTx(transaction, recordOperations);
                        }
                        this.transaction.set(null);
                    }
                }
                finally {
                    this.atomicOperationsManager.ensureThatComponentsUnlocked();
                    database.getMetadata().clearThreadLocalSchemaSnapshot();
                }
            }
            finally {
                try {
                    if (this.modificationLock) {
                        ArrayList<ORID> recordLocks = new ArrayList<ORID>();
                        for (ORecordOperation oRecordOperation : recordOperations) {
                            if (oRecordOperation.type != 1 && oRecordOperation.type != 2) continue;
                            recordLocks.add(oRecordOperation.getRID());
                        }
                        Set<ORID> locked = transaction.getLockedRecords();
                        if (locked != null) {
                            recordLocks.removeAll(locked);
                        }
                        for (ORID oRID : recordLocks) {
                            this.releaseWriteLock(oRID);
                        }
                    }
                }
                finally {
                    this.stateLock.releaseReadLock();
                }
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "%d Committed transaction %d on database '%s' (result=%s)", Thread.currentThread().getId(), transaction.getId(), database.getName(), result);
            }
            return result;
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            this.handleJVMError(ee);
            OAtomicOperationsManager.alarmClearOfAtomicOperation();
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private void commitIndexes(Map<String, OTransactionIndexChanges> indexesToCommit) {
        for (OTransactionIndexChanges changes : indexesToCommit.values()) {
            OIndexInternal index = changes.getAssociatedIndex();
            if (!index.isNativeTxSupported()) {
                OIndexAbstract.IndexTxSnapshot snapshot = new OIndexAbstract.IndexTxSnapshot();
                index.addTxOperation(snapshot, changes);
                index.commit(snapshot);
                continue;
            }
            try {
                int indexId = index.getIndexId();
                if (changes.cleared) {
                    this.clearIndex(indexId);
                }
                for (OTransactionIndexChangesPerKey changesPerKey : changes.changesPerKey.values()) {
                    this.applyTxChanges(changesPerKey, index);
                }
                this.applyTxChanges(changes.nullKeyChanges, index);
            }
            catch (OInvalidIndexEngineIdException e) {
                throw OException.wrapException(new OStorageException("Error during index commit"), e);
            }
        }
    }

    private void applyTxChanges(OTransactionIndexChangesPerKey changes, OIndexInternal index) throws OInvalidIndexEngineIdException {
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry op : index.interpretTxKeyChanges(changes)) {
            switch (op.operation) {
                case PUT: {
                    index.doPut(this, changes.key, op.value.getIdentity());
                    break;
                }
                case REMOVE: {
                    if (op.value != null) {
                        index.doRemove(this, changes.key, op.value.getIdentity());
                        break;
                    }
                    index.doRemove(this, changes.key);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadIndexEngine(String name) {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                OBaseIndexEngine engine = this.indexEngineNameMap.get(name);
                if (engine == null) {
                    int n = -1;
                    return n;
                }
                int indexId = this.indexEngines.indexOf(engine);
                assert (indexId == engine.getId());
                int n = OAbstractPaginatedStorage.generateIndexId(indexId, engine);
                return n;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadExternalIndexEngine(String engineName, String algorithm, String indexType, OIndexDefinition indexDefinition, OBinarySerializer<?> valueSerializer, boolean isAutomatic, Boolean durableInNonTxMode, int version, int apiVersion, boolean multivalue, Map<String, String> engineProperties, ODocument metadata) {
        try {
            this.checkOpenness();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                if (this.configuration.getBinaryFormatVersion() > 15) {
                    int n = -1;
                    return n;
                }
                if (this.indexEngineNameMap.containsKey(engineName)) {
                    throw new OIndexException("Index with name " + engineName + " already exists");
                }
                this.makeStorageDirty();
                OBinarySerializer<?> keySerializer = this.determineKeySerializer(indexDefinition, metadata);
                if (keySerializer == null) {
                    throw new OIndexException("Can not determine key serializer");
                }
                int keySize = OAbstractPaginatedStorage.determineKeySize(indexDefinition);
                OType[] keyTypes = Optional.of(indexDefinition).map(OIndexDefinition::getTypes).orElse(null);
                boolean nullValuesSupport = !indexDefinition.isNullValuesIgnored();
                OBaseIndexEngine engine = OIndexes.createIndexEngine(this.indexEngines.size(), engineName, algorithm, indexType, durableInNonTxMode, this, version, apiVersion, multivalue, engineProperties);
                OStorageConfiguration.IndexEngineData engineData = new OStorageConfiguration.IndexEngineData(engine.getId(), engineName, algorithm, indexType, durableInNonTxMode, version, engine.getEngineAPIVersion(), multivalue, valueSerializer.getId(), keySerializer.getId(), isAutomatic, keyTypes, nullValuesSupport, keySize, null, null, engineProperties);
                if (engineData.getApiVersion() < 1) {
                    ((OIndexEngine)engine).load(engineName, valueSerializer, isAutomatic, keySerializer, keyTypes, nullValuesSupport, keySize, engineData.getEngineProperties(), null);
                } else {
                    ((OV1IndexEngine)engine).load(engineName, keySize, keyTypes, keySerializer, null);
                }
                this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> {
                    this.indexEngineNameMap.put(engineName, engine);
                    this.indexEngines.add(engine);
                    ((OClusterBasedStorageConfiguration)this.configuration).addIndexEngine(atomicOperation, engineName, engineData);
                });
                int n = OAbstractPaginatedStorage.generateIndexId(this.indexEngines.size() - 1, engine);
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Cannot add index engine " + engineName + " in storage."), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addIndexEngine(String engineName, String algorithm, String indexType, OIndexDefinition indexDefinition, OBinarySerializer<?> valueSerializer, boolean isAutomatic, Boolean durableInNonTxMode, int version, int apiVersion, boolean multivalue, Map<String, String> engineProperties, Set<String> clustersToIndex, ODocument metadata) {
        try {
            if (indexDefinition == null) {
                throw new OIndexException("Index definition hav to be provided");
            }
            OType[] keyTypes = indexDefinition.getTypes();
            if (keyTypes == null) {
                throw new OIndexException("Types of indexed keys have to be provided");
            }
            this.checkOpenness();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.makeStorageDirty();
                int n = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> {
                    OBinarySerializer<?> keySerializer;
                    if (this.indexEngineNameMap.containsKey(engineName)) {
                        OLogManager.instance().warn((Object)this, "Index with name '%s' already exists, removing it and re-create the index", engineName);
                        OBaseIndexEngine engine = this.indexEngineNameMap.remove(engineName);
                        if (engine != null) {
                            this.indexEngines.set(engine.getId(), null);
                            engine.delete(atomicOperation);
                            ((OClusterBasedStorageConfiguration)this.configuration).deleteIndexEngine(atomicOperation, engineName);
                        }
                    }
                    if ((keySerializer = this.determineKeySerializer(indexDefinition, metadata)) == null) {
                        throw new OIndexException("Can not determine key serializer");
                    }
                    int keySize = OAbstractPaginatedStorage.determineKeySize(indexDefinition);
                    boolean nullValuesSupport = !indexDefinition.isNullValuesIgnored();
                    byte serializerId = valueSerializer != null ? (byte)valueSerializer.getId() : (byte)-1;
                    if (metadata != null && metadata.containsField("partitions")) {
                        engineProperties.put("partitions", (String)metadata.field("partitions"));
                    } else {
                        engineProperties.put("partitions", Integer.toString(clustersToIndex.size()));
                    }
                    OBaseIndexEngine engine = this.addIndexEngineInternal(atomicOperation, engineName, algorithm, indexType, valueSerializer, isAutomatic, durableInNonTxMode, version, apiVersion, multivalue, engineProperties, keySerializer, keySize, keyTypes, nullValuesSupport);
                    OContextConfiguration ctxCfg = this.configuration.getContextConfiguration();
                    String cfgEncryption = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD);
                    String cfgEncryptionKey = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY);
                    OStorageConfiguration.IndexEngineData engineData = new OStorageConfiguration.IndexEngineData(engine.getId(), engineName, algorithm, indexType, durableInNonTxMode, version, engine.getEngineAPIVersion(), multivalue, serializerId, keySerializer.getId(), isAutomatic, keyTypes, nullValuesSupport, keySize, cfgEncryption, cfgEncryptionKey, engineProperties);
                    ((OClusterBasedStorageConfiguration)this.configuration).addIndexEngine(atomicOperation, engineName, engineData);
                    if (multivalue && (engine instanceof OSBTreeIndexEngine || engine instanceof OHashTableIndexEngine) || engine instanceof OAutoShardingIndexEngine) {
                        OSBTreeBonsaiLocal tree = new OSBTreeBonsaiLocal(engineName, ".irs", this);
                        tree.createComponent(atomicOperation);
                    }
                    return OAbstractPaginatedStorage.generateIndexId(this.indexEngines.size() - 1, engine);
                });
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Cannot add index engine " + engineName + " in storage."), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private OBaseIndexEngine addIndexEngineInternal(OAtomicOperation atomicOperation, String engineName, String algorithm, String indexType, OBinarySerializer<?> valueSerializer, boolean isAutomatic, Boolean durableInNonTxMode, int version, int apiVersion, boolean multivalue, Map<String, String> engineProperties, OBinarySerializer<?> keySerializer, int keySize, OType[] keyTypes, boolean nullValuesSupport) throws IOException {
        OBaseIndexEngine engine = OIndexes.createIndexEngine(this.indexEngines.size(), engineName, algorithm, indexType, durableInNonTxMode, this, version, apiVersion, multivalue, engineProperties);
        OContextConfiguration ctxCfg = this.configuration.getContextConfiguration();
        String cfgEncryption = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD);
        String cfgEncryptionKey = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY);
        OEncryption encryption = cfgEncryption == null || cfgEncryption.equals("nothing") ? null : OEncryptionFactory.INSTANCE.getEncryption(cfgEncryption, cfgEncryptionKey);
        engine.create(atomicOperation, valueSerializer, isAutomatic, keyTypes, nullValuesSupport, keySerializer, keySize, engineProperties, encryption);
        this.indexEngineNameMap.put(engineName, engine);
        this.indexEngines.add(engine);
        return engine;
    }

    private static int generateIndexId(int internalId, OBaseIndexEngine indexEngine) {
        return indexEngine.getEngineAPIVersion() << 27 | internalId;
    }

    private static int extractInternalId(int externalId) {
        if (externalId < 0) {
            throw new IllegalStateException("Index id has to be positive");
        }
        return externalId & 0x7FFFFFF;
    }

    public static int extractEngineAPIVersion(int externalId) {
        return externalId >>> 27;
    }

    private static int determineKeySize(OIndexDefinition indexDefinition) {
        if (indexDefinition == null || indexDefinition instanceof ORuntimeKeyIndexDefinition) {
            return 1;
        }
        return indexDefinition.getTypes().length;
    }

    private OBinarySerializer<?> determineKeySerializer(OIndexDefinition indexDefinition, ODocument metadata) {
        OBinarySerializer<OCompositeKey> keySerializer;
        if (indexDefinition == null) {
            throw new OStorageException("Index definition has to be provided");
        }
        OType[] keyTypes = indexDefinition.getTypes();
        if (keyTypes == null || keyTypes.length == 0) {
            throw new OStorageException("Types of index keys has to be defined");
        }
        if (keyTypes.length < indexDefinition.getFields().size()) {
            throw new OStorageException("Types are provided only for " + keyTypes.length + " fields. But index definition has " + indexDefinition.getFields().size() + " fields.");
        }
        if (indexDefinition.getTypes().length > 1) {
            keySerializer = OCompositeKeySerializer.INSTANCE;
        } else {
            OType keyType = indexDefinition.getTypes()[0];
            if (keyType == OType.STRING && this.configuration.getBinaryFormatVersion() >= 13) {
                return OUTF8Serializer.INSTANCE;
            }
            OCurrentStorageComponentsFactory currentStorageComponentsFactory = this.componentsFactory;
            if (currentStorageComponentsFactory != null) {
                keySerializer = currentStorageComponentsFactory.binarySerializerFactory.getObjectSerializer(keyType);
            } else {
                throw new IllegalStateException("Cannot load binary serializer, storage is not properly initialized");
            }
        }
        return keySerializer;
    }

    public void deleteIndexEngine(int indexId) throws OInvalidIndexEngineIdException {
        int internalIndexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        try {
            this.checkOpenness();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.checkIndexId(internalIndexId);
                this.makeStorageDirty();
                this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> {
                    OBaseIndexEngine engine = this.deleteIndexEngineInternal(atomicOperation, internalIndexId);
                    String engineName = engine.getName();
                    OStorageConfiguration.IndexEngineData engineData = this.configuration.getIndexEngine(engineName, internalIndexId);
                    ((OClusterBasedStorageConfiguration)this.configuration).deleteIndexEngine(atomicOperation, engineName);
                    if (engineData.isMultivalue() && (engine instanceof OSBTreeIndexEngine || engine instanceof OHashTableIndexEngine || engine instanceof OAutoShardingIndexEngine)) {
                        OSBTreeBonsaiLocal tree = new OSBTreeBonsaiLocal(engineName, ".irs", this);
                        tree.deleteComponent(atomicOperation);
                    }
                });
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error on index deletion"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private OBaseIndexEngine deleteIndexEngineInternal(OAtomicOperation atomicOperation, int indexId) throws IOException {
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        this.indexEngines.set(indexId, null);
        engine.delete(atomicOperation);
        String engineName = engine.getName();
        this.indexEngineNameMap.remove(engineName);
        return engine;
    }

    private void checkIndexId(int indexId) throws OInvalidIndexEngineIdException {
        if (indexId < 0 || indexId >= this.indexEngines.size() || this.indexEngines.get(indexId) == null) {
            throw new OInvalidIndexEngineIdException("Engine with id " + indexId + " is not registered inside of storage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKeyFromIndex(int indexId, Object key) throws OInvalidIndexEngineIdException {
        int internalIndexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            OAtomicOperation atomicOperation2 = OAtomicOperationsManager.getCurrentOperation();
            return this.removeKeyFromIndexInternal(atomicOperation2, internalIndexId, key);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            boolean atomicOperation2 = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.removeKeyFromIndexInternal(atomicOperation, internalIndexId, key));
            this.stateLock.releaseReadLock();
            return atomicOperation2;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private boolean removeKeyFromIndexInternal(OAtomicOperation atomicOperation, int indexId, Object key) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            this.makeStorageDirty();
            OBaseIndexEngine engine = this.indexEngines.get(indexId);
            if (engine.getEngineAPIVersion() == 0) {
                return ((OIndexEngine)engine).remove(atomicOperation, key);
            }
            OV1IndexEngine v1IndexEngine = (OV1IndexEngine)engine;
            if (!v1IndexEngine.isMultiValue()) {
                return ((OSingleValueIndexEngine)engine).remove(atomicOperation, key);
            }
            throw new OStorageException("To remove entry from multi-value index not only key but value also should be provided");
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during removal of entry with key " + key + " from index "), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIndex(int indexId) throws OInvalidIndexEngineIdException {
        int internalIndexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        try {
            if (this.transaction.get() != null) {
                OAtomicOperation atomicOperation2 = OAtomicOperationsManager.getCurrentOperation();
                this.doClearIndex(atomicOperation2, indexId);
                return;
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> this.doClearIndex(atomicOperation, indexId));
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private void doClearIndex(OAtomicOperation atomicOperation, int indexId) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OBaseIndexEngine engine = this.indexEngines.get(indexId);
            assert (indexId == engine.getId());
            this.makeStorageDirty();
            engine.clear(atomicOperation);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during clearing of index"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getIndexValue(int indexId, Object key) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            return this.doGetIndexValue(indexId, key);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            Object object = this.doGetIndexValue(indexId, key);
            this.stateLock.releaseReadLock();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Object doGetIndexValue(int indexId, Object key) throws OInvalidIndexEngineIdException {
        int engineAPIVersion = OAbstractPaginatedStorage.extractEngineAPIVersion(indexId);
        if (engineAPIVersion != 0) {
            throw new IllegalStateException("Unsupported version of index engine API. Required 0 but found " + engineAPIVersion);
        }
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        return ((OIndexEngine)engine).get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<ORID> getIndexValues(int indexId, Object key) throws OInvalidIndexEngineIdException {
        int engineAPIVersion = OAbstractPaginatedStorage.extractEngineAPIVersion(indexId);
        if (engineAPIVersion != 1) {
            throw new IllegalStateException("Unsupported version of index engine API. Required 1 but found " + engineAPIVersion);
        }
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            return this.doGetIndexValues(indexId, key);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            Stream<ORID> stream = this.doGetIndexValues(indexId, key);
            this.stateLock.releaseReadLock();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Stream<ORID> doGetIndexValues(int indexId, Object key) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        return ((OV1IndexEngine)engine).get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBaseIndexEngine getIndexEngine(int indexId) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        this.checkIndexId(indexId);
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OBaseIndexEngine engine = this.indexEngines.get(indexId);
            assert (indexId == engine.getId());
            OBaseIndexEngine oBaseIndexEngine = engine;
            this.stateLock.releaseReadLock();
            return oBaseIndexEngine;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexEntry(int indexId, Object key, OIndexKeyUpdater<Object> valueCreator) throws OInvalidIndexEngineIdException {
        int engineAPIVersion = OAbstractPaginatedStorage.extractEngineAPIVersion(indexId);
        int internalIndexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (engineAPIVersion != 0) {
            throw new IllegalStateException("Unsupported version of index engine API. Required 0 but found " + engineAPIVersion);
        }
        try {
            if (this.transaction.get() != null) {
                OAtomicOperation atomicOperation2 = OAtomicOperationsManager.getCurrentOperation();
                assert (atomicOperation2 != null);
                this.doUpdateIndexEntry(atomicOperation2, indexId, key, valueCreator);
                return;
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> this.doUpdateIndexEntry(atomicOperation, internalIndexId, key, valueCreator));
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T callIndexEngine(boolean readOperation, int indexId, OIndexEngineCallback<T> callback) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                T t = this.doCallIndexEngine(readOperation, indexId, callback);
                return t;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    private <T> T doCallIndexEngine(boolean readOperation, int indexId, OIndexEngineCallback<T> callback) throws OInvalidIndexEngineIdException, IOException {
        this.checkIndexId(indexId);
        if (!readOperation) {
            this.makeStorageDirty();
        }
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        return callback.callEngine(engine);
    }

    private void doUpdateIndexEntry(OAtomicOperation atomicOperation, int indexId, Object key, OIndexKeyUpdater<Object> valueCreator) throws OInvalidIndexEngineIdException, IOException {
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        this.makeStorageDirty();
        ((OIndexEngine)engine).update(atomicOperation, key, valueCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRidIndexEntry(int indexId, Object key, ORID value) throws OInvalidIndexEngineIdException {
        int engineAPIVersion = OAbstractPaginatedStorage.extractEngineAPIVersion(indexId);
        int internalIndexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (engineAPIVersion != 1) {
            throw new IllegalStateException("Unsupported version of index engine API. Required 1 but found " + engineAPIVersion);
        }
        try {
            if (this.transaction.get() != null) {
                OAtomicOperation atomicOperation2 = OAtomicOperationsManager.getCurrentOperation();
                assert (atomicOperation2 != null);
                this.putRidIndexEntryInternal(atomicOperation2, internalIndexId, key, value);
                return;
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> this.putRidIndexEntryInternal(atomicOperation, internalIndexId, key, value));
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private void putRidIndexEntryInternal(OAtomicOperation atomicOperation, int indexId, Object key, ORID value) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OBaseIndexEngine engine = this.indexEngines.get(indexId);
            assert (engine.getId() == indexId);
            this.makeStorageDirty();
            ((OV1IndexEngine)engine).put(atomicOperation, key, value);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key " + key + " value " + value + " entry to the index"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRidIndexEntry(int indexId, Object key, ORID value) throws OInvalidIndexEngineIdException {
        int engineAPIVersion = OAbstractPaginatedStorage.extractEngineAPIVersion(indexId);
        int internalIndexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (engineAPIVersion != 1) {
            throw new IllegalStateException("Unsupported version of index engine API. Required 1 but found " + engineAPIVersion);
        }
        if (this.transaction.get() != null) {
            OAtomicOperation atomicOperation2 = OAtomicOperationsManager.getCurrentOperation();
            assert (atomicOperation2 != null);
            return this.removeRidIndexEntryInternal(atomicOperation2, internalIndexId, key, value);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            boolean atomicOperation2 = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.removeRidIndexEntryInternal(atomicOperation, internalIndexId, key, value));
            this.stateLock.releaseReadLock();
            return atomicOperation2;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private boolean removeRidIndexEntryInternal(OAtomicOperation atomicOperation, int indexId, Object key, ORID value) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OBaseIndexEngine engine = this.indexEngines.get(indexId);
            assert (engine.getId() == indexId);
            this.makeStorageDirty();
            return ((OMultiValueIndexEngine)engine).remove(atomicOperation, key, value);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key " + key + " value " + value + " entry to the index"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIndexValue(int indexId, Object key, Object value) throws OInvalidIndexEngineIdException {
        int engineAPIVersion = OAbstractPaginatedStorage.extractEngineAPIVersion(indexId);
        int internalIndexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (engineAPIVersion != 0) {
            throw new IllegalStateException("Unsupported version of index engine API. Required 0 but found " + engineAPIVersion);
        }
        try {
            if (this.transaction.get() != null) {
                OAtomicOperation atomicOperation2 = OAtomicOperationsManager.getCurrentOperation();
                assert (atomicOperation2 != null);
                this.putIndexValueInternal(atomicOperation2, indexId, key, value);
                return;
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> this.putIndexValueInternal(atomicOperation, internalIndexId, key, value));
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (OInvalidIndexEngineIdException ie) {
            throw this.logAndPrepareForRethrow(ie);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private void putIndexValueInternal(OAtomicOperation atomicOperation, int indexId, Object key, Object value) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OBaseIndexEngine engine = this.indexEngines.get(indexId);
            assert (engine.getId() == indexId);
            this.makeStorageDirty();
            ((OIndexEngine)engine).put(atomicOperation, key, value);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key " + key + " value " + value + " entry to the index"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validatedPutIndexValue(int indexId, Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) throws OInvalidIndexEngineIdException {
        int internalIndexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            OAtomicOperation atomicOperation2 = OAtomicOperationsManager.getCurrentOperation();
            assert (atomicOperation2 != null);
            return this.doValidatedPutIndexValue(atomicOperation2, internalIndexId, key, value, validator);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            boolean atomicOperation2 = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.doValidatedPutIndexValue(atomicOperation, internalIndexId, key, value, validator));
            this.stateLock.releaseReadLock();
            return atomicOperation2;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private boolean doValidatedPutIndexValue(OAtomicOperation atomicOperation, int indexId, Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OBaseIndexEngine engine = this.indexEngines.get(indexId);
            assert (indexId == engine.getId());
            this.makeStorageDirty();
            if (engine instanceof OIndexEngine) {
                return ((OIndexEngine)engine).validatedPut(atomicOperation, key, value, validator);
            }
            if (engine instanceof OSingleValueIndexEngine) {
                return ((OSingleValueIndexEngine)engine).validatedPut(atomicOperation, key, value.getIdentity(), validator);
            }
            throw new IllegalStateException("Invalid type of index engine " + engine.getClass().getName());
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key " + key + " value " + value + " entry to the index"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<ORawPair<Object, ORID>> iterateIndexEntriesBetween(int indexId, Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            return this.doIterateIndexEntriesBetween(indexId, rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            Stream<ORawPair<Object, ORID>> stream = this.doIterateIndexEntriesBetween(indexId, rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
            this.stateLock.releaseReadLock();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Stream<ORawPair<Object, ORID>> doIterateIndexEntriesBetween(int indexId, Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        return engine.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<ORawPair<Object, ORID>> iterateIndexEntriesMajor(int indexId, Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            return this.doIterateIndexEntriesMajor(indexId, fromKey, isInclusive, ascSortOrder, transformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            Stream<ORawPair<Object, ORID>> stream = this.doIterateIndexEntriesMajor(indexId, fromKey, isInclusive, ascSortOrder, transformer);
            this.stateLock.releaseReadLock();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Stream<ORawPair<Object, ORID>> doIterateIndexEntriesMajor(int indexId, Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        return engine.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<ORawPair<Object, ORID>> iterateIndexEntriesMinor(int indexId, Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            return this.doIterateIndexEntriesMinor(indexId, toKey, isInclusive, ascSortOrder, transformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            Stream<ORawPair<Object, ORID>> stream = this.doIterateIndexEntriesMinor(indexId, toKey, isInclusive, ascSortOrder, transformer);
            this.stateLock.releaseReadLock();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Stream<ORawPair<Object, ORID>> doIterateIndexEntriesMinor(int indexId, Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        return engine.iterateEntriesMinor(toKey, isInclusive, ascSortOrder, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<ORawPair<Object, ORID>> getIndexStream(int indexId, OBaseIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            return this.doGetIndexStream(indexId, valuesTransformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            Stream<ORawPair<Object, ORID>> stream = this.doGetIndexStream(indexId, valuesTransformer);
            this.stateLock.releaseReadLock();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Stream<ORawPair<Object, ORID>> doGetIndexStream(int indexId, OBaseIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        return engine.stream(valuesTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<ORawPair<Object, ORID>> getIndexDescStream(int indexId, OBaseIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            return this.doGetIndexDescStream(indexId, valuesTransformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            Stream<ORawPair<Object, ORID>> stream = this.doGetIndexDescStream(indexId, valuesTransformer);
            this.stateLock.releaseReadLock();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Stream<ORawPair<Object, ORID>> doGetIndexDescStream(int indexId, OBaseIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        return engine.descStream(valuesTransformer);
    }

    public Stream<Object> getIndexKeyStream(int indexId) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            return this.doGetIndexKeyStream(indexId);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            Stream<Object> stream = this.doGetIndexKeyStream(indexId);
            this.stateLock.releaseReadLock();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private Stream<Object> doGetIndexKeyStream(int indexId) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        return engine.keyStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIndexSize(int indexId, OBaseIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            return this.doGetIndexSize(indexId, transformer);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            long l = this.doGetIndexSize(indexId, transformer);
            this.stateLock.releaseReadLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private long doGetIndexSize(int indexId, OBaseIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        return engine.size(transformer);
    }

    public boolean hasIndexRangeQuerySupport(int indexId) throws OInvalidIndexEngineIdException {
        indexId = OAbstractPaginatedStorage.extractInternalId(indexId);
        if (this.transaction.get() != null) {
            return this.doHasRangeQuerySupport(indexId);
        }
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            boolean bl = this.doHasRangeQuerySupport(indexId);
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (OInvalidIndexEngineIdException ie) {
                throw this.logAndPrepareForRethrow(ie);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private boolean doHasRangeQuerySupport(int indexId) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OBaseIndexEngine engine = this.indexEngines.get(indexId);
        assert (indexId == engine.getId());
        return engine.hasRangeQuerySupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(OTransactionInternal clientTx) {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                try {
                    this.checkOpenness();
                    if (this.transaction.get() == null) {
                        return;
                    }
                    if (this.transaction.get().getClientTx().getId() != clientTx.getId()) {
                        throw new OStorageException("Passed in and active transaction are different transactions. Passed in transaction cannot be rolled back.");
                    }
                    this.makeStorageDirty();
                    this.rollbackStorageTx();
                    OTransactionAbstract.updateCacheFromEntries(clientTx.getDatabase(), clientTx.getRecordOperations(), false);
                    this.txRollback.increment();
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Error during transaction rollback"), e);
                }
                finally {
                    this.transaction.set(null);
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public final boolean checkForRecordValidity(OPhysicalPosition ppos) {
        try {
            return ppos != null && !ORecordVersionHelper.isTombstone(ppos.recordVersion);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void synch() {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                long timer = Orient.instance().getProfiler().startChrono();
                long lockId = this.atomicOperationsManager.freezeAtomicOperations(null, null);
                try {
                    this.checkOpenness();
                    this.checkIfThreadIsBlocked();
                    if (this.jvmError.get() == null) {
                        for (OBaseIndexEngine indexEngine : this.indexEngines) {
                            try {
                                if (indexEngine == null) continue;
                                indexEngine.flush();
                            }
                            catch (Throwable t) {
                                OLogManager.instance().error(this, "Error while flushing index via index engine of class %s.", t, indexEngine.getClass().getSimpleName());
                            }
                        }
                        this.makeFullCheckpoint();
                    } else {
                        OLogManager.instance().errorNoDb(this, "Sync can not be performed because of JVM error on storage", null, new Object[0]);
                    }
                }
                finally {
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                    Orient.instance().getProfiler().stopChrono("db." + this.name + ".synch", "Synch a database", timer, "db.*.synch");
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final String getPhysicalClusterNameById(int iClusterId) {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                if (iClusterId < 0 || iClusterId >= this.clusters.size()) {
                    String string = null;
                    return string;
                }
                String string = this.clusters.get(iClusterId) != null ? this.clusters.get(iClusterId).getName() : null;
                return string;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public final int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public final void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    @Override
    public String getClusterName(int clusterId) {
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            if (clusterId == -1) {
                clusterId = this.defaultClusterId;
            }
            String string = this.doGetAndCheckCluster(clusterId).getName();
            return string;
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    private OCluster doGetClusterByName(String clusterName) {
        OCluster cluster = this.clusterMap.get(clusterName.toLowerCase(this.configuration.getLocaleInstance()));
        if (cluster == null) {
            throw new OStorageException("Cluster " + clusterName + " does not exist in database '" + this.name + "'");
        }
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getSize() {
        try {
            try {
                long size = 0L;
                this.stateLock.acquireReadLock();
                try {
                    this.checkOpenness();
                    this.checkIfThreadIsBlocked();
                    for (OCluster c : this.clusters) {
                        if (c == null) continue;
                        size += c.getRecordsSize();
                    }
                }
                finally {
                    this.stateLock.releaseReadLock();
                }
                return size;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cannot calculate records size"), ioe);
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public final int getClusters() {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            int n = this.clusterMap.size();
            this.stateLock.releaseReadLock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<OCluster> getClusterInstances() {
        this.checkOpenness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            HashSet<OCluster> result = new HashSet<OCluster>(1024);
            for (OCluster c : this.clusters) {
                if (c == null) continue;
                result.add(c);
            }
            HashSet<OCluster> hashSet = result;
            this.stateLock.releaseReadLock();
            return hashSet;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    @Override
    public final boolean cleanOutRecord(ORecordId recordId, int recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.deleteRecord(recordId, recordVersion, iMode, callback).getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void freeze(boolean throwException) {
        try {
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                if (throwException) {
                    this.atomicOperationsManager.freezeAtomicOperations(OModificationOperationProhibitedException.class, "Modification requests are prohibited");
                } else {
                    this.atomicOperationsManager.freezeAtomicOperations(null, null);
                }
                ArrayList<OFreezableStorageComponent> frozenIndexes = new ArrayList<OFreezableStorageComponent>(this.indexEngines.size());
                try {
                    for (OBaseIndexEngine indexEngine : this.indexEngines) {
                        if (!(indexEngine instanceof OFreezableStorageComponent)) continue;
                        ((OFreezableStorageComponent)((Object)indexEngine)).freeze(false);
                        frozenIndexes.add((OFreezableStorageComponent)((Object)indexEngine));
                    }
                }
                catch (Exception e) {
                    for (OFreezableStorageComponent indexEngine : frozenIndexes) {
                        indexEngine.release();
                    }
                    throw OException.wrapException(new OStorageException("Error on freeze of storage '" + this.name + "'"), e);
                }
                this.synch();
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public final void release() {
        try {
            for (OBaseIndexEngine indexEngine : this.indexEngines) {
                if (!(indexEngine instanceof OFreezableStorageComponent)) continue;
                ((OFreezableStorageComponent)((Object)indexEngine)).release();
            }
            this.atomicOperationsManager.releaseAtomicOperations(-1L);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public final boolean isRemote() {
        return false;
    }

    public boolean wereDataRestoredAfterOpen() {
        return this.wereDataRestoredAfterOpen;
    }

    public boolean wereNonTxOperationsPerformedInPreviousOpen() {
        return this.wereNonTxOperationsPerformedInPreviousOpen;
    }

    @Override
    public final void reload() {
        try {
            this.close();
            this.open(null, null, null);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public String getMode() {
        return this.mode;
    }

    @Override
    public final void lowDiskSpace(OLowDiskSpaceInformation information) {
        this.lowDiskSpace = information;
    }

    @Override
    public final void pageIsBroken(String fileName, long pageIndex) {
        this.brokenPages.add(new OPair<String, Long>(fileName, pageIndex));
    }

    @Override
    public final void requestCheckpoint() {
        try {
            if (!this.walVacuumInProgress.get() && this.walVacuumInProgress.compareAndSet(false, true)) {
                fuzzyCheckpointExecutor.submit(new WALVacuum());
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public final Object command(OCommandRequestText iCommand) {
        try {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
            while (true) {
                try {
                    OCommandExecutor executor = db.getSharedContext().getOrientDB().getScriptManager().getCommandManager().getExecutor(iCommand);
                    executor.setContext(iCommand.getContext());
                    executor.setProgressListener(iCommand.getProgressListener());
                    executor.parse(iCommand);
                    return this.executeCommand(iCommand, executor);
                }
                catch (ORetryQueryException ignore) {
                    if (!(iCommand instanceof OQueryAbstract)) continue;
                    OQueryAbstract query = (OQueryAbstract)((Object)iCommand);
                    query.reset();
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee, false);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object executeCommand(OCommandRequestText iCommand, OCommandExecutor executor) {
        try {
            if (iCommand.isIdempotent() && !executor.isIdempotent()) {
                throw new OCommandExecutionException("Cannot execute non idempotent command");
            }
            long beginTime = Orient.instance().getProfiler().startChrono();
            try {
                Map<Object, Object> params;
                ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
                Iterable<ODatabaseListener> listeners = db.getListeners();
                for (ODatabaseListener oDatabaseListener : listeners) {
                    oDatabaseListener.onBeforeCommand(iCommand, executor);
                }
                boolean foundInCache = false;
                Object result = null;
                if (iCommand.isCacheableResult() && executor.isCacheable() && iCommand.getParameters() == null && (result = db.getMetadata().getCommandCache().get(db.getUser(), iCommand.getText(), iCommand.getLimit())) != null) {
                    foundInCache = true;
                    if (iCommand.getResultListener() != null) {
                        if (result instanceof Collection) {
                            for (Object o : (Collection)result) {
                                iCommand.getResultListener().result(o);
                            }
                        } else {
                            iCommand.getResultListener().result(result);
                        }
                        result = null;
                    }
                }
                if (!foundInCache && (result = executor.execute(params = iCommand.getParameters())) != null && iCommand.isCacheableResult() && executor.isCacheable() && (iCommand.getParameters() == null || iCommand.getParameters().isEmpty())) {
                    db.getMetadata().getCommandCache().put(db.getUser(), iCommand.getText(), result, iCommand.getLimit(), executor.getInvolvedClusters(), System.currentTimeMillis() - beginTime);
                }
                for (ODatabaseListener oDatabaseListener : listeners) {
                    oDatabaseListener.onAfterCommand(iCommand, executor, result);
                }
                Iterator iterator = result;
                return iterator;
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                throw OException.wrapException(new OCommandExecutionException("Error on execution of command: " + iCommand), e);
            }
            finally {
                ODatabaseDocumentInternal db;
                if (Orient.instance().getProfiler().isRecording() && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
                    OSecurityUser user = db.getUser();
                    String userString = Optional.ofNullable(user).map(Object::toString).orElse(null);
                    Orient.instance().getProfiler().stopChrono("db." + ODatabaseRecordThreadLocal.instance().get().getName() + ".command." + iCommand, "Command executed against the database", beginTime, "db.*.command.*", null, userString);
                }
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee, false);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        try {
            if (currentClusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                OCluster cluster = this.doGetAndCheckCluster(currentClusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.higherPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + currentClusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        try {
            if (clusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                OCluster cluster = this.doGetAndCheckCluster(clusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.ceilingPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + clusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        try {
            if (currentClusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                OCluster cluster = this.doGetAndCheckCluster(currentClusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.lowerPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + currentClusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        try {
            if (clusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpenness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpenness();
                this.checkIfThreadIsBlocked();
                OCluster cluster = this.doGetAndCheckCluster(clusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.floorPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + clusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public void acquireWriteLock(ORID rid, long timeout) {
        if (!this.modificationLock) {
            throw new ODatabaseException("Record write locks are off by configuration, set the configuration \"storage.pessimisticLock\" to \"readwrite\" for enable them");
        }
        try {
            this.lockManager.acquireWriteLock(rid, timeout);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public final void acquireWriteLock(ORID rid) {
        if (!this.modificationLock) {
            throw new ODatabaseException("Record write locks are off by configuration, set the configuration \"storage.pessimisticLock\" to \"modification\" for enable them");
        }
        try {
            this.lockManager.acquireWriteLock(rid, 0L);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public final void releaseWriteLock(ORID rid) {
        try {
            this.lockManager.releaseWriteLock(rid);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public final void acquireReadLock(ORID rid) {
        if (!this.readLock) {
            throw new ODatabaseException("Record read locks are off by configuration, set the configuration \"storage.pessimisticLock\" to \"readwrite\" for enable them");
        }
        try {
            this.lockManager.acquireReadLock(rid.copy(), 0L);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public void acquireReadLock(ORID rid, long timeout) {
        if (!this.readLock) {
            throw new ODatabaseException("Record read locks are off by configuration, set the configuration \"storage.pessimisticLock\" to \"readwrite\" for enable them");
        }
        try {
            this.lockManager.acquireReadLock(rid, timeout);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    public final void releaseReadLock(ORID rid) {
        try {
            this.lockManager.releaseReadLock(rid);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public final ORecordConflictStrategy getRecordConflictStrategy() {
        return this.recordConflictStrategy;
    }

    @Override
    public final void setConflictStrategy(ORecordConflictStrategy conflictResolver) {
        Objects.requireNonNull(conflictResolver);
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> this.doSetConflictStrategy(conflictResolver, atomicOperation));
        }
        catch (Exception e) {
            throw OException.wrapException(new OStorageException("Exception during setting of conflict strategy " + conflictResolver.getName() + " for storage " + this.name), e);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    private void doSetConflictStrategy(ORecordConflictStrategy conflictResolver, OAtomicOperation atomicOperation) throws IOException {
        if (this.recordConflictStrategy == null || !this.recordConflictStrategy.getName().equals(conflictResolver.getName())) {
            this.makeStorageDirty();
            this.recordConflictStrategy = conflictResolver;
            ((OClusterBasedStorageConfiguration)this.configuration).setConflictStrategy(atomicOperation, conflictResolver.getName());
        }
    }

    public long getRecordScanned() {
        return this.recordScanned.value;
    }

    protected abstract OLogSequenceNumber copyWALToIncrementalBackup(ZipOutputStream var1, long var2) throws IOException;

    protected abstract boolean isWriteAllowedDuringIncrementalBackup();

    public OStorageRecoverListener getRecoverListener() {
        return this.recoverListener;
    }

    public void registerRecoverListener(OStorageRecoverListener recoverListener) {
        this.recoverListener = recoverListener;
    }

    public void unregisterRecoverListener(OStorageRecoverListener recoverListener) {
        if (this.recoverListener == recoverListener) {
            this.recoverListener = null;
        }
    }

    protected abstract File createWalTempDirectory();

    protected abstract void addFileToDirectory(String var1, InputStream var2, File var3) throws IOException;

    protected abstract OWriteAheadLog createWalFromIBUFiles(File var1, OContextConfiguration var2, Locale var3, byte[] var4) throws IOException;

    protected final void checkOpenness() {
        if (this.status != OStorage.STATUS.OPEN) {
            throw new OStorageException("Storage " + this.name + " is not opened.");
        }
    }

    public void rollbackOperationsFromThread(Thread thread) {
        try {
            this.checkOpenness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpenness();
                this.blockedThreads.add(thread);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    private void checkIfThreadIsBlocked() {
        Thread thread = Thread.currentThread();
        if (!this.blockedThreads.isEmpty() && this.blockedThreads.contains(thread)) {
            thread.interrupt();
            OLogManager.instance().warnNoDb(this, "Execution  of thread '%s' is interrupted", thread);
            throw new OStorageException("Operations on thread '" + thread + "' are blocked and can not be performed. Thread will be interrupted.");
        }
    }

    protected final void makeFuzzyCheckpoint() {
        while (!this.stateLock.tryAcquireReadLock(1000000L)) {
            if (this.status == OStorage.STATUS.OPEN) continue;
            return;
        }
        try {
            long fuzzySegment;
            if (this.status != OStorage.STATUS.OPEN) {
                return;
            }
            OLogSequenceNumber beginLSN = this.writeAheadLog.begin();
            OLogSequenceNumber endLSN = this.writeAheadLog.end();
            Long minLSNSegment = this.writeCache.getMinimalNotFlushedSegment();
            if (minLSNSegment != null) {
                fuzzySegment = minLSNSegment;
            } else {
                if (endLSN == null) {
                    return;
                }
                fuzzySegment = endLSN.getSegment();
            }
            this.atomicOperationsTable.compactTable();
            long minAtomicOperationSegment = this.atomicOperationsTable.getSegmentEarliestNotPersistedOperation();
            if (minAtomicOperationSegment >= 0L && fuzzySegment > minAtomicOperationSegment) {
                fuzzySegment = minAtomicOperationSegment;
            }
            OLogManager.instance().debugNoDb(this, "Before fuzzy checkpoint: min LSN segment is " + minLSNSegment + ", WAL begin is " + beginLSN + ", WAL end is " + endLSN + ", fuzzy segment is " + fuzzySegment, null, new Object[0]);
            if (fuzzySegment > beginLSN.getSegment() && beginLSN.getSegment() < endLSN.getSegment()) {
                OLogManager.instance().debugNoDb(this, "Making fuzzy checkpoint", null, new Object[0]);
                this.writeCache.makeFuzzyCheckpoint(fuzzySegment, this.lastMetadata);
                beginLSN = this.writeAheadLog.begin();
                endLSN = this.writeAheadLog.end();
                OLogManager.instance().debugNoDb(this, "After fuzzy checkpoint: WAL begin is " + beginLSN + " WAL end is " + endLSN, null, new Object[0]);
            } else {
                OLogManager.instance().debugNoDb(this, "No reason to make fuzzy checkpoint", null, new Object[0]);
            }
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OIOException("Error during fuzzy checkpoint"), ioe);
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public void tryToDeleteTreeRidBag(OSBTreeRidBag ridBag) {
        block8: {
            try {
                this.checkOpenness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                if (this.transaction.get() == null) {
                    this.stateLock.acquireWriteLock();
                    try {
                        this.checkOpenness();
                        this.checkIfThreadIsBlocked();
                        this.doTryToDeleteTreeRidBag(ridBag);
                        break block8;
                    }
                    finally {
                        this.stateLock.releaseWriteLock();
                    }
                }
                this.doTryToDeleteTreeRidBag(ridBag);
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private void doTryToDeleteTreeRidBag(OSBTreeRidBag ridBag) {
        final long delay = this.configuration.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.RID_BAG_SBTREEBONSAI_DELETE_DELAY);
        final long schedule = delay / 3L;
        final OBonsaiCollectionPointer collectionPointer = ridBag.getCollectionPointer();
        Runnable deleteTask = new Runnable(){

            @Override
            public void run() {
                OAbstractPaginatedStorage.this.checkOpenness();
                OAbstractPaginatedStorage.this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                OAbstractPaginatedStorage.this.stateLock.acquireWriteLock();
                try {
                    if (OAbstractPaginatedStorage.this.status == OStorage.STATUS.OPEN) {
                        try {
                            OAbstractPaginatedStorage.this.makeStorageDirty();
                            OAtomicOperationsManager atomicOperationsManager = OAbstractPaginatedStorage.this.atomicOperationsManager;
                            atomicOperationsManager.executeInsideAtomicOperation(null, operation -> {
                                if (!OAbstractPaginatedStorage.this.sbTreeCollectionManager.tryDelete(operation, collectionPointer, delay)) {
                                    Orient.instance().scheduleTask((Runnable)this, schedule, 0L);
                                }
                            });
                        }
                        catch (Exception e) {
                            OLogManager.instance().errorNoDb(this, "Error during deletion of rid bag", e, new Object[0]);
                        }
                    }
                }
                finally {
                    OAbstractPaginatedStorage.this.stateLock.releaseWriteLock();
                }
            }
        };
        Orient.instance().scheduleTask(deleteTask, schedule, 0L);
        ridBag.confirmDelete();
    }

    protected void makeFullCheckpoint() {
        try {
            this.writeAheadLog.flush();
            this.writeAheadLog.appendNewSegment();
            OLogSequenceNumber lastLSN = this.writeAheadLog.logFullCheckpointStart();
            if (this.lastMetadata != null) {
                this.writeAheadLog.log(new MetaDataRecord(this.lastMetadata));
            }
            this.writeCache.flush();
            this.atomicOperationsTable.compactTable();
            long operationSegment = this.atomicOperationsTable.getSegmentEarliestOperationInProgress();
            if (operationSegment >= 0L) {
                throw new IllegalStateException("Can not perform full checkpoint if some of atomic operations in progress");
            }
            this.writeAheadLog.logFullCheckpointEnd();
            this.writeAheadLog.flush();
            this.writeAheadLog.cutTill(lastLSN);
            if (this.jvmError.get() == null) {
                this.clearStorageDirty();
            }
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OStorageException("Error during checkpoint creation for storage " + this.name), ioe);
        }
        ++this.fullCheckpointCount;
    }

    public long getFullCheckpointCount() {
        return this.fullCheckpointCount;
    }

    protected StartupMetadata checkIfStorageDirty() throws IOException {
        return new StartupMetadata(-1L, null);
    }

    protected void initConfiguration(OAtomicOperation atomicOperation, OContextConfiguration contextConfiguration) throws IOException {
    }

    protected final void postCreateSteps() {
    }

    protected void preCreateSteps() throws IOException {
    }

    protected abstract void initWalAndDiskCache(OContextConfiguration var1) throws IOException, InterruptedException;

    protected abstract void postCloseSteps(boolean var1, boolean var2, long var3) throws IOException;

    protected void postCloseStepsAfterLock(Map<String, Object> params) {
    }

    protected Map<String, Object> preCloseSteps() {
        return new HashMap<String, Object>(2);
    }

    protected void postDeleteSteps() {
    }

    protected void makeStorageDirty() throws IOException {
    }

    protected void clearStorageDirty() throws IOException {
    }

    protected boolean isDirty() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer readRecordIfNotLatest(ORecordId rid, int recordVersion) throws ORecordNotFoundException {
        this.checkOpenness();
        if (!rid.isPersistent()) {
            throw new ORecordNotFoundException(rid, "Cannot read record " + rid + " since the position is invalid in database '" + this.name + '\'');
        }
        if (this.transaction.get() != null) {
            OCluster cluster = this.doGetAndCheckCluster(rid.getClusterId());
            return OAbstractPaginatedStorage.doReadRecordIfNotLatest(cluster, rid, recordVersion);
        }
        this.stateLock.acquireReadLock();
        try {
            ORawBuffer buff;
            ODatabaseDocumentInternal db;
            if (this.readLock && ((db = ODatabaseRecordThreadLocal.instance().getIfDefined()) == null || !((OTransactionAbstract)db.getTransaction()).getLockedRecords().contains(rid))) {
                this.acquireReadLock(rid);
            }
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OCluster cluster = this.doGetAndCheckCluster(rid.getClusterId());
            ORawBuffer oRawBuffer = buff = OAbstractPaginatedStorage.doReadRecordIfNotLatest(cluster, rid, recordVersion);
            return oRawBuffer;
        }
        finally {
            try {
                ODatabaseDocumentInternal db;
                if (this.readLock && ((db = ODatabaseRecordThreadLocal.instance().getIfDefined()) == null || !((OTransactionAbstract)db.getTransaction()).getLockedRecords().contains(rid))) {
                    this.releaseReadLock(rid);
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer readRecord(ORecordId rid, boolean prefetchRecords) {
        this.checkOpenness();
        if (!rid.isPersistent()) {
            throw new ORecordNotFoundException(rid, "Cannot read record " + rid + " since the position is invalid in database '" + this.name + '\'');
        }
        if (this.transaction.get() != null) {
            OCluster cluster;
            try {
                cluster = this.doGetAndCheckCluster(rid.getClusterId());
            }
            catch (IllegalArgumentException e) {
                throw OException.wrapException(new ORecordNotFoundException(rid), e);
            }
            return this.doReadRecord(cluster, rid, prefetchRecords);
        }
        this.stateLock.acquireReadLock();
        try {
            OCluster cluster;
            ODatabaseDocumentInternal db;
            if (this.readLock && ((db = ODatabaseRecordThreadLocal.instance().getIfDefined()) == null || !((OTransactionAbstract)db.getTransaction()).getLockedRecords().contains(rid))) {
                this.acquireReadLock(rid);
            }
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            try {
                cluster = this.doGetAndCheckCluster(rid.getClusterId());
            }
            catch (IllegalArgumentException e) {
                throw OException.wrapException(new ORecordNotFoundException(rid), e);
            }
            ORawBuffer oRawBuffer = this.doReadRecord(cluster, rid, prefetchRecords);
            return oRawBuffer;
        }
        finally {
            try {
                ODatabaseDocumentInternal db;
                if (this.readLock && ((db = ODatabaseRecordThreadLocal.instance().getIfDefined()) == null || !((OTransactionAbstract)db.getTransaction()).getLockedRecords().contains(rid))) {
                    this.releaseReadLock(rid);
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
    }

    private void endStorageTx(OTransactionInternal txi, Collection<ORecordOperation> recordOperations) throws IOException {
        this.atomicOperationsManager.endAtomicOperation(false);
        assert (OAtomicOperationsManager.getCurrentOperation() == null);
        OTransactionAbstract.updateCacheFromEntries(txi.getDatabase(), recordOperations, true);
        this.txCommit.increment();
    }

    private void startStorageTx(OTransactionInternal clientTx) throws IOException {
        OStorageTransaction storageTx = this.transaction.get();
        assert (storageTx == null || storageTx.getClientTx().getId() == clientTx.getId());
        assert (OAtomicOperationsManager.getCurrentOperation() == null);
        this.transaction.set(new OStorageTransaction(clientTx));
        try {
            OAtomicOperation atomicOperation = this.atomicOperationsManager.startAtomicOperation(clientTx.getMetadata().orElse(null));
            if (clientTx.getMetadata().isPresent()) {
                this.lastMetadata = clientTx.getMetadata().get();
            }
            clientTx.storageBegun();
            Iterator<byte[]> ops = clientTx.getSerializedOperations();
            while (ops.hasNext()) {
                byte[] next = ops.next();
                this.writeAheadLog.log(new OHighLevelTransactionChangeRecord(atomicOperation.getOperationUnitId(), next));
            }
        }
        catch (RuntimeException e) {
            this.transaction.set(null);
            throw e;
        }
    }

    private void rollbackStorageTx() throws IOException {
        assert (this.transaction.get() != null);
        this.atomicOperationsManager.endAtomicOperation(true);
        assert (OAtomicOperationsManager.getCurrentOperation() == null);
    }

    private void recoverIfNeeded() throws Exception {
        if (this.isDirty()) {
            OLogManager.instance().warn((Object)this, "Storage '" + this.name + "' was not closed properly. Will try to recover from write ahead log", new Object[0]);
            try {
                boolean bl = this.wereDataRestoredAfterOpen = this.restoreFromWAL() != null;
                if (this.recoverListener != null) {
                    this.recoverListener.onStorageRecover();
                }
                this.makeFullCheckpoint();
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Exception during storage data restore", e, new Object[0]);
                throw e;
            }
            OLogManager.instance().info((Object)this, "Storage data recover was completed", new Object[0]);
        }
    }

    private OStorageOperationResult<OPhysicalPosition> doCreateRecord(OAtomicOperation atomicOperation, ORecordId rid, byte[] content, int recordVersion, byte recordType, ORecordCallback<Long> callback, OCluster cluster, OPhysicalPosition allocated) {
        if (content == null) {
            throw new IllegalArgumentException("Record is null");
        }
        try {
            OPhysicalPosition ppos;
            recordVersion = recordVersion > -1 ? ++recordVersion : 0;
            this.makeStorageDirty();
            try {
                ppos = cluster.createRecord(content, recordVersion, recordType, allocated, atomicOperation);
                rid.setClusterPosition(ppos.clusterPosition);
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(atomicOperation, this);
                }
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error on creating record in cluster: " + cluster, e, new Object[0]);
                throw ODatabaseException.wrapException(new OStorageException("Error during creation of record"), e);
            }
            if (callback != null) {
                callback.call(rid, ppos.clusterPosition);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Created record %s v.%s size=%d bytes", rid, recordVersion, content.length);
            }
            this.recordCreated.increment();
            return new OStorageOperationResult<OPhysicalPosition>(ppos);
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OStorageException("Error during record deletion in cluster " + (cluster != null ? cluster.getName() : "")), ioe);
        }
    }

    private OStorageOperationResult<Integer> doUpdateRecord(OAtomicOperation atomicOperation, ORecordId rid, boolean updateContent, byte[] content, int version, byte recordType, ORecordCallback<Integer> callback, OCluster cluster) {
        Orient.instance().getProfiler().startChrono();
        try {
            ORecordSerializationContext context;
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
            if (!this.checkForRecordValidity(ppos)) {
                int recordVersion = -1;
                if (callback != null) {
                    callback.call(rid, -1);
                }
                return new OStorageOperationResult<Integer>(-1);
            }
            boolean contentModified = false;
            if (updateContent) {
                AtomicInteger recVersion = new AtomicInteger(version);
                AtomicInteger dbVersion = new AtomicInteger(ppos.recordVersion);
                byte[] newContent = this.checkAndIncrementVersion(cluster, rid, recVersion, dbVersion, content, recordType);
                ppos.recordVersion = dbVersion.get();
                if (newContent != null) {
                    contentModified = true;
                    content = newContent;
                }
            }
            this.makeStorageDirty();
            if (updateContent) {
                cluster.updateRecord(rid.getClusterPosition(), content, ppos.recordVersion, recordType, atomicOperation);
            }
            if ((context = ORecordSerializationContext.getContext()) != null) {
                context.executeOperations(atomicOperation, this);
            }
            int newRecordVersion = updateContent ? ppos.recordVersion : version;
            if (callback != null) {
                callback.call(rid, newRecordVersion);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Updated record %s v.%s size=%d", rid, newRecordVersion, content.length);
            }
            this.recordUpdated.increment();
            if (contentModified) {
                return new OStorageOperationResult<Integer>(newRecordVersion, content, false);
            }
            return new OStorageOperationResult<Integer>(newRecordVersion);
        }
        catch (OConcurrentModificationException e) {
            this.recordConflict.increment();
            throw e;
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OStorageException("Error on updating record " + rid + " (cluster: " + cluster.getName() + ")"), ioe);
        }
    }

    private OStorageOperationResult<Boolean> doDeleteRecord(OAtomicOperation atomicOperation, ORecordId rid, int version, OCluster cluster) {
        Orient.instance().getProfiler().startChrono();
        try {
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
            if (ppos == null) {
                return new OStorageOperationResult<Boolean>(false);
            }
            if (version > -1 && ppos.recordVersion != version) {
                this.recordConflict.increment();
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(rid, ppos.recordVersion, version, 2);
            }
            this.makeStorageDirty();
            cluster.deleteRecord(atomicOperation, ppos.clusterPosition);
            ORecordSerializationContext context = ORecordSerializationContext.getContext();
            if (context != null) {
                context.executeOperations(atomicOperation, this);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Deleted record %s v.%s", rid, version);
            }
            this.recordDeleted.increment();
            return new OStorageOperationResult<Boolean>(true);
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OStorageException("Error on deleting record " + rid + "( cluster: " + cluster.getName() + ")"), ioe);
        }
    }

    private ORawBuffer doReadRecord(OCluster clusterSegment, ORecordId rid, boolean prefetchRecords) {
        try {
            ORawBuffer buff = clusterSegment.readRecord(rid.getClusterPosition(), prefetchRecords);
            if (buff != null && OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Read record %s v.%s size=%d bytes", rid, buff.version, buff.buffer != null ? buff.buffer.length : 0);
            }
            this.recordRead.increment();
            return buff;
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during read of record with rid = " + rid), e);
        }
    }

    private static ORawBuffer doReadRecordIfNotLatest(OCluster cluster, ORecordId rid, int recordVersion) throws ORecordNotFoundException {
        try {
            return cluster.readRecordIfVersionIsNotLatest(rid.getClusterPosition(), recordVersion);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during read of record with rid = " + rid), e);
        }
    }

    private int createClusterFromConfig(OStorageClusterConfiguration config) throws IOException {
        OCluster cluster = this.clusterMap.get(config.getName().toLowerCase(this.configuration.getLocaleInstance()));
        if (cluster != null) {
            cluster.configure(this, config);
            return -1;
        }
        cluster = config.getStatus() == OStorageClusterConfiguration.STATUS.ONLINE ? OPaginatedClusterFactory.createCluster(config.getName(), this.configuration.getVersion(), config.getBinaryVersion(), this) : new OOfflineCluster(this, config.getId(), config.getName());
        cluster.configure(this, config);
        return this.registerCluster(cluster);
    }

    private void setCluster(int id, OCluster cluster) {
        if (this.clusters.size() <= id) {
            while (this.clusters.size() < id) {
                this.clusters.add(null);
            }
            this.clusters.add(cluster);
        } else {
            this.clusters.set(id, cluster);
        }
    }

    private int registerCluster(OCluster cluster) {
        int id;
        if (cluster != null) {
            if (this.clusterMap.containsKey(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()))) {
                throw new OConfigurationException("Cannot add cluster '" + cluster.getName() + "' because it is already registered in database '" + this.name + "'");
            }
            this.clusterMap.put(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()), cluster);
            id = cluster.getId();
        } else {
            id = this.clusters.size();
        }
        this.setCluster(id, cluster);
        return id;
    }

    private int doAddCluster(OAtomicOperation atomicOperation, String clusterName) throws IOException {
        int clusterPos = this.clusters.size();
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (this.clusters.get(i) != null) continue;
            clusterPos = i;
            break;
        }
        return this.doAddCluster(atomicOperation, clusterName, clusterPos);
    }

    private int doAddCluster(OAtomicOperation atomicOperation, String clusterName, int clusterPos) throws IOException {
        OCluster cluster;
        if (clusterName != null) {
            clusterName = clusterName.toLowerCase(this.configuration.getLocaleInstance());
            cluster = OPaginatedClusterFactory.createCluster(clusterName, this.configuration.getVersion(), OPaginatedCluster.getLatestBinaryVersion(), this);
            cluster.configure(clusterPos, clusterName);
        } else {
            cluster = null;
        }
        int createdClusterId = -1;
        if (cluster != null) {
            cluster.create(atomicOperation);
            createdClusterId = this.registerCluster(cluster);
            ((OClusterBasedStorageConfiguration)this.configuration).updateCluster(atomicOperation, ((OPaginatedCluster)cluster).generateClusterConfig());
            this.sbTreeCollectionManager.createComponent(atomicOperation, createdClusterId);
        }
        return createdClusterId;
    }

    @Override
    public boolean setClusterAttribute(int id, OCluster.ATTRIBUTES attribute, Object value) {
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            if (id >= this.clusters.size()) {
                boolean bl = false;
                return bl;
            }
            OCluster cluster = this.clusters.get(id);
            if (cluster == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.doSetClusterAttributed(atomicOperation, attribute, value, cluster));
            return bl;
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setClusterAttribute(String clusterName, OCluster.ATTRIBUTES attribute, Object value) {
        Objects.requireNonNull(clusterName);
        this.checkOpenness();
        this.checkIfThreadIsBlocked();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            OCluster cluster = this.clusterMap.get(clusterName.toLowerCase(this.configuration.getLocaleInstance()));
            if (cluster == null) {
                this.throwClusterDoesNotExist(clusterName);
            }
            this.makeStorageDirty();
            boolean bl = this.atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.doSetClusterAttributed(atomicOperation, attribute, value, cluster));
            this.stateLock.releaseWriteLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseWriteLock();
                throw throwable;
            }
            catch (RuntimeException ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Error ee) {
                throw this.logAndPrepareForRethrow(ee);
            }
            catch (Throwable t) {
                throw this.logAndPrepareForRethrow(t);
            }
        }
    }

    private boolean doSetClusterAttributed(OAtomicOperation atomicOperation, OCluster.ATTRIBUTES attribute, Object value, OCluster cluster) throws IOException {
        this.makeStorageDirty();
        String stringValue = Optional.ofNullable(value).map(Object::toString).orElse(null);
        switch (attribute) {
            case NAME: {
                Objects.requireNonNull(stringValue);
                Locale locale = this.configuration.getLocaleInstance();
                String oldName = cluster.getName();
                cluster.setClusterName(stringValue);
                this.clusterMap.remove(oldName.toLowerCase(locale));
                this.clusterMap.put(stringValue.toLowerCase(locale), cluster);
                break;
            }
            case CONFLICTSTRATEGY: {
                cluster.setRecordConflictStrategy(stringValue);
                break;
            }
            case STATUS: {
                if (stringValue == null) {
                    throw new IllegalStateException("Value of attribute is null");
                }
                return this.setClusterStatus(atomicOperation, cluster, OStorageClusterConfiguration.STATUS.valueOf(stringValue.toUpperCase(this.configuration.getLocaleInstance())));
            }
            case ENCRYPTION: {
                throw new UnsupportedOperationException("Encryption should be configured on storage level.");
            }
            default: {
                throw new IllegalArgumentException("Runtime change of attribute '" + (Object)((Object)attribute) + "' is not supported");
            }
        }
        ((OClusterBasedStorageConfiguration)this.configuration).updateCluster(atomicOperation, ((OPaginatedCluster)cluster).generateClusterConfig());
        return true;
    }

    private boolean dropClusterInternal(OAtomicOperation atomicOperation, int clusterId) throws IOException {
        OCluster cluster = this.clusters.get(clusterId);
        if (cluster == null) {
            return true;
        }
        this.makeStorageDirty();
        cluster.delete(atomicOperation);
        this.clusterMap.remove(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()));
        this.clusters.set(clusterId, null);
        return false;
    }

    private void doClose(boolean force, boolean onDelete) {
        if (!force && !onDelete) {
            this.decOnClose();
            return;
        }
        if (this.status == OStorage.STATUS.CLOSED) {
            return;
        }
        long timer = Orient.instance().getProfiler().startChrono();
        HashMap<String, Object> params = new HashMap(2);
        this.stateLock.acquireWriteLock();
        try {
            if (this.status == OStorage.STATUS.CLOSED) {
                return;
            }
            this.status = OStorage.STATUS.CLOSING;
            if (this.jvmError.get() == null) {
                if (!onDelete && this.jvmError.get() == null) {
                    this.makeFullCheckpoint();
                }
                params = this.preCloseSteps();
                if (!onDelete) {
                    this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> {
                        for (OBaseIndexEngine engine : this.indexEngines) {
                            if (engine == null || engine instanceof OSBTreeIndexEngine || engine instanceof OHashTableIndexEngine || engine instanceof OCellBTreeSingleValueIndexEngine || engine instanceof OCellBTreeMultiValueIndexEngine || engine instanceof OAutoShardingIndexEngine) continue;
                            engine.close();
                        }
                        ((OClusterBasedStorageConfiguration)this.configuration).close(atomicOperation);
                    });
                } else {
                    for (OBaseIndexEngine engine : this.indexEngines) {
                        if (engine == null || engine instanceof OSBTreeIndexEngine || engine instanceof OHashTableIndexEngine || engine instanceof OCellBTreeSingleValueIndexEngine || engine instanceof OCellBTreeMultiValueIndexEngine || engine instanceof OAutoShardingIndexEngine) continue;
                        engine.delete(null);
                    }
                }
                this.sbTreeCollectionManager.close();
                this.clusters.clear();
                this.clusterMap.clear();
                this.indexEngines.clear();
                this.indexEngineNameMap.clear();
                super.close(force, onDelete);
                if (this.writeCache != null) {
                    this.writeCache.removeLowDiskSpaceListener(this);
                    this.writeCache.removeBackgroundExceptionListener(this);
                    this.writeCache.removePageIsBrokenListener(this);
                }
                this.writeAheadLog.removeFullCheckpointListener(this);
                this.writeAheadLog.removeLowDiskSpaceListener(this);
                if (this.readCache != null) {
                    if (!onDelete) {
                        this.readCache.closeStorage(this.writeCache);
                    } else {
                        this.readCache.deleteStorage(this.writeCache);
                    }
                }
                if (onDelete) {
                    this.writeAheadLog.delete();
                } else {
                    this.writeAheadLog.close();
                }
                this.postCloseSteps(onDelete, this.jvmError.get() != null, this.idGen.getLastId());
                this.transaction = null;
                this.lastMetadata = null;
            } else {
                OLogManager.instance().errorNoDb(this, "Because of JVM error happened inside of storage it can not be properly closed", null, new Object[0]);
            }
            this.status = OStorage.STATUS.CLOSED;
        }
        catch (IOException e) {
            String message = "Error on closing of storage '" + this.name;
            OLogManager.instance().error(this, message, e, new Object[0]);
            throw OException.wrapException(new OStorageException(message), e);
        }
        finally {
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".close", "Close a database", timer, "db.*.close");
            this.stateLock.releaseWriteLock();
        }
        this.postCloseStepsAfterLock(params);
    }

    protected void closeClusters(boolean onDelete) throws IOException {
        for (OCluster cluster : this.clusters) {
            if (cluster == null) continue;
            cluster.close(!onDelete);
        }
        this.clusters.clear();
        this.clusterMap.clear();
    }

    protected void closeIndexes(OAtomicOperation atomicOperation, boolean onDelete) {
        for (OBaseIndexEngine engine : this.indexEngines) {
            if (engine == null) continue;
            if (onDelete) {
                try {
                    engine.delete(atomicOperation);
                }
                catch (IOException e) {
                    OLogManager.instance().error(this, "Can not delete index engine " + engine.getName(), e, new Object[0]);
                }
                continue;
            }
            engine.close();
        }
        this.indexEngines.clear();
        this.indexEngineNameMap.clear();
    }

    private byte[] checkAndIncrementVersion(OCluster iCluster, ORecordId rid, AtomicInteger version, AtomicInteger iDatabaseVersion, byte[] iRecordContent, byte iRecordType) {
        int v = version.get();
        switch (v) {
            case -1: {
                iDatabaseVersion.incrementAndGet();
                break;
            }
            case -2: {
                break;
            }
            default: {
                if (v < -2) {
                    version.set(ORecordVersionHelper.clearRollbackMode(v));
                    iDatabaseVersion.set(version.get());
                    break;
                }
                if (v != iDatabaseVersion.get()) {
                    ORecordConflictStrategy strategy = iCluster.getRecordConflictStrategy() != null ? iCluster.getRecordConflictStrategy() : this.recordConflictStrategy;
                    return strategy.onUpdate(this, iRecordType, rid, v, iRecordContent, iDatabaseVersion);
                }
                iDatabaseVersion.incrementAndGet();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void commitEntry(OAtomicOperation atomicOperation, ORecordOperation txEntry, OPhysicalPosition allocated, ORecordSerializer serializer) {
        rec = txEntry.getRecord();
        if (txEntry.type != 2 && !rec.isDirty()) {
            return;
        }
        rid = (ORecordId)rec.getIdentity();
        if (txEntry.type == 1 && rid.isNew()) {
            txEntry.type = (byte)3;
        }
        ORecordSerializationContext.pushContext();
        try {
            cluster = this.doGetAndCheckCluster(rid.getClusterId());
            if (cluster.getName().equals("index") || cluster.getName().equals("manindex")) {
                return;
            }
            switch (txEntry.type) {
                case 0: {
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 3: {
                    stream = serializer.toStream(rec);
                    if (allocated != null) {
                        recordType = ORecordInternal.getRecordType(rec);
                        ppos = this.doCreateRecord(atomicOperation, rid, stream, rec.getVersion(), recordType, null, cluster, allocated).getResult();
                        ORecordInternal.setVersion(rec, ppos.recordVersion);
                        ** break;
lbl24:
                        // 1 sources

                    } else {
                        updateRes = this.doUpdateRecord(atomicOperation, rid, ORecordInternal.isContentChanged(rec), stream, -2, ORecordInternal.getRecordType(rec), null, cluster);
                        ORecordInternal.setVersion(rec, updateRes.getResult());
                        if (updateRes.getModifiedRecordContent() != null) {
                            ORecordInternal.fill(rec, rid, updateRes.getResult(), updateRes.getModifiedRecordContent(), false);
                            ** break;
                        }
                    }
lbl31:
                    // 3 sources

                    break;
                }
                case 1: {
                    stream = serializer.toStream(rec);
                    updateRes = this.doUpdateRecord(atomicOperation, rid, ORecordInternal.isContentChanged(rec), stream, rec.getVersion(), ORecordInternal.getRecordType(rec), null, cluster);
                    txEntry.setResultData(updateRes.getResult());
                    ORecordInternal.setVersion(rec, updateRes.getResult());
                    if (updateRes.getModifiedRecordContent() != null) {
                        ORecordInternal.fill(rec, rid, updateRes.getResult(), updateRes.getModifiedRecordContent(), false);
                        ** break;
                    }
lbl41:
                    // 3 sources

                    break;
                }
                case 2: {
                    if (rec instanceof ODocument) {
                        ORidBagDeleter.deleteAllRidBags((ODocument)rec);
                    }
                    this.doDeleteRecord(atomicOperation, rid, rec.getVersion(), cluster);
                    ** break;
lbl48:
                    // 1 sources

                    break;
                }
                default: {
                    throw new OStorageException("Unknown record operation " + txEntry.type);
                }
            }
        }
        finally {
            ORecordSerializationContext.pullContext();
        }
        if (rec instanceof ODocument && ((ODocument)rec).isTrackingChanges()) {
            ODocumentInternal.clearTrackData((ODocument)rec);
            ODocumentInternal.clearTransactionTrackData((ODocument)rec);
        }
        ORecordInternal.unsetDirty(rec);
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId < 0 || iClusterId > this.clusters.size() - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " does not exist in database '" + this.name + "'");
        }
    }

    private OLogSequenceNumber restoreFromWAL() throws IOException {
        if (this.writeAheadLog.begin() == null) {
            OLogManager.instance().error(this, "Restore is not possible because write ahead log is empty.", null, new Object[0]);
            return null;
        }
        OLogManager.instance().info((Object)this, "Looking for last checkpoint...", new Object[0]);
        OLogSequenceNumber end = this.writeAheadLog.end();
        if (end == null) {
            OLogManager.instance().errorNoDb(this, "WAL is empty, there is nothing not restore", null, new Object[0]);
            return null;
        }
        this.writeAheadLog.addCutTillLimit(end);
        try {
            List<Object> checkPointRecord;
            OLogSequenceNumber lastCheckPoint;
            try {
                lastCheckPoint = this.writeAheadLog.getLastCheckpoint();
            }
            catch (OWALPageBrokenException ignore) {
                lastCheckPoint = null;
            }
            if (lastCheckPoint == null) {
                OLogManager.instance().info((Object)this, "Checkpoints are absent, the restore will start from the beginning.", new Object[0]);
                OLogSequenceNumber ignore = this.restoreFromBeginning();
                return ignore;
            }
            try {
                checkPointRecord = this.writeAheadLog.read(lastCheckPoint, 1);
            }
            catch (OWALPageBrokenException ignore) {
                checkPointRecord = Collections.emptyList();
            }
            if (checkPointRecord.isEmpty()) {
                OLogManager.instance().info((Object)this, "Checkpoints are absent, the restore will start from the beginning.", new Object[0]);
                OLogSequenceNumber ignore = this.restoreFromBeginning();
                return ignore;
            }
            if (checkPointRecord.get(0) instanceof OFuzzyCheckpointStartRecord) {
                OLogManager.instance().info((Object)this, "Found FUZZY checkpoint.", new Object[0]);
                boolean fuzzyCheckPointIsComplete = this.checkFuzzyCheckPointIsComplete(lastCheckPoint);
                if (!fuzzyCheckPointIsComplete) {
                    OLogManager.instance().warn((Object)this, "FUZZY checkpoint is not complete.", new Object[0]);
                    OFuzzyCheckpointStartRecord checkpointStartRecord = (OFuzzyCheckpointStartRecord)checkPointRecord.get(0);
                    OLogSequenceNumber previousCheckpoint = checkpointStartRecord.getPreviousCheckpoint();
                    checkPointRecord = Collections.emptyList();
                    if (previousCheckpoint != null) {
                        checkPointRecord = this.writeAheadLog.read(previousCheckpoint, 1);
                    }
                    if (!checkPointRecord.isEmpty()) {
                        OLogManager.instance().warn((Object)this, "Restore will start from the previous checkpoint.", new Object[0]);
                        OLogSequenceNumber oLogSequenceNumber = this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord.get(0));
                        return oLogSequenceNumber;
                    }
                    OLogManager.instance().warn((Object)this, "Restore will start from the beginning.", new Object[0]);
                    OLogSequenceNumber oLogSequenceNumber = this.restoreFromBeginning();
                    return oLogSequenceNumber;
                }
                OLogSequenceNumber checkpointStartRecord = this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord.get(0));
                return checkpointStartRecord;
            }
            if (checkPointRecord.get(0) instanceof OFullCheckpointStartRecord) {
                OLogManager.instance().info((Object)this, "FULL checkpoint found.", new Object[0]);
                boolean fullCheckPointIsComplete = this.checkFullCheckPointIsComplete(lastCheckPoint);
                if (!fullCheckPointIsComplete) {
                    OLogManager.instance().warn((Object)this, "FULL checkpoint has not completed.", new Object[0]);
                    OFullCheckpointStartRecord checkpointStartRecord = (OFullCheckpointStartRecord)checkPointRecord.get(0);
                    OLogSequenceNumber previousCheckpoint = checkpointStartRecord.getPreviousCheckpoint();
                    checkPointRecord = Collections.emptyList();
                    if (previousCheckpoint != null) {
                        checkPointRecord = this.writeAheadLog.read(previousCheckpoint, 1);
                    }
                    if (!checkPointRecord.isEmpty()) {
                        OLogManager.instance().warn((Object)this, "Restore will start from the previous checkpoint.", new Object[0]);
                        OLogSequenceNumber oLogSequenceNumber = this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord.get(0));
                        return oLogSequenceNumber;
                    }
                    OLogManager.instance().warn((Object)this, "Restore will start from the beginning.", new Object[0]);
                    OLogSequenceNumber oLogSequenceNumber = this.restoreFromBeginning();
                    return oLogSequenceNumber;
                }
                OLogSequenceNumber oLogSequenceNumber = this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord.get(0));
                return oLogSequenceNumber;
            }
            throw new OStorageException("Unknown checkpoint record type " + ((WriteableWALRecord)checkPointRecord.get(0)).getClass().getName());
        }
        finally {
            this.writeAheadLog.removeCutTillLimit(end);
        }
    }

    private boolean checkFullCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        try {
            List<WriteableWALRecord> walRecords = this.writeAheadLog.next(lastCheckPoint, 10);
            while (!walRecords.isEmpty()) {
                for (WriteableWALRecord walRecord : walRecords) {
                    if (!(walRecord instanceof OCheckpointEndRecord)) continue;
                    return true;
                }
                walRecords = this.writeAheadLog.next(walRecords.get(walRecords.size() - 1).getLsn(), 10);
            }
        }
        catch (OWALPageBrokenException ignore) {
            return false;
        }
        return false;
    }

    @Override
    public String incrementalBackup(String backupDirectory, OCallable<Void, Void> started) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Incremental backup is supported only in enterprise version");
    }

    @Override
    public boolean supportIncremental() {
        return false;
    }

    @Override
    public void fullIncrementalBackup(OutputStream stream) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Incremental backup is supported only in enterprise version");
    }

    @Override
    public void restoreFromIncrementalBackup(String filePath) {
        throw new UnsupportedOperationException("Incremental backup is supported only in enterprise version");
    }

    @Override
    public void restoreFullIncrementalBackup(InputStream stream) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Incremental backup is supported only in enterprise version");
    }

    private boolean checkFuzzyCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        try {
            List<WriteableWALRecord> walRecords = this.writeAheadLog.next(lastCheckPoint, 10);
            while (!walRecords.isEmpty()) {
                for (WriteableWALRecord walRecord : walRecords) {
                    if (!(walRecord instanceof OFuzzyCheckpointEndRecord)) continue;
                    return true;
                }
                walRecords = this.writeAheadLog.next(walRecords.get(walRecords.size() - 1).getLsn(), 10);
            }
        }
        catch (OWALPageBrokenException ignore) {
            return false;
        }
        return false;
    }

    private OLogSequenceNumber restoreFromCheckPoint(OAbstractCheckPointStartRecord checkPointRecord) throws IOException {
        if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
            return this.restoreFromFuzzyCheckPoint((OFuzzyCheckpointStartRecord)checkPointRecord);
        }
        if (checkPointRecord instanceof OFullCheckpointStartRecord) {
            return this.restoreFromFullCheckPoint((OFullCheckpointStartRecord)checkPointRecord);
        }
        throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
    }

    private OLogSequenceNumber restoreFromFullCheckPoint(OFullCheckpointStartRecord checkPointRecord) throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure from full checkpoint is started. Restore is performed from LSN %s", checkPointRecord.getLsn());
        OLogSequenceNumber lsn = this.writeAheadLog.next(checkPointRecord.getLsn(), 1).get(0).getLsn();
        return this.restoreFrom(lsn, this.writeAheadLog, true);
    }

    private OLogSequenceNumber restoreFromFuzzyCheckPoint(OFuzzyCheckpointStartRecord checkPointRecord) throws IOException {
        OLogManager.instance().infoNoDb(this, "Data restore procedure from FUZZY checkpoint is started.", new Object[0]);
        OLogSequenceNumber flushedLsn = checkPointRecord.getFlushedLsn();
        if (flushedLsn.compareTo(this.writeAheadLog.begin()) < 0) {
            OLogManager.instance().errorNoDb(this, "Fuzzy checkpoint points to removed part of the log, will try to restore data from the rest of the WAL", null, new Object[0]);
            flushedLsn = this.writeAheadLog.begin();
        }
        return this.restoreFrom(flushedLsn, this.writeAheadLog, true);
    }

    private OLogSequenceNumber restoreFromBeginning() throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure is started.", new Object[0]);
        OLogSequenceNumber lsn = this.writeAheadLog.begin();
        return this.restoreFrom(lsn, this.writeAheadLog, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final OLogSequenceNumber restoreFrom(OLogSequenceNumber lsn, OWriteAheadLog writeAheadLog, boolean wcRestoreMode) throws IOException {
        if (wcRestoreMode) {
            this.writeCache.restoreModeOn();
        }
        try {
            OLogSequenceNumber oLogSequenceNumber;
            OLogSequenceNumber logSequenceNumber = null;
            OModifiableBoolean atLeastOnePageUpdate = new OModifiableBoolean();
            long recordsProcessed = 0L;
            int reportBatchSize = OGlobalConfiguration.WAL_REPORT_AFTER_OPERATIONS_DURING_RESTORE.getValueAsInteger();
            HashMap operationUnits = new HashMap(1024);
            LinkedHashMap<Long, byte[]> operationMetadata = new LinkedHashMap<Long, byte[]>(1024);
            long lastReportTime = 0L;
            try {
                List<WriteableWALRecord> records = writeAheadLog.read(lsn, 1000);
                while (!records.isEmpty()) {
                    for (WriteableWALRecord walRecord : records) {
                        logSequenceNumber = walRecord.getLsn();
                        if (walRecord instanceof OAtomicUnitEndRecord) {
                            byte[] metadata;
                            OAtomicUnitEndRecord atomicUnitEndRecord = (OAtomicUnitEndRecord)walRecord;
                            List atomicUnit = (List)operationUnits.remove(atomicUnitEndRecord.getOperationUnitId());
                            if (atomicUnit != null) {
                                atomicUnit.add(walRecord);
                                this.restoreAtomicUnit(atomicUnit, atLeastOnePageUpdate);
                            }
                            if ((metadata = (byte[])operationMetadata.remove(atomicUnitEndRecord.getOperationUnitId())) != null) {
                                this.lastMetadata = metadata;
                            }
                        } else if (walRecord instanceof OAtomicUnitStartRecord) {
                            if (walRecord instanceof OAtomicUnitStartMetadataRecord) {
                                byte[] metadata = ((OAtomicUnitStartMetadataRecord)walRecord).getMetadata();
                                operationMetadata.put(((OAtomicUnitStartRecord)walRecord).getOperationUnitId(), metadata);
                            }
                            ArrayList<WriteableWALRecord> operationList = new ArrayList<WriteableWALRecord>(1024);
                            assert (!operationUnits.containsKey(((OAtomicUnitStartRecord)walRecord).getOperationUnitId()));
                            operationUnits.put(((OAtomicUnitStartRecord)walRecord).getOperationUnitId(), operationList);
                            operationList.add(walRecord);
                        } else if (walRecord instanceof OOperationUnitRecord) {
                            OOperationUnitRecord operationUnitRecord = (OOperationUnitRecord)walRecord;
                            ArrayList<OOperationUnitRecord> operationList = (ArrayList<OOperationUnitRecord>)operationUnits.get(operationUnitRecord.getOperationUnitId());
                            if (operationList == null || operationList.isEmpty()) {
                                OLogManager.instance().errorNoDb(this, "'Start transaction' record is absent for atomic operation", null, new Object[0]);
                                if (operationList == null) {
                                    operationList = new ArrayList<OOperationUnitRecord>(1024);
                                    operationUnits.put(operationUnitRecord.getOperationUnitId(), operationList);
                                }
                            }
                            operationList.add(operationUnitRecord);
                        } else if (walRecord instanceof ONonTxOperationPerformedWALRecord) {
                            if (!this.wereNonTxOperationsPerformedInPreviousOpen) {
                                OLogManager.instance().warnNoDb(this, "Non tx operation was used during data modification we will need index rebuild.", new Object[0]);
                                this.wereNonTxOperationsPerformedInPreviousOpen = true;
                            }
                        } else if (walRecord instanceof MetaDataRecord) {
                            MetaDataRecord metaDataRecord = (MetaDataRecord)walRecord;
                            this.lastMetadata = metaDataRecord.getMetadata();
                        } else {
                            OLogManager.instance().warnNoDb(this, "Record %s will be skipped during data restore", walRecord);
                        }
                        long currentTime = System.currentTimeMillis();
                        if ((reportBatchSize <= 0 || ++recordsProcessed % (long)reportBatchSize != 0L) && currentTime - lastReportTime <= 30000L) continue;
                        OLogManager.instance().infoNoDb(this, "%d operations were processed, current LSN is %s last LSN is %s", recordsProcessed, lsn, writeAheadLog.end());
                        lastReportTime = currentTime;
                    }
                    records = writeAheadLog.next(records.get(records.size() - 1).getLsn(), 1000);
                }
            }
            catch (OWALPageBrokenException e) {
                OLogManager.instance().errorNoDb(this, "Data restore was paused because broken WAL page was found. The rest of changes will be rolled back.", e, new Object[0]);
            }
            catch (RuntimeException e) {
                OLogManager.instance().errorNoDb(this, "Data restore was paused because of exception. The rest of changes will be rolled back.", e, new Object[0]);
            }
            if (atLeastOnePageUpdate.getValue()) {
                oLogSequenceNumber = logSequenceNumber;
                return oLogSequenceNumber;
            }
            oLogSequenceNumber = null;
            return oLogSequenceNumber;
        }
        finally {
            this.writeCache.restoreModeOff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void restoreAtomicUnit(List<OWALRecord> atomicUnit, OModifiableBoolean atLeastOnePageUpdate) throws IOException {
        assert (atomicUnit.get(atomicUnit.size() - 1) instanceof OAtomicUnitEndRecord);
        for (OWALRecord walRecord : atomicUnit) {
            if (walRecord instanceof OFileDeletedWALRecord) {
                OFileDeletedWALRecord fileDeletedWALRecord = (OFileDeletedWALRecord)walRecord;
                if (!this.writeCache.exists(fileDeletedWALRecord.getFileId())) continue;
                this.readCache.deleteFile(fileDeletedWALRecord.getFileId(), this.writeCache);
                continue;
            }
            if (walRecord instanceof OFileCreatedWALRecord) {
                OFileCreatedWALRecord fileCreatedCreatedWALRecord = (OFileCreatedWALRecord)walRecord;
                if (this.writeCache.exists(fileCreatedCreatedWALRecord.getFileName())) continue;
                this.readCache.addFile(fileCreatedCreatedWALRecord.getFileName(), fileCreatedCreatedWALRecord.getFileId(), this.writeCache);
                continue;
            }
            if (walRecord instanceof OUpdatePageRecord) {
                OUpdatePageRecord updatePageRecord = (OUpdatePageRecord)walRecord;
                long fileId = updatePageRecord.getFileId();
                if (!this.writeCache.exists(fileId)) {
                    String fileName = this.writeCache.restoreFileById(fileId);
                    if (fileName == null) {
                        throw new OStorageException("File with id " + fileId + " was deleted from storage, the rest of operations can not be restored");
                    }
                    OLogManager.instance().warn((Object)this, "Previously deleted file with name " + fileName + " was deleted but new empty file was added to continue restore process", new Object[0]);
                }
                long pageIndex = updatePageRecord.getPageIndex();
                OCacheEntry cacheEntry = this.readCache.loadForWrite(fileId = this.writeCache.externalFileId(this.writeCache.internalFileId(fileId)), pageIndex, true, this.writeCache, false, null);
                if (cacheEntry == null) {
                    do {
                        if (cacheEntry == null) continue;
                        this.readCache.releaseFromWrite(cacheEntry, this.writeCache, true);
                    } while ((long)(cacheEntry = this.readCache.allocateNewPage(fileId, this.writeCache, null)).getPageIndex() != pageIndex);
                }
                try {
                    ODurablePage durablePage = new ODurablePage(cacheEntry);
                    if (durablePage.getLsn().compareTo(walRecord.getLsn()) < 0) {
                        durablePage.restoreChanges(updatePageRecord.getChanges());
                        durablePage.setLsn(updatePageRecord.getLsn());
                    }
                }
                finally {
                    this.readCache.releaseFromWrite(cacheEntry, this.writeCache, true);
                }
                atLeastOnePageUpdate.setValue(true);
                continue;
            }
            if (walRecord instanceof OAtomicUnitStartRecord || walRecord instanceof OAtomicUnitEndRecord || walRecord instanceof OHighLevelTransactionChangeRecord) continue;
            OLogManager.instance().error(this, "Invalid WAL record type was passed %s. Given record will be skipped.", null, walRecord.getClass());
            assert (false) : "Invalid WAL record type was passed " + walRecord.getClass().getName();
        }
    }

    private void checkLowDiskSpaceRequestsAndReadOnlyConditions() {
        if (this.transaction.get() != null) {
            return;
        }
        if (this.lowDiskSpace != null && this.checkpointInProgress.compareAndSet(false, true)) {
            try {
                if (this.writeCache.checkLowDiskSpace()) {
                    OLogManager.instance().error(this, "Not enough disk space, force sync will be called", null, new Object[0]);
                    this.synch();
                    if (this.writeCache.checkLowDiskSpace()) {
                        throw new OLowDiskSpaceException("Error occurred while executing a write operation to database '" + this.name + "' due to limited free space on the disk (" + this.lowDiskSpace.freeSpace / 0x100000L + " MB). The database is now working in read-only mode. Please close the database (or stop OrientDB), make room on your hard drive and then reopen the database. The minimal required space is " + this.lowDiskSpace.requiredSpace / 0x100000L + " MB. Required space is now set to " + this.configuration.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT) + "MB (you can change it by setting parameter " + OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getKey() + ") .");
                    }
                    this.lowDiskSpace = null;
                } else {
                    this.lowDiskSpace = null;
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error during low disk space handling"), e);
            }
            finally {
                this.checkpointInProgress.set(false);
            }
        }
        this.checkReadOnlyConditions();
    }

    public final void checkReadOnlyConditions() {
        if (this.dataFlushException != null) {
            throw OException.wrapException(new OStorageException("Error in data flush background thread, please restart database and send full stack trace inside of bug report"), this.dataFlushException);
        }
        if (!this.brokenPages.isEmpty()) {
            HashMap<String, SortedSet> pagesByFile = new HashMap<String, SortedSet>(0);
            for (OPair<String, Long> brokenPage : this.brokenPages) {
                SortedSet sortedPages = pagesByFile.computeIfAbsent((String)brokenPage.key, fileName -> new TreeSet());
                sortedPages.add(brokenPage.value);
            }
            StringBuilder brokenPagesList = new StringBuilder();
            brokenPagesList.append("[");
            for (Map.Entry stringSortedSetEntry : pagesByFile.entrySet()) {
                brokenPagesList.append('\'').append((String)stringSortedSetEntry.getKey()).append("' :");
                SortedSet pageIndexes = (SortedSet)stringSortedSetEntry.getValue();
                long lastPage = (Long)pageIndexes.last();
                for (Long pageIndex : (SortedSet)stringSortedSetEntry.getValue()) {
                    brokenPagesList.append(pageIndex);
                    if (pageIndex == lastPage) continue;
                    brokenPagesList.append(", ");
                }
                brokenPagesList.append(";");
            }
            brokenPagesList.append("]");
            throw new OPageIsBrokenException("Following files and pages are detected to be broken " + brokenPagesList + ", storage is switched to 'read only' mode. Any modification operations are prohibited. To restore database and make it fully operational you may export and import database to and from JSON.");
        }
        if (this.jvmError.get() != null) {
            throw new OJVMErrorException("JVM error '" + this.jvmError.get().getClass().getSimpleName() + " : " + this.jvmError.get().getMessage() + "' occurred during data processing, storage is switched to 'read-only' mode. To prevent this exception please restart the JVM and check data consistency by calling of 'check database' command from database console.");
        }
    }

    public void setStorageConfigurationUpdateListener(OStorageConfigurationUpdateListener storageConfigurationUpdateListener) {
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            ((OClusterBasedStorageConfiguration)this.configuration).setConfigurationUpdateListener(storageConfigurationUpdateListener);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    public void pauseConfigurationUpdateNotifications() {
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            ((OClusterBasedStorageConfiguration)this.configuration).pauseUpdateNotifications();
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    public void fireConfigurationUpdateNotifications() {
        this.stateLock.acquireReadLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            ((OClusterBasedStorageConfiguration)this.configuration).fireUpdateNotifications();
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    protected static Map<Integer, List<ORecordId>> getRidsGroupedByCluster(Collection<ORecordId> rids) {
        HashMap<Integer, List<ORecordId>> ridsPerCluster = new HashMap<Integer, List<ORecordId>>(8);
        for (ORecordId rid : rids) {
            List group = ridsPerCluster.computeIfAbsent(rid.getClusterId(), k -> new ArrayList(rids.size()));
            group.add(rid);
        }
        return ridsPerCluster;
    }

    private static void lockIndexes(TreeMap<String, OTransactionIndexChanges> indexes) {
        for (OTransactionIndexChanges changes : indexes.values()) {
            assert (changes.changesPerKey instanceof TreeMap);
            OIndexInternal index = changes.getAssociatedIndex();
            ArrayList orderedIndexNames = new ArrayList(changes.changesPerKey.keySet());
            if (orderedIndexNames.size() > 1) {
                orderedIndexNames.sort((o1, o2) -> {
                    String i1 = index.getIndexNameByKey(o1);
                    String i2 = index.getIndexNameByKey(o2);
                    return i1.compareTo(i2);
                });
            }
            boolean fullyLocked = false;
            for (Object key : orderedIndexNames) {
                if (!index.acquireAtomicExclusiveLock(key)) continue;
                fullyLocked = true;
                break;
            }
            if (fullyLocked || changes.nullKeyChanges.entries.isEmpty()) continue;
            index.acquireAtomicExclusiveLock(null);
        }
    }

    private static void lockClusters(TreeMap<Integer, OCluster> clustersToLock) {
        for (OCluster cluster : clustersToLock.values()) {
            cluster.acquireAtomicExclusiveLock();
        }
    }

    private void lockRidBags(TreeMap<Integer, OCluster> clusters, TreeMap<String, OTransactionIndexChanges> indexes, OIndexManagerAbstract manager, ODatabaseDocumentInternal db) {
        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
        for (Integer n : clusters.keySet()) {
            this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(atomicOperation, OSBTreeCollectionManagerAbstract.generateLockName(n));
        }
        for (Map.Entry entry : indexes.entrySet()) {
            String indexName = (String)entry.getKey();
            OIndexInternal index = ((OTransactionIndexChanges)entry.getValue()).resolveAssociatedIndex(indexName, manager, db);
            if (index.isUnique()) continue;
            this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(atomicOperation, OIndexRIDContainerSBTree.generateLockName(indexName));
        }
    }

    private void registerProfilerHooks() {
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".createRecord", "Number of created records", OProfiler.METRIC_TYPE.COUNTER, new ModifiableLongProfileHookValue(this.recordCreated), "db.*.createRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".readRecord", "Number of read records", OProfiler.METRIC_TYPE.COUNTER, new ModifiableLongProfileHookValue(this.recordRead), "db.*.readRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".updateRecord", "Number of updated records", OProfiler.METRIC_TYPE.COUNTER, new ModifiableLongProfileHookValue(this.recordUpdated), "db.*.updateRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".deleteRecord", "Number of deleted records", OProfiler.METRIC_TYPE.COUNTER, new ModifiableLongProfileHookValue(this.recordDeleted), "db.*.deleteRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".scanRecord", "Number of read scanned", OProfiler.METRIC_TYPE.COUNTER, new ModifiableLongProfileHookValue(this.recordScanned), "db.*.scanRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".recyclePosition", "Number of recycled records", OProfiler.METRIC_TYPE.COUNTER, new ModifiableLongProfileHookValue(this.recordRecycled), "db.*.recyclePosition");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".conflictRecord", "Number of conflicts during updating and deleting records", OProfiler.METRIC_TYPE.COUNTER, new ModifiableLongProfileHookValue(this.recordConflict), "db.*.conflictRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".txBegun", "Number of transactions begun", OProfiler.METRIC_TYPE.COUNTER, new ModifiableLongProfileHookValue(this.txBegun), "db.*.txBegun");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".txCommit", "Number of committed transactions", OProfiler.METRIC_TYPE.COUNTER, new ModifiableLongProfileHookValue(this.txCommit), "db.*.txCommit");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".txRollback", "Number of rolled back transactions", OProfiler.METRIC_TYPE.COUNTER, new ModifiableLongProfileHookValue(this.txRollback), "db.*.txRollback");
    }

    protected final RuntimeException logAndPrepareForRethrow(RuntimeException runtimeException) {
        if (!(runtimeException instanceof OHighLevelException) && !(runtimeException instanceof ONeedRetryException)) {
            OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s`: %s", runtimeException, System.identityHashCode(runtimeException), this.getURL(), OConstants.getVersion());
        }
        return runtimeException;
    }

    protected final Error logAndPrepareForRethrow(Error error) {
        return this.logAndPrepareForRethrow(error, true);
    }

    private Error logAndPrepareForRethrow(Error error, boolean putInReadOnlyMode) {
        if (!(error instanceof OHighLevelException)) {
            OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s`: %s", error, System.identityHashCode(error), this.getURL(), OConstants.getVersion());
        }
        if (putInReadOnlyMode) {
            this.handleJVMError(error);
        }
        return error;
    }

    protected final RuntimeException logAndPrepareForRethrow(Throwable throwable) {
        if (!(throwable instanceof OHighLevelException) && !(throwable instanceof ONeedRetryException)) {
            OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s`: %s", throwable, System.identityHashCode(throwable), this.getURL(), OConstants.getVersion());
        }
        return new RuntimeException(throwable);
    }

    private OInvalidIndexEngineIdException logAndPrepareForRethrow(OInvalidIndexEngineIdException exception) {
        OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s` : %s", exception, System.identityHashCode(exception), this.getURL(), OConstants.getVersion());
        return exception;
    }

    @Override
    public final OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public final void setSchemaRecordId(String schemaRecordId) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setSchemaRecordId(atomicOperation, schemaRecordId));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setDateFormat(String dateFormat) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setDateFormat(atomicOperation, dateFormat));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setTimeZone(TimeZone timeZoneValue) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setTimeZone(atomicOperation, timeZoneValue));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setLocaleLanguage(String locale) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setLocaleLanguage(atomicOperation, locale));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setCharset(String charset) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setCharset(atomicOperation, charset));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setIndexMgrRecordId(String indexMgrRecordId) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setIndexMgrRecordId(atomicOperation, indexMgrRecordId));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setDateTimeFormat(String dateTimeFormat) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setDateTimeFormat(atomicOperation, dateTimeFormat));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setLocaleCountry(String localeCountry) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setLocaleCountry(atomicOperation, localeCountry));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setClusterSelection(String clusterSelection) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setClusterSelection(atomicOperation, clusterSelection));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setMinimumClusters(int minimumClusters) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            storageConfiguration.setMinimumClusters(minimumClusters);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setValidation(boolean validation) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setValidation(atomicOperation, validation));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void removeProperty(String property) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.removeProperty(atomicOperation, property));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setProperty(String property, String value) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> storageConfiguration.setProperty(atomicOperation, property, value));
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void setRecordSerializer(String recordSerializer, int version) {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, atomicOperation -> {
                storageConfiguration.setRecordSerializer(atomicOperation, recordSerializer);
                storageConfiguration.setRecordSerializerVersion(atomicOperation, version);
            });
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public final void clearProperties() {
        this.checkOpenness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpenness();
            this.checkIfThreadIsBlocked();
            OClusterBasedStorageConfiguration storageConfiguration = (OClusterBasedStorageConfiguration)this.configuration;
            this.atomicOperationsManager.executeInsideAtomicOperation(null, storageConfiguration::clearProperties);
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    public Optional<byte[]> getLastMetadata() {
        return Optional.ofNullable(this.lastMetadata);
    }

    public void incOnOpen() {
        this.sessionCount.incrementAndGet();
    }

    private void decOnClose() {
        this.lastCloseTime.set(System.currentTimeMillis());
        this.sessionCount.decrementAndGet();
    }

    public int getSessionCount() {
        return this.sessionCount.get();
    }

    public long getLastCloseTime() {
        return this.lastCloseTime.get();
    }

    static {
        fuzzyCheckpointExecutor.setMaximumPoolSize(1);
    }

    protected static final class StartupMetadata {
        private final long lastTxId;
        private final byte[] txMetadata;

        public StartupMetadata(long lastTxId, byte[] txMetadata) {
            this.lastTxId = lastTxId;
            this.txMetadata = txMetadata;
        }
    }

    private final class WALVacuum
    implements Runnable {
        private WALVacuum() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OAbstractPaginatedStorage.this.stateLock.acquireReadLock();
            try {
                OLogSequenceNumber endLSN;
                Long minLSNSegment;
                long minDirtySegment;
                if (OAbstractPaginatedStorage.this.status == OStorage.STATUS.CLOSED) {
                    return;
                }
                long[] nonActiveSegments = OAbstractPaginatedStorage.this.writeAheadLog.nonActiveSegments();
                if (nonActiveSegments.length == 0) {
                    return;
                }
                long flushTillSegmentId = nonActiveSegments.length == 1 ? OAbstractPaginatedStorage.this.writeAheadLog.activeSegment() : (nonActiveSegments[0] + nonActiveSegments[nonActiveSegments.length - 1]) / 2L;
                do {
                    OAbstractPaginatedStorage.this.writeCache.flushTillSegment(flushTillSegmentId);
                    endLSN = OAbstractPaginatedStorage.this.writeAheadLog.end();
                } while ((minDirtySegment = (minLSNSegment = OAbstractPaginatedStorage.this.writeCache.getMinimalNotFlushedSegment()) == null ? endLSN.getSegment() : minLSNSegment.longValue()) < flushTillSegmentId);
                OAbstractPaginatedStorage.this.atomicOperationsTable.compactTable();
                long operationSegment = OAbstractPaginatedStorage.this.atomicOperationsTable.getSegmentEarliestNotPersistedOperation();
                if (operationSegment >= 0L && minDirtySegment > operationSegment) {
                    minDirtySegment = operationSegment;
                }
                if (minDirtySegment <= nonActiveSegments[0]) {
                    return;
                }
                OAbstractPaginatedStorage.this.writeCache.makeFuzzyCheckpoint(minDirtySegment, OAbstractPaginatedStorage.this.lastMetadata);
            }
            catch (Exception e) {
                OAbstractPaginatedStorage.this.dataFlushException = e;
                OLogManager.instance().error(this, "Error during flushing of data for fuzzy checkpoint", e, new Object[0]);
            }
            finally {
                OAbstractPaginatedStorage.this.stateLock.releaseReadLock();
                OAbstractPaginatedStorage.this.walVacuumInProgress.set(false);
            }
        }
    }

    private static final class FuzzyCheckpointThreadFactory
    implements ThreadFactory {
        private FuzzyCheckpointThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return thread;
        }
    }
}

