/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.core.tx.OTransactionData;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class OBackgroundNewDelta
implements Runnable,
OSyncSource {
    private List<OTransactionData> transactions;
    private PipedOutputStream outputStream;
    private InputStream inputStream;
    private CountDownLatch finished = new CountDownLatch(1);

    public OBackgroundNewDelta(List<OTransactionData> transactions) throws IOException {
        this.transactions = transactions;
        this.outputStream = new PipedOutputStream();
        this.inputStream = new PipedInputStream(this.outputStream);
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DataOutputStream output = new DataOutputStream(this.outputStream);
            for (OTransactionData transaction : this.transactions) {
                output.writeBoolean(true);
                transaction.write(output);
            }
            output.writeBoolean(false);
            this.outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.finished.countDown();
        }
    }

    @Override
    public boolean getIncremental() {
        return false;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public CountDownLatch getFinished() {
        return this.finished;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public void invalidate() {
    }
}

