/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionDataChange;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.tx.OTransactionRecordIndexOperation;
import com.orientechnologies.orient.core.tx.OTxMetadataHolder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class OMicroTransaction
implements OBasicTransaction,
OTransactionInternal {
    private static final AtomicInteger transactionSerial = new AtomicInteger(0);
    private ODatabaseDocumentInternal database;
    private final OAbstractPaginatedStorage storage;
    private final int id;
    private final Map<ORID, ORecordOperation> recordOperations = new LinkedHashMap<ORID, ORecordOperation>();
    private final Map<String, OTransactionIndexChanges> indexOperations = new LinkedHashMap<String, OTransactionIndexChanges>();
    private final Map<ORID, List<OTransactionRecordIndexOperation>> recordIndexOperations = new HashMap<ORID, List<OTransactionRecordIndexOperation>>();
    private final Map<ORID, ORID> updatedRids = new HashMap<ORID, ORID>();
    private final Set<ODocument> changedDocuments = new HashSet<ODocument>();
    private final Map<String, Object> customData = new HashMap<String, Object>();
    private boolean active = false;
    private int level = 0;
    private int recordSerial = -2;
    private Map<ORID, OTransactionAbstract.LockedRecordMetadata> noTxLocks;
    private Optional<OTxMetadataHolder> metadata = Optional.empty();
    private Optional<List<byte[]>> serializedOperations = Optional.empty();

    public OMicroTransaction(OAbstractPaginatedStorage storage, ODatabaseDocumentInternal database) {
        this.storage = storage;
        this.database = database;
        this.id = transactionSerial.incrementAndGet();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getClientTransactionId() {
        return -1;
    }

    @Override
    public void updateIdentityAfterCommit(ORID oldRID, ORID rid) {
        this.updateIdentityAfterRecordCommit(oldRID, rid);
    }

    @Override
    public ODatabaseDocumentInternal getDatabase() {
        return this.database;
    }

    @Override
    public Collection<ORecordOperation> getRecordOperations() {
        return this.recordOperations.values();
    }

    @Override
    public Map<String, OTransactionIndexChanges> getIndexOperations() {
        return this.indexOperations;
    }

    public void begin() {
        if (this.level < 0) {
            throw this.error("Unbalanced micro-transaction, level = " + this.level);
        }
        ++this.level;
        this.active = true;
    }

    public void commit() {
        if (!this.active) {
            throw this.error("Inactive micro-transaction on commit");
        }
        if (this.level < 1) {
            throw this.error("Unbalanced micro-transaction, level = " + this.level);
        }
        --this.level;
        if (this.level == 0) {
            this.active = false;
            this.doCommit();
        }
    }

    public void rollback() {
        if (!this.active) {
            throw this.error("Inactive micro-transaction on rollback");
        }
        if (this.level < 1) {
            throw this.error("Unbalanced micro-transaction, level = " + this.level);
        }
        --this.level;
        if (this.level == 0) {
            this.active = false;
            this.doRollback();
        }
    }

    public void rollbackAfterFailedCommit() {
        if (this.active) {
            throw this.error("Active micro-transaction on rollback after failed commit");
        }
        if (this.level != 0) {
            throw this.error("Unbalanced micro-transaction, level = " + this.level);
        }
        this.doRollback();
    }

    public void updateIdentityAfterRecordCommit(ORID oldRid, ORID newRid) {
        if (oldRid.equals(newRid)) {
            return;
        }
        ArrayList<KeyChangesUpdateRecord> keyRecordsToReinsert = new ArrayList<KeyChangesUpdateRecord>();
        ODatabaseDocumentInternal database = this.getDatabase();
        OIndexManagerAbstract indexManager = database.getMetadata().getIndexManagerInternal();
        for (Map.Entry<String, OTransactionIndexChanges> entry : this.indexOperations.entrySet()) {
            OIndex index = indexManager.getIndex(database, entry.getKey());
            if (index == null) {
                throw new OTransactionException("Cannot find index '" + entry.getValue() + "' while committing transaction");
            }
            Dependency[] fieldRidDependencies = OMicroTransaction.getIndexFieldRidDependencies(index);
            if (!OMicroTransaction.isIndexMayDependOnRids(fieldRidDependencies)) continue;
            OTransactionIndexChanges indexChanges = entry.getValue();
            Iterator iterator = indexChanges.changesPerKey.values().iterator();
            while (iterator.hasNext()) {
                OTransactionIndexChangesPerKey keyChanges = (OTransactionIndexChangesPerKey)iterator.next();
                if (!OMicroTransaction.isIndexKeyMayDependOnRid(keyChanges.key, oldRid, fieldRidDependencies)) continue;
                keyRecordsToReinsert.add(new KeyChangesUpdateRecord(keyChanges, indexChanges));
                iterator.remove();
            }
        }
        ORecordOperation rec = this.resolveRecordOperation(oldRid);
        if (rec != null) {
            this.updatedRids.put(newRid.copy(), oldRid.copy());
            if (!rec.getRecord().getIdentity().equals(newRid)) {
                ORecordInternal.onBeforeIdentityChanged(rec.getRecord());
                ORecordId recordId = (ORecordId)rec.getRecord().getIdentity();
                if (recordId == null) {
                    ORecordInternal.setIdentity(rec.getRecord(), new ORecordId(newRid));
                } else {
                    recordId.setClusterPosition(newRid.getClusterPosition());
                    recordId.setClusterId(newRid.getClusterId());
                }
                ORecordInternal.onAfterIdentityChanged(rec.getRecord());
            }
        }
        for (KeyChangesUpdateRecord record : keyRecordsToReinsert) {
            ((KeyChangesUpdateRecord)record).indexChanges.changesPerKey.put(((KeyChangesUpdateRecord)record).keyChanges.key, record.keyChanges);
        }
        List<OTransactionRecordIndexOperation> transactionIndexOperations = this.recordIndexOperations.get(this.translateRid(oldRid));
        if (transactionIndexOperations != null) {
            for (OTransactionRecordIndexOperation indexOperation : transactionIndexOperations) {
                OTransactionIndexChangesPerKey keyChanges;
                OTransactionIndexChanges indexEntryChanges = this.indexOperations.get(indexOperation.index);
                if (indexEntryChanges == null || (keyChanges = indexOperation.key == null ? indexEntryChanges.nullKeyChanges : (OTransactionIndexChangesPerKey)indexEntryChanges.changesPerKey.get(indexOperation.key)) == null) continue;
                this.updateChangesIdentity(oldRid, newRid, keyChanges);
            }
        }
    }

    public void updateRecordCacheAfterRollback() {
        OLocalRecordCache databaseLocalCache = this.database.getLocalCache();
        for (ORecordOperation recordOperation : this.recordOperations.values()) {
            databaseLocalCache.deleteRecord(recordOperation.getRecord().getIdentity());
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ORecord saveRecord(ORecord record, String clusterName, ODatabase.OPERATION_MODE operationMode, boolean forceCreation, ORecordCallback<? extends Number> createdCallback, ORecordCallback<Integer> updatedCallback) {
        if (!this.active) {
            throw this.error("Inactive micro-transaction on record save");
        }
        if (record == null) {
            return null;
        }
        if (!record.isDirty()) {
            return record;
        }
        ORecordOperation recordOperation = forceCreation || !record.getIdentity().isValid() ? this.addRecordOperation(record, (byte)3, clusterName) : this.addRecordOperation(record, (byte)1, clusterName);
        if (recordOperation != null) {
            if (createdCallback != null) {
                recordOperation.createdCallback = createdCallback;
            }
            if (updatedCallback != null) {
                recordOperation.updatedCallback = updatedCallback;
            }
        }
        return record;
    }

    @Override
    public void deleteRecord(ORecord record, ODatabase.OPERATION_MODE mode) {
        if (!record.getIdentity().isValid()) {
            return;
        }
        this.addRecordOperation(record, (byte)2, null);
    }

    @Override
    public ORecord getRecord(ORID rid) {
        ORecordOperation recordOperation = this.resolveRecordOperation(rid);
        if (recordOperation == null) {
            return null;
        }
        return recordOperation.type == 2 ? DELETED_RECORD : recordOperation.record.getRecord();
    }

    @Override
    public OTransactionIndexChanges getIndexChanges(String indexName) {
        return this.indexOperations.get(indexName);
    }

    @Override
    public OTransactionIndexChanges getIndexChangesInternal(String indexName) {
        return this.getIndexChanges(indexName);
    }

    @Override
    public Object getCustomData(String name) {
        return this.customData.get(name);
    }

    @Override
    public void setCustomData(String name, Object value) {
        this.customData.put(name, value);
    }

    private OStorageException error(String message) {
        return new OStorageException(message);
    }

    private void doCommit() {
        if (!this.recordOperations.isEmpty() || !this.indexOperations.isEmpty()) {
            this.getDatabase().internalCommit(this);
        }
        this.invokeCallbacks();
        this.reset();
    }

    private void doRollback() {
        this.storage.rollback(this);
        this.database.getLocalCache().clear();
        for (ORecordOperation recordOperation : this.recordOperations.values()) {
            Object record = recordOperation.record.getRecord();
            if (record.isDirty() && record instanceof ODocument) {
                ODocument document = (ODocument)record;
                if (document.isTrackingChanges()) {
                    document.undo();
                    continue;
                }
                document.unload();
                continue;
            }
            record.unload();
        }
        this.reset();
    }

    private void invokeCallbacks() {
        for (ORecordOperation recordOperation : this.recordOperations.values()) {
            ORecord record = recordOperation.getRecord();
            ORID identity = record.getIdentity();
            if (recordOperation.type == 3 && recordOperation.createdCallback != null) {
                recordOperation.createdCallback.call(new ORecordId(identity), identity.getClusterPosition());
                continue;
            }
            if (recordOperation.type != 1 || recordOperation.updatedCallback == null) continue;
            recordOperation.updatedCallback.call(new ORecordId(identity), record.getVersion());
        }
    }

    private void reset() {
        for (ORecordOperation recordOperation : this.recordOperations.values()) {
            Object record = recordOperation.record.getRecord();
            if (!(record instanceof ODocument)) continue;
            ODocument document = (ODocument)record;
            if (document.isDirty()) {
                document.undo();
            }
            this.changedDocuments.remove(document);
        }
        for (ODocument changedDocument : this.changedDocuments) {
            changedDocument.undo();
        }
        this.changedDocuments.clear();
        this.updatedRids.clear();
        this.recordOperations.clear();
        this.indexOperations.clear();
        this.recordIndexOperations.clear();
        this.recordSerial = -2;
        this.customData.clear();
    }

    private ORecordOperation resolveRecordOperation(ORID rid) {
        return this.recordOperations.get(this.translateRid(rid));
    }

    private ORID translateRid(ORID rid) {
        ORID translatedRid;
        while ((translatedRid = this.updatedRids.get(rid)) != null) {
            rid = translatedRid;
        }
        return rid;
    }

    private ORecordOperation addRecordOperation(ORecord record, byte type, String clusterName) {
        if (clusterName == null) {
            clusterName = this.database.getClusterNameById(record.getIdentity().getClusterId());
        }
        this.changedDocuments.remove(record);
        try {
            switch (type) {
                case 3: {
                    OIdentifiable newRec = this.database.beforeCreateOperations(record, clusterName);
                    if (newRec == null) break;
                    record = (ORecord)newRec;
                    this.reSave(record);
                    break;
                }
                case 1: {
                    OIdentifiable newRec = this.database.beforeUpdateOperations(record, clusterName);
                    if (newRec == null) break;
                    record = (ORecord)newRec;
                    this.reSave(record);
                    break;
                }
                case 2: {
                    this.database.beforeDeleteOperations(record, clusterName);
                }
            }
            try {
                ORecordOperation recordOperation = this.internalAddRecord(record, type, clusterName);
                switch (type) {
                    case 3: {
                        this.database.afterCreateOperations(record);
                        break;
                    }
                    case 1: {
                        this.database.afterUpdateOperations(record);
                        break;
                    }
                    case 2: {
                        this.database.afterDeleteOperations(record);
                    }
                }
                if (record instanceof ODocument && ((ODocument)record).isTrackingChanges()) {
                    ODocumentInternal.clearTrackData((ODocument)record);
                }
                ORecordOperation oRecordOperation = recordOperation;
                return oRecordOperation;
            }
            catch (Exception e) {
                switch (type) {
                    case 3: {
                        this.database.callbackHooks(ORecordHook.TYPE.CREATE_FAILED, record);
                        break;
                    }
                    case 1: {
                        this.database.callbackHooks(ORecordHook.TYPE.UPDATE_FAILED, record);
                        break;
                    }
                    case 2: {
                        this.database.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, record);
                    }
                }
                throw OException.wrapException(new ODatabaseException("Error on saving record " + record.getIdentity()), e);
            }
        }
        finally {
            switch (type) {
                case 3: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_CREATION, record);
                    break;
                }
                case 1: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_UPDATE, record);
                    break;
                }
                case 2: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_DELETION, record);
                }
            }
        }
    }

    public ORecordOperation internalAddRecord(ORecord record, byte type, String clusterName) {
        ORecordOperation recordOperation;
        ORecordId recordId = (ORecordId)record.getIdentity();
        if (!recordId.isValid()) {
            ORecordInternal.onBeforeIdentityChanged(record);
            this.database.assignAndCheckCluster(record, clusterName);
            recordId.setClusterPosition(this.recordSerial--);
            ORecordInternal.onAfterIdentityChanged(record);
        }
        if ((recordOperation = this.resolveRecordOperation(recordId)) == null) {
            if (!recordId.isTemporary() || type == 3) {
                recordOperation = new ORecordOperation(record, type);
                this.recordOperations.put(recordId.copy(), recordOperation);
            }
        } else {
            recordOperation.record = record;
            switch (recordOperation.type) {
                case 3: {
                    if (type != 2) break;
                    this.recordOperations.remove(recordId);
                    break;
                }
                case 1: {
                    if (type != 2) break;
                    recordOperation.type = (byte)2;
                    break;
                }
            }
        }
        return recordOperation;
    }

    @Override
    public void addIndexEntry(OIndex index, String indexName, OTransactionIndexChanges.OPERATION type, Object key, OIdentifiable value) {
        OTransactionIndexChanges indexOperation = this.indexOperations.computeIfAbsent(indexName, k -> new OTransactionIndexChanges());
        if (type == OTransactionIndexChanges.OPERATION.CLEAR) {
            indexOperation.setCleared();
        } else {
            OTransactionIndexChangesPerKey changesPerKey = indexOperation.getChangesPerKey(key);
            changesPerKey.clientTrackOnly = false;
            changesPerKey.add(value, type);
            if (value == null) {
                return;
            }
            List<OTransactionRecordIndexOperation> transactionIndexOperations = this.recordIndexOperations.get(value.getIdentity());
            if (transactionIndexOperations == null) {
                transactionIndexOperations = new ArrayList<OTransactionRecordIndexOperation>();
                this.recordIndexOperations.put(value.getIdentity().copy(), transactionIndexOperations);
            }
            transactionIndexOperations.add(new OTransactionRecordIndexOperation(indexName, key, type));
        }
    }

    @Override
    public void addChangedDocument(ODocument document) {
        if (this.getRecord(document.getIdentity()) == null) {
            this.changedDocuments.add(document);
        }
    }

    private void reSave(ORecord record) {
        ODirtyManager manager = ORecordInternal.getDirtyManager(record);
        Set<ORecord> newRecords = manager.getNewRecords();
        Set<ORecord> updatedRecords = manager.getUpdateRecords();
        manager.clearForSave();
        if (newRecords != null) {
            for (ORecord newRecord : newRecords) {
                if (newRecord == record) continue;
                this.saveRecord(newRecord, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
            }
        }
        if (updatedRecords != null) {
            for (ORecord updatedRecord : updatedRecords) {
                if (updatedRecord == record) continue;
                this.saveRecord(updatedRecord, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
            }
        }
    }

    private void updateChangesIdentity(ORID oldRid, ORID newRid, OTransactionIndexChangesPerKey changesPerKey) {
        if (changesPerKey == null) {
            return;
        }
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry indexEntry : changesPerKey.entries) {
            if (!indexEntry.value.getIdentity().equals(oldRid)) continue;
            indexEntry.value = newRid;
        }
    }

    private static Dependency[] getIndexFieldRidDependencies(OIndex index) {
        OIndexDefinition definition = index.getDefinition();
        if (definition == null) {
            return null;
        }
        OType[] types = definition.getTypes();
        Dependency[] dependencies = new Dependency[types.length];
        for (int i = 0; i < types.length; ++i) {
            dependencies[i] = OMicroTransaction.getTypeRidDependency(types[i]);
        }
        return dependencies;
    }

    private static Dependency getTypeRidDependency(OType type) {
        switch (type) {
            case CUSTOM: 
            case ANY: {
                return Dependency.Unknown;
            }
            case EMBEDDED: 
            case LINK: {
                return Dependency.Yes;
            }
            case LINKLIST: 
            case LINKSET: 
            case LINKMAP: 
            case LINKBAG: 
            case EMBEDDEDLIST: 
            case EMBEDDEDSET: 
            case EMBEDDEDMAP: {
                assert (false);
                return Dependency.Unknown;
            }
        }
        return Dependency.No;
    }

    private static boolean isIndexMayDependOnRids(Dependency[] fieldDependencies) {
        if (fieldDependencies == null) {
            return true;
        }
        for (Dependency dependency : fieldDependencies) {
            switch (dependency) {
                case Unknown: {
                    return true;
                }
                case Yes: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isIndexKeyMayDependOnRid(Object key, ORID rid, Dependency[] keyDependencies) {
        if (key instanceof OCompositeKey) {
            List<Object> subKeys = ((OCompositeKey)key).getKeys();
            for (int i = 0; i < subKeys.size(); ++i) {
                if (!OMicroTransaction.isIndexKeyMayDependOnRid(subKeys.get(i), rid, keyDependencies == null ? null : keyDependencies[i])) continue;
                return true;
            }
            return false;
        }
        return OMicroTransaction.isIndexKeyMayDependOnRid(key, rid, keyDependencies == null ? null : keyDependencies[0]);
    }

    private static boolean isIndexKeyMayDependOnRid(Object key, ORID rid, Dependency dependency) {
        if (dependency == Dependency.No) {
            return false;
        }
        if (key instanceof OIdentifiable) {
            return key.equals(rid);
        }
        return dependency == Dependency.Unknown || dependency == null;
    }

    @Override
    public void setStatus(OTransaction.TXSTATUS iStatus) {
    }

    @Override
    public boolean isUsingLog() {
        return true;
    }

    @Override
    public ORecordOperation getRecordEntry(ORID currentRid) {
        return this.recordOperations.get(currentRid);
    }

    public void setNoTxLocks(Map<ORID, OTransactionAbstract.LockedRecordMetadata> noTxLocks) {
        this.noTxLocks = noTxLocks;
    }

    @Override
    public Set<ORID> getLockedRecords() {
        if (this.noTxLocks != null) {
            return this.noTxLocks.keySet();
        }
        return null;
    }

    @Override
    public void setDatabase(ODatabaseDocumentInternal database) {
        this.database = database;
    }

    @Override
    public Optional<byte[]> getMetadata() {
        return this.metadata.map(h -> h.metadata());
    }

    @Override
    public void storageBegun() {
        if (this.metadata.isPresent()) {
            this.metadata.get().notifyMetadataRead();
        }
    }

    @Override
    public void setMetadataHolder(Optional<OTxMetadataHolder> metadata) {
        this.metadata = metadata;
    }

    @Override
    public void prepareSerializedOperations() throws IOException {
        ArrayList<byte[]> operations = new ArrayList<byte[]>();
        for (ORecordOperation value : this.recordOperations.values()) {
            OTransactionDataChange change = new OTransactionDataChange(value);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            change.serialize(new DataOutputStream(out));
            operations.add(out.toByteArray());
        }
        this.serializedOperations = Optional.of(operations);
    }

    @Override
    public Iterator<byte[]> getSerializedOperations() {
        if (this.serializedOperations.isPresent()) {
            return this.serializedOperations.get().iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public void resetAllocatedIds() {
        for (Map.Entry<ORID, ORecordOperation> op : this.recordOperations.entrySet()) {
            if (op.getValue().type != 3) continue;
            ORecordId oldNew = new ORecordId(op.getKey().getClusterId(), op.getKey().getClusterPosition());
            this.updatedRids.remove(op.getValue().getRID());
            this.updateIdentityAfterRecordCommit(op.getValue().getRID(), oldNew);
        }
    }

    private static class KeyChangesUpdateRecord {
        private final OTransactionIndexChangesPerKey keyChanges;
        private final OTransactionIndexChanges indexChanges;

        public KeyChangesUpdateRecord(OTransactionIndexChangesPerKey keyChanges, OTransactionIndexChanges indexChanges) {
            this.keyChanges = keyChanges;
            this.indexChanges = indexChanges;
        }
    }

    private static enum Dependency {
        Unknown,
        Yes,
        No;

    }
}

