/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;

public class ORidBagUpdateSerializationOperation
implements ORecordSerializationOperation {
    private final NavigableMap<OIdentifiable, Change> changedValues;
    private final OBonsaiCollectionPointer collectionPointer;
    private final OSBTreeCollectionManager collectionManager;

    public ORidBagUpdateSerializationOperation(NavigableMap<OIdentifiable, Change> changedValues, OBonsaiCollectionPointer collectionPointer) {
        this.changedValues = changedValues;
        this.collectionPointer = collectionPointer;
        this.collectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
    }

    @Override
    public void execute(OAtomicOperation atomicOperation, OAbstractPaginatedStorage paginatedStorage) {
        if (this.changedValues.isEmpty()) {
            return;
        }
        OSBTreeBonsai<OIdentifiable, Integer> tree = this.loadTree();
        try {
            for (Map.Entry entry : this.changedValues.entrySet()) {
                Integer storedCounter = tree.get((OIdentifiable)entry.getKey());
                storedCounter = ((Change)entry.getValue()).applyTo(storedCounter);
                if (storedCounter <= 0) {
                    tree.remove(atomicOperation, (OIdentifiable)entry.getKey());
                    continue;
                }
                tree.put(atomicOperation, (OIdentifiable)entry.getKey(), storedCounter);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Error during ridbag update"), e);
        }
        finally {
            this.releaseTree();
        }
        this.changedValues.clear();
    }

    private OSBTreeBonsai<OIdentifiable, Integer> loadTree() {
        return this.collectionManager.loadSBTree(this.collectionPointer);
    }

    private void releaseTree() {
        this.collectionManager.releaseSBTree(this.collectionPointer);
    }
}

