/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;

public class StorageStartupMetadata {
    private static final long XX_HASH_SEED = 747164466757L;
    private static final XXHash64 XX_HASH_64;
    private static final int XX_HASH_OFFSET = 0;
    private static final int VERSION_OFFSET = 8;
    private static final int DIRTY_FLAG_OFFSET = 12;
    private static final int TRANSACTION_ID_OFFSET = 13;
    private static final int METADATA_LEN_OFFSET = 21;
    private static final int VERSION = 3;
    private final Path filePath;
    private final Path backupPath;
    private FileChannel channel;
    private FileLock fileLock;
    private volatile boolean dirtyFlag;
    private volatile long lastTxId;
    private volatile byte[] txMetadata;
    private final Lock lock = new ReentrantLock();

    public StorageStartupMetadata(Path filePath, Path backupPath) {
        this.filePath = filePath;
        this.backupPath = backupPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToArchive(ZipOutputStream zos, String name) throws IOException {
        ZipEntry ze = new ZipEntry(name);
        zos.putNextEntry(ze);
        try {
            ByteBuffer byteBuffer = this.serialize();
            byteBuffer.put(12, (byte)0);
            zos.write(byteBuffer.array());
        }
        finally {
            zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws IOException {
        this.lock.lock();
        try {
            if (Files.exists(this.filePath, new LinkOption[0])) {
                Files.delete(this.filePath);
            }
            this.channel = FileChannel.open(this.filePath, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
            if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                this.lockFile();
            }
            ByteBuffer buffer = ByteBuffer.allocate(25);
            buffer.position(8);
            buffer.putInt(3);
            buffer.put((byte)1);
            buffer.putLong(-1L);
            buffer.putInt(-1);
            long xxHash = XX_HASH_64.hash(buffer, 8, buffer.capacity() - 8, 747164466757L);
            buffer.putLong(0, xxHash);
            buffer.rewind();
            this.update(buffer);
            this.dirtyFlag = true;
            this.lastTxId = -1L;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void update(ByteBuffer buffer) throws IOException {
        Files.deleteIfExists(this.backupPath);
        try (FileChannel backupChannel = FileChannel.open(this.backupPath, StandardOpenOption.READ, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.SYNC);){
            OIOUtils.writeByteBuffer(buffer, backupChannel, 0L);
        }
        this.channel.truncate(0L);
        OIOUtils.writeByteBuffer(buffer, this.channel, 0L);
        Files.deleteIfExists(this.backupPath);
    }

    private void lockFile() throws IOException {
        try {
            this.fileLock = this.channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            OLogManager.instance().warn((Object)this, "File is already locked by other thread", e, new Object[0]);
        }
        if (this.fileLock == null) {
            throw new OStorageException("Database is locked by another process, please shutdown process and try again");
        }
    }

    public boolean exists() {
        this.lock.lock();
        try {
            boolean bl = Files.exists(this.filePath, new LinkOption[0]);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this.lock.lock();
        try {
            block17: {
                ByteBuffer buffer;
                while (true) {
                    if (!Files.exists(this.filePath, new LinkOption[0])) {
                        if (Files.exists(this.backupPath, new LinkOption[0])) {
                            try {
                                Files.move(this.backupPath, this.filePath, StandardCopyOption.ATOMIC_MOVE);
                            }
                            catch (AtomicMoveNotSupportedException e) {
                                Files.move(this.backupPath, this.filePath, new CopyOption[0]);
                            }
                        } else {
                            OLogManager.instance().infoNoDb(this, "File with startup metadata does not exist, creating new one", new Object[0]);
                            this.create();
                            return;
                        }
                    }
                    this.channel = FileChannel.open(this.filePath, StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
                    long size = this.channel.size();
                    if (size < 9L) {
                        buffer = ByteBuffer.allocate(1);
                        OIOUtils.readByteBuffer(buffer, this.channel, 0L, true);
                        buffer.position(0);
                        this.dirtyFlag = buffer.get() > 0;
                        break block17;
                    }
                    if (size == 9L) {
                        buffer = ByteBuffer.allocate(9);
                        OIOUtils.readByteBuffer(buffer, this.channel, 0L, true);
                        buffer.position(0);
                        this.dirtyFlag = buffer.get() > 0;
                        this.lastTxId = buffer.getLong();
                        break block17;
                    }
                    buffer = ByteBuffer.allocate((int)size);
                    OIOUtils.readByteBuffer(buffer, this.channel);
                    buffer.rewind();
                    long xxHash = XX_HASH_64.hash(buffer, 8, buffer.capacity() - 8, 747164466757L);
                    if (xxHash == buffer.getLong(0)) break;
                    if (!Files.exists(this.backupPath, new LinkOption[0])) {
                        OLogManager.instance().error(this, "File with startup metadata is broken and can not be used, creation of new one", null, new Object[0]);
                        this.channel.close();
                        this.create();
                        return;
                    }
                    OLogManager.instance().error(this, "File with startup metadata is broken and can not be used, will try to use backup version", null, new Object[0]);
                    this.channel.close();
                    Files.deleteIfExists(this.filePath);
                }
                buffer.position(8);
                int version = buffer.getInt();
                if (version != 3) {
                    throw new IllegalStateException("Invalid version of the binary format of startup metadata file found " + version + " but expected " + 3);
                }
                this.dirtyFlag = buffer.get() > 0;
                this.lastTxId = buffer.getLong();
                int metadataLen = buffer.getInt();
                if (metadataLen > 0) {
                    byte[] txMeta = new byte[metadataLen];
                    buffer.get(txMeta);
                    this.txMetadata = txMeta;
                }
            }
            if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                this.lockFile();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws IOException {
        this.lock.lock();
        try {
            if (this.channel == null) {
                return;
            }
            if (Files.exists(this.filePath, new LinkOption[0])) {
                if (this.fileLock != null) {
                    this.fileLock.release();
                    this.fileLock = null;
                }
                this.channel.close();
                this.channel = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void delete() throws IOException {
        this.lock.lock();
        try {
            if (this.channel == null) {
                return;
            }
            if (Files.exists(this.filePath, new LinkOption[0])) {
                if (this.fileLock != null) {
                    this.fileLock.release();
                    this.fileLock = null;
                }
                this.channel.close();
                this.channel = null;
                Files.delete(this.filePath);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void makeDirty() throws IOException {
        if (this.dirtyFlag) {
            return;
        }
        this.lock.lock();
        try {
            if (this.dirtyFlag) {
                return;
            }
            this.dirtyFlag = true;
            this.update(this.serialize());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearDirty() throws IOException {
        if (!this.dirtyFlag) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.dirtyFlag) {
                return;
            }
            this.dirtyFlag = false;
            this.update(this.serialize());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLastTxId(long lastTxId) throws IOException {
        this.lock.lock();
        try {
            this.lastTxId = lastTxId;
            this.update(this.serialize());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTxMetadata(byte[] txMetadata) throws IOException {
        this.lock.lock();
        try {
            this.txMetadata = txMetadata;
            this.update(this.serialize());
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public long getLastTxId() {
        return this.lastTxId;
    }

    public byte[] getTxMetadata() {
        return this.txMetadata;
    }

    private ByteBuffer serialize() {
        ByteBuffer buffer = this.txMetadata == null ? ByteBuffer.allocate(25) : ByteBuffer.allocate(25 + this.txMetadata.length);
        buffer.position(8);
        buffer.putInt(3);
        buffer.put(this.dirtyFlag ? (byte)1 : 0);
        buffer.putLong(this.lastTxId);
        if (this.txMetadata == null) {
            buffer.putInt(-1);
        } else {
            buffer.putInt(this.txMetadata.length);
            buffer.put(this.txMetadata);
        }
        long xxHash = XX_HASH_64.hash(buffer, 8, buffer.capacity() - 8, 747164466757L);
        buffer.putLong(0, xxHash);
        buffer.rewind();
        return buffer;
    }

    static {
        XXHashFactory xxHashFactory = XXHashFactory.fastestInstance();
        XX_HASH_64 = xxHashFactory.hash64();
    }
}

