/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.concur.collection.CASObjectArray;
import com.orientechnologies.common.concur.lock.ScalableRWLock;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.AtomicOperationStatus;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

public class AtomicOperationsTable {
    private static final OperationInformation ATOMIC_OPERATION_STATUS_PLACE_HOLDER = new OperationInformation(AtomicOperationStatus.NOT_STARTED, -1L);
    private long[] idOffsets;
    private CASObjectArray<OperationInformation>[] tables;
    private final ScalableRWLock compactionLock = new ScalableRWLock();
    private final int tableCompactionInterval;
    private final AtomicLong operationsStarted = new AtomicLong();
    private volatile long lastCompactionOperation;

    public AtomicOperationsTable(int tableCompactionInterval, long idOffset) {
        this.tableCompactionInterval = tableCompactionInterval;
        this.idOffsets = new long[]{idOffset};
        this.tables = new CASObjectArray[]{new CASObjectArray()};
    }

    public void startOperation(long operationId, long segment) {
        this.changeOperationStatus(operationId, null, AtomicOperationStatus.IN_PROGRESS, segment);
    }

    public void commitOperation(long operationId) {
        this.changeOperationStatus(operationId, AtomicOperationStatus.IN_PROGRESS, AtomicOperationStatus.COMMITTED, -1L);
    }

    public void rollbackOperation(long operationId) {
        this.changeOperationStatus(operationId, AtomicOperationStatus.IN_PROGRESS, AtomicOperationStatus.ROLLED_BACK, -1L);
    }

    public void persistOperation(long operationId) {
        this.changeOperationStatus(operationId, AtomicOperationStatus.COMMITTED, AtomicOperationStatus.PERSISTED, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSegmentEarliestOperationInProgress() {
        this.compactionLock.sharedLock();
        try {
            for (CASObjectArray<OperationInformation> table : this.tables) {
                int size = table.size();
                for (int i = 0; i < size; ++i) {
                    OperationInformation operationInformation = table.get(i);
                    if (operationInformation.status != AtomicOperationStatus.IN_PROGRESS) continue;
                    long l = operationInformation.segment;
                    return l;
                }
            }
        }
        finally {
            this.compactionLock.sharedUnlock();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSegmentEarliestNotPersistedOperation() {
        this.compactionLock.sharedLock();
        try {
            for (CASObjectArray<OperationInformation> table : this.tables) {
                int size = table.size();
                for (int i = 0; i < size; ++i) {
                    OperationInformation operationInformation = table.get(i);
                    if (operationInformation.status != AtomicOperationStatus.IN_PROGRESS && operationInformation.status != AtomicOperationStatus.COMMITTED) continue;
                    long l = operationInformation.segment;
                    return l;
                }
            }
        }
        finally {
            this.compactionLock.sharedUnlock();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeOperationStatus(long operationId, AtomicOperationStatus expectedStatus, AtomicOperationStatus newStatus, long segment) {
        if (this.operationsStarted.get() > this.lastCompactionOperation + (long)this.tableCompactionInterval) {
            this.compactTable();
        }
        this.compactionLock.sharedLock();
        try {
            long nextOffset;
            if (segment >= 0L && newStatus != AtomicOperationStatus.IN_PROGRESS) {
                throw new IllegalStateException("Invalid status of atomic operation, expected " + (Object)((Object)AtomicOperationStatus.IN_PROGRESS));
            }
            if (newStatus == AtomicOperationStatus.IN_PROGRESS && segment < 0L) {
                throw new IllegalStateException("Invalid value of transaction segment for newly started operation");
            }
            int currentIndex = 0;
            long currentOffset = this.idOffsets[0];
            long l = nextOffset = this.idOffsets.length > 1 ? this.idOffsets[1] : Long.MAX_VALUE;
            while (true) {
                if (currentOffset <= operationId && operationId < nextOffset) {
                    int itemIndex = (int)(operationId - currentOffset);
                    if (itemIndex < 0) {
                        throw new IllegalStateException("Invalid state of table of atomic operations");
                    }
                    CASObjectArray<OperationInformation> table = this.tables[currentIndex];
                    if (newStatus == AtomicOperationStatus.IN_PROGRESS) {
                        table.set(itemIndex, new OperationInformation(AtomicOperationStatus.IN_PROGRESS, segment), ATOMIC_OPERATION_STATUS_PLACE_HOLDER);
                        this.operationsStarted.incrementAndGet();
                    } else {
                        OperationInformation currentInformation = table.get(itemIndex);
                        if (currentInformation.status != expectedStatus) {
                            throw new IllegalStateException("Invalid state of table of atomic operations, incorrect expected state " + (Object)((Object)currentInformation.status) + " for upcoming state " + (Object)((Object)newStatus) + " . Expected state was " + (Object)((Object)expectedStatus) + " .");
                        }
                        if (!table.compareAndSet(itemIndex, currentInformation, new OperationInformation(newStatus, currentInformation.segment))) {
                            throw new IllegalStateException("Invalid state of table of atomic operations");
                        }
                    }
                    break;
                }
                if (++currentIndex >= this.idOffsets.length) {
                    throw new IllegalStateException("Invalid state of table of atomic operations, entry for the transaction with id " + operationId + " can not be found");
                }
                currentOffset = this.idOffsets[currentIndex];
                nextOffset = this.idOffsets.length > currentIndex + 1 ? this.idOffsets[currentIndex + 1] : Long.MAX_VALUE;
            }
        }
        finally {
            this.compactionLock.sharedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactTable() {
        this.compactionLock.exclusiveLock();
        try {
            ArrayDeque<Integer> tablesToRemove = new ArrayDeque<Integer>(this.tables.length);
            boolean tablesAreFull = true;
            long maxId = Long.MIN_VALUE;
            for (int tableIndex = 0; tableIndex < this.tables.length; ++tableIndex) {
                CASObjectArray<OperationInformation> table = this.tables[tableIndex];
                long idOffset = this.idOffsets[tableIndex];
                CASObjectArray<OperationInformation> newTable = new CASObjectArray<OperationInformation>();
                int tableSize = table.size();
                boolean addition = false;
                long newIdOffset = -1L;
                for (int i = 0; i < tableSize; ++i) {
                    OperationInformation operationInformation = table.get(i);
                    if (!addition) {
                        if (operationInformation.status == AtomicOperationStatus.IN_PROGRESS || operationInformation.status == AtomicOperationStatus.NOT_STARTED || operationInformation.status == AtomicOperationStatus.COMMITTED) {
                            addition = true;
                            newIdOffset = (long)i + idOffset;
                            newTable.add(operationInformation);
                        }
                    } else {
                        newTable.add(operationInformation);
                    }
                    if (maxId >= idOffset + (long)i) continue;
                    maxId = i;
                }
                if (newIdOffset < 0L) {
                    newIdOffset = idOffset + (long)tableSize;
                }
                this.tables[tableIndex] = newTable;
                this.idOffsets[tableIndex] = newIdOffset;
                if (newTable.size() == 0) {
                    tablesToRemove.push(tableIndex);
                    continue;
                }
                tablesAreFull = (tablesAreFull || tableIndex == 0) && newTable.size() == this.tableCompactionInterval;
            }
            if (!tablesToRemove.isEmpty() && this.tables.length > 1) {
                if (tablesToRemove.size() == this.tables.length) {
                    this.idOffsets = new long[]{maxId + 1L};
                    this.tables = new CASObjectArray[]{this.tables[0]};
                } else {
                    CASObjectArray[] newTables = new CASObjectArray[this.tables.length - tablesToRemove.size()];
                    long[] newIdOffsets = new long[this.idOffsets.length - tablesToRemove.size()];
                    int firstSrcIndex = 0;
                    int firstDestIndex = 0;
                    Iterator iterator = tablesToRemove.iterator();
                    while (iterator.hasNext()) {
                        int tableIndex = (Integer)iterator.next();
                        int len = tableIndex - firstSrcIndex;
                        if (len > 0) {
                            System.arraycopy(this.tables, firstSrcIndex, newTables, firstDestIndex, len);
                            System.arraycopy(this.idOffsets, firstSrcIndex, newIdOffsets, firstDestIndex, len);
                            firstDestIndex += len;
                        }
                        firstSrcIndex = tableIndex + 1;
                    }
                    this.tables = newTables;
                    this.idOffsets = newIdOffsets;
                }
            }
            this.lastCompactionOperation = this.operationsStarted.get();
        }
        finally {
            this.compactionLock.exclusiveUnlock();
        }
    }

    private static final class OperationInformation {
        private final AtomicOperationStatus status;
        private final long segment;

        private OperationInformation(AtomicOperationStatus status, long segment) {
            this.status = status;
            this.segment = segment;
        }
    }
}

