/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.operationsfreezer;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.operationsfreezer.WaitingList;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.operationsfreezer.WaitingListNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;

public final class OperationsFreezer {
    private final LongAdder operationsCount = new LongAdder();
    private final AtomicInteger freezeRequests = new AtomicInteger();
    private final WaitingList operationsWaitingList = new WaitingList();
    private final AtomicLong freezeIdGen = new AtomicLong();
    private final ConcurrentMap<Long, FreezeParameters> freezeParametersIdMap = new ConcurrentHashMap<Long, FreezeParameters>();
    private final ThreadLocal<OModifiableInteger> operationDepth = ThreadLocal.withInitial(OModifiableInteger::new);

    public void startOperation() {
        OModifiableInteger operationDepth = this.operationDepth.get();
        if (operationDepth.value == 0) {
            this.operationsCount.increment();
            while (this.freezeRequests.get() > 0) {
                assert (this.freezeRequests.get() >= 0);
                this.operationsCount.decrement();
                this.throwFreezeExceptionIfNeeded();
                Thread thread = Thread.currentThread();
                this.operationsWaitingList.addThreadInWaitingList(thread);
                if (this.freezeRequests.get() > 0) {
                    LockSupport.park(this);
                }
                this.operationsCount.increment();
            }
        }
        assert (this.freezeRequests.get() >= 0);
        operationDepth.increment();
    }

    public void endOperation() {
        OModifiableInteger operationDepth = this.operationDepth.get();
        if (operationDepth.value <= 0) {
            throw new IllegalStateException("Invalid operation depth " + operationDepth.value);
        }
        --operationDepth.value;
        if (operationDepth.value == 0) {
            this.operationsCount.decrement();
        }
    }

    public long freezeOperations(Class<? extends OException> exceptionClass, String message) {
        long id = this.freezeIdGen.incrementAndGet();
        this.freezeRequests.incrementAndGet();
        if (exceptionClass != null) {
            this.freezeParametersIdMap.put(id, new FreezeParameters(message, exceptionClass));
        }
        while (this.operationsCount.sum() > 0L) {
            Thread.yield();
        }
        return id;
    }

    public void releaseOperations(long id) {
        if (id >= 0L) {
            this.freezeParametersIdMap.remove(id);
        }
        HashMap<Long, FreezeParameters> freezeParametersMap = new HashMap<Long, FreezeParameters>(this.freezeParametersIdMap);
        long requests = this.freezeRequests.decrementAndGet();
        if (requests == 0L) {
            for (Long freezeId : freezeParametersMap.keySet()) {
                this.freezeParametersIdMap.remove(freezeId);
            }
            WaitingListNode node = this.operationsWaitingList.cutWaitingList();
            while (node != null) {
                LockSupport.unpark(node.item);
                node = node.next;
            }
        }
    }

    private void throwFreezeExceptionIfNeeded() {
        for (FreezeParameters freezeParameters : this.freezeParametersIdMap.values()) {
            assert (freezeParameters.exceptionClass != null);
            if (freezeParameters.message != null) {
                try {
                    Constructor mConstructor = freezeParameters.exceptionClass.getConstructor(String.class);
                    throw (OException)mConstructor.newInstance(freezeParameters.message);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ie) {
                    OLogManager.instance().error(this, "Can not create instance of exception " + freezeParameters.exceptionClass + " with message will try empty constructor instead", ie, new Object[0]);
                    this.throwFreezeExceptionWithoutMessage(freezeParameters);
                    continue;
                }
            }
            this.throwFreezeExceptionWithoutMessage(freezeParameters);
        }
    }

    private void throwFreezeExceptionWithoutMessage(FreezeParameters freezeParameters) {
        try {
            throw (OException)freezeParameters.exceptionClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ie) {
            OLogManager.instance().error(this, "Can not create instance of exception " + freezeParameters.exceptionClass + " will park thread instead of throwing of exception", ie, new Object[0]);
            return;
        }
    }

    private static final class FreezeParameters {
        private final String message;
        private final Class<? extends OException> exceptionClass;

        private FreezeParameters(String message, Class<? extends OException> exceptionClass) {
            this.message = message;
            this.exceptionClass = exceptionClass;
        }
    }
}

