/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.nio.ByteBuffer;

public final class MetaDataRecord
extends OAbstractWALRecord {
    private byte[] metadata;

    public MetaDataRecord() {
    }

    public MetaDataRecord(byte[] metadata) {
        this.metadata = metadata;
    }

    public MetaDataRecord(OLogSequenceNumber previousCheckpoint) {
        super(previousCheckpoint);
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        OIntegerSerializer.INSTANCE.serializeNative(this.metadata.length, content, offset, new Object[0]);
        System.arraycopy(this.metadata, 0, content, offset += 4, this.metadata.length);
        return offset + content.length;
    }

    @Override
    public void toStream(ByteBuffer buffer) {
        buffer.putInt(this.metadata.length);
        buffer.put(this.metadata);
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        int metadataLen = OIntegerSerializer.INSTANCE.deserializeNative(content, offset);
        this.metadata = new byte[metadataLen];
        System.arraycopy(content, offset += 4, this.metadata, 0, metadataLen);
        return offset + metadataLen;
    }

    @Override
    public int serializedSize() {
        return 4 + this.metadata.length;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public int getId() {
        return 194;
    }
}

