/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedCluster;
import com.orientechnologies.orient.core.storage.cluster.v0.OPaginatedClusterV0;
import com.orientechnologies.orient.core.storage.cluster.v1.OPaginatedClusterV1;
import com.orientechnologies.orient.core.storage.cluster.v2.OPaginatedClusterV2;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;

public final class OPaginatedClusterFactory {
    public static final OPaginatedClusterFactory INSTANCE = new OPaginatedClusterFactory();

    public static OPaginatedCluster createCluster(String name, int configurationVersion, int binaryVersion, OAbstractPaginatedStorage storage) {
        if (configurationVersion >= 0 && configurationVersion < 6) {
            throw new OStorageException("You use deprecated version of storage cluster, this version is not supported in current implementation. Please do export/import or recreate database.");
        }
        switch (binaryVersion) {
            case 0: {
                return new OPaginatedClusterV0(name, storage);
            }
            case 1: {
                return new OPaginatedClusterV1(name, storage);
            }
            case 2: {
                return new OPaginatedClusterV2(name, storage);
            }
        }
        throw new IllegalStateException("Invalid binary version of cluster " + binaryVersion);
    }

    public static OPaginatedCluster createCluster(String name, int binaryVersion, OAbstractPaginatedStorage storage, String dataExtension, String cpmExtension) {
        switch (binaryVersion) {
            case 0: {
                throw new IllegalStateException("Version 0 of cluster is not supported with given configuration");
            }
            case 1: {
                return new OPaginatedClusterV1(name, dataExtension, cpmExtension, storage);
            }
            case 2: {
                return new OPaginatedClusterV2(name, dataExtension, cpmExtension, storage);
            }
        }
        throw new IllegalStateException("Invalid binary version of cluster " + binaryVersion);
    }
}

