/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractPageWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageChangesPortion;
import java.nio.ByteBuffer;

public class OUpdatePageRecord
extends OAbstractPageWALRecord {
    private OWALChanges changes;

    public OUpdatePageRecord() {
    }

    public OUpdatePageRecord(long pageIndex, long fileId, long operationUnitId, OWALChanges changes) {
        super(pageIndex, fileId, operationUnitId);
        this.changes = changes;
    }

    public OWALChanges getChanges() {
        return this.changes;
    }

    @Override
    public int serializedSize() {
        int serializedSize = super.serializedSize();
        serializedSize += this.changes.serializedSize();
        return serializedSize += 16;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        this.changes.toStream(buffer);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.changes = new OWALPageChangesPortion();
        this.changes.fromStream(buffer);
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OUpdatePageRecord that = (OUpdatePageRecord)o;
        if (this.lsn == null && that.lsn == null) {
            return true;
        }
        if (this.lsn == null) {
            return false;
        }
        if (that.lsn == null) {
            return false;
        }
        return this.lsn.equals(that.lsn);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.lsn.hashCode();
        return result;
    }

    @Override
    public int getId() {
        return 0;
    }
}

