/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import java.nio.ByteBuffer;

public class OWALPageV2
implements OWALPage {
    static final long MAGIC_NUMBER = 4012948655L;
    static final int LAST_STORED_LSN = 16;
    static final int END_LAST_RECORD = 24;
    static final int RECORDS_OFFSET = 28;
    static final int MAX_ENTRY_SIZE = PAGE_SIZE - 28;
    private final ByteBuffer buffer;

    OWALPageV2(ByteBuffer buffer, boolean isNew) {
        this.buffer = buffer;
        if (isNew) {
            buffer.position(4);
            buffer.putLong(4012948655L);
            buffer.putInt(MAX_ENTRY_SIZE);
            buffer.putLong(-1L);
            buffer.putInt(-1);
        }
    }

    @Override
    public byte[] getRecord(int position) {
        this.buffer.position(position + 2);
        int recordSize = this.buffer.getInt();
        byte[] record = new byte[recordSize];
        this.buffer.get(record);
        return record;
    }

    @Override
    public boolean mergeWithNextPage(int position) {
        return this.buffer.get(position) > 0;
    }

    @Override
    public int getFreeSpace() {
        return this.buffer.getInt(12);
    }

    static int calculateSerializedSize(int recordSize) {
        return recordSize + 4 + 2;
    }

    static int calculateRecordSize(int serializedSize) {
        return serializedSize - 4 - 2;
    }
}

