/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.common.deque;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class Node<T>
extends AtomicReference<Node<T>> {
    static final int BUFFER_SIZE = 1024;
    private volatile Node<T> prev;
    public volatile int deqidx = 0;
    public final AtomicReferenceArray<T> items = new AtomicReferenceArray(1024);
    public final AtomicInteger enqidx = new AtomicInteger(1);

    Node() {
    }

    Node(T record, Node<T> prev) {
        this.items.lazySet(0, record);
        this.prev = prev;
    }

    public void clearPrev() {
        this.prev = null;
    }

    public boolean casNext(Node<T> oldNode, Node<T> newNode) {
        return this.compareAndSet(oldNode, newNode);
    }

    public Node<T> getNext() {
        return (Node)this.get();
    }

    public Node<T> getPrev() {
        return this.prev;
    }

    @Override
    public String toString() {
        return "Node{deqidx=" + this.deqidx + ", items=" + this.items + ", enqidx=" + this.enqidx + '}';
    }
}

