/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2Bucket;
import java.nio.ByteBuffer;

public final class CellBTreeMultiValueV2BucketRemoveNonLeafEntryPO
extends PageOperationRecord {
    private int index;
    private byte[] key;
    private int left;
    private int right;
    private int prevChild;

    public CellBTreeMultiValueV2BucketRemoveNonLeafEntryPO() {
    }

    public CellBTreeMultiValueV2BucketRemoveNonLeafEntryPO(int index, byte[] key, int left, int right, int prevChild) {
        this.index = index;
        this.key = key;
        this.left = left;
        this.right = right;
        this.prevChild = prevChild;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getPrevChild() {
        return this.prevChild;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        bucket.removeNonLeafEntry(this.index, this.key, this.prevChild);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        boolean result = bucket.addNonLeafEntry(this.index, this.key, this.left, this.right, true);
        if (!result) {
            throw new IllegalStateException("Can not undo remove leaf entry operation");
        }
    }

    @Override
    public int getId() {
        return 132;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 20 + this.key.length;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.putInt(this.left);
        buffer.putInt(this.right);
        buffer.putInt(this.prevChild);
        buffer.putInt(this.key.length);
        buffer.put(this.key);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        this.left = buffer.getInt();
        this.right = buffer.getInt();
        this.prevChild = buffer.getInt();
        int keyLen = buffer.getInt();
        this.key = new byte[keyLen];
        buffer.get(this.key);
    }
}

