/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.bucket;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2Bucket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class CellBTreeMultiValueV2BucketShrinkLeafEntriesPO
extends PageOperationRecord {
    private int newSize;
    private List<CellBTreeMultiValueV2Bucket.LeafEntry> removedEntries;
    private OBinarySerializer keySerializer;
    private boolean isEncrypted;

    public CellBTreeMultiValueV2BucketShrinkLeafEntriesPO() {
    }

    public CellBTreeMultiValueV2BucketShrinkLeafEntriesPO(int newSize, List<CellBTreeMultiValueV2Bucket.LeafEntry> removedEntries, OBinarySerializer keySerializer, boolean isEncrypted) {
        this.newSize = newSize;
        this.removedEntries = removedEntries;
        this.keySerializer = keySerializer;
        this.isEncrypted = isEncrypted;
    }

    public int getNewSize() {
        return this.newSize;
    }

    public List<CellBTreeMultiValueV2Bucket.LeafEntry> getRemovedEntries() {
        return this.removedEntries;
    }

    public OBinarySerializer getKeySerializer() {
        return this.keySerializer;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        bucket.shrink(this.newSize, this.keySerializer, this.isEncrypted);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        bucket.addAll(this.removedEntries, this.keySerializer, this.isEncrypted);
    }

    @Override
    public int getId() {
        return 135;
    }

    @Override
    public int serializedSize() {
        int size = 4;
        for (CellBTreeMultiValueV2Bucket.LeafEntry leafEntry : this.removedEntries) {
            size += 20;
            size += leafEntry.key.length;
            size += leafEntry.values.size() * 10;
        }
        return super.serializedSize() + (size += 6);
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.removedEntries.size());
        for (CellBTreeMultiValueV2Bucket.LeafEntry leafEntry : this.removedEntries) {
            buffer.putInt(leafEntry.entriesCount);
            buffer.putLong(leafEntry.mId);
            buffer.putInt(leafEntry.values.size());
            for (ORID rid : leafEntry.values) {
                buffer.putShort((short)rid.getClusterId());
                buffer.putLong(rid.getClusterPosition());
            }
            buffer.putInt(leafEntry.key.length);
            buffer.put(leafEntry.key);
        }
        buffer.put(this.keySerializer.getId());
        buffer.put(this.isEncrypted ? (byte)1 : 0);
        buffer.putInt(this.newSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        int entriesSize = buffer.getInt();
        this.removedEntries = new ArrayList<CellBTreeMultiValueV2Bucket.LeafEntry>(entriesSize);
        for (int i = 0; i < entriesSize; ++i) {
            int entriesCount = buffer.getInt();
            long mId = buffer.getLong();
            int valuesSize = buffer.getInt();
            ArrayList<ORID> values = new ArrayList<ORID>(valuesSize);
            for (int n = 0; n < valuesSize; ++n) {
                short clusterId = buffer.getShort();
                long clusterPosition = buffer.getLong();
                values.add(new ORecordId(clusterId, clusterPosition));
            }
            int keyLen = buffer.getInt();
            byte[] key = new byte[keyLen];
            buffer.get(key);
            this.removedEntries.add(new CellBTreeMultiValueV2Bucket.LeafEntry(key, mId, values, entriesCount));
        }
        this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
        this.isEncrypted = buffer.get() > 0;
        this.newSize = buffer.getInt();
    }
}

