/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v1.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v1.CellBTreeBucketSingleValueV1;
import java.nio.ByteBuffer;

public final class CellBTreeBucketSingleValueV1AddLeafEntryPO
extends PageOperationRecord {
    private int index;
    private byte[] key;
    private byte[] value;

    public CellBTreeBucketSingleValueV1AddLeafEntryPO() {
    }

    public CellBTreeBucketSingleValueV1AddLeafEntryPO(int index, byte[] key, byte[] value) {
        this.index = index;
        this.key = key;
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeBucketSingleValueV1 bucket = new CellBTreeBucketSingleValueV1(cacheEntry);
        boolean result = bucket.addLeafEntry(this.index, this.key, this.value);
        if (!result) {
            throw new IllegalStateException("Can not redo leaf entry addition");
        }
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeBucketSingleValueV1 bucket = new CellBTreeBucketSingleValueV1(cacheEntry);
        bucket.removeLeafEntry(this.index, this.key, this.value);
    }

    @Override
    public int getId() {
        return 61;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 12 + this.key.length + this.value.length;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.putInt(this.key.length);
        buffer.put(this.key);
        buffer.putInt(this.value.length);
        buffer.put(this.value);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        int keyLen = buffer.getInt();
        this.key = new byte[keyLen];
        buffer.get(this.key);
        int valueLen = buffer.getInt();
        this.value = new byte[valueLen];
        buffer.get(this.value);
    }
}

