/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v1.bucket;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v1.CellBTreeBucketSingleValueV1;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class CellBTreeBucketSingleValueV1ShrinkPO
extends PageOperationRecord {
    private int newSize;
    private List<byte[]> removedRecords;
    private boolean isEncrypted;
    private OBinarySerializer keySerializer;

    public CellBTreeBucketSingleValueV1ShrinkPO() {
    }

    public CellBTreeBucketSingleValueV1ShrinkPO(int newSize, List<byte[]> removedRecords, boolean isEncrypted, OBinarySerializer keySerializer) {
        this.newSize = newSize;
        this.removedRecords = removedRecords;
        this.isEncrypted = isEncrypted;
        this.keySerializer = keySerializer;
    }

    public int getNewSize() {
        return this.newSize;
    }

    public List<byte[]> getRemovedRecords() {
        return this.removedRecords;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public OBinarySerializer getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeBucketSingleValueV1 bucket = new CellBTreeBucketSingleValueV1(cacheEntry);
        bucket.shrink(this.newSize, this.isEncrypted, this.keySerializer);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeBucketSingleValueV1 bucket = new CellBTreeBucketSingleValueV1(cacheEntry);
        bucket.addAll(this.removedRecords, this.isEncrypted, this.keySerializer);
    }

    @Override
    public int getId() {
        return 66;
    }

    @Override
    public int serializedSize() {
        int serializedSize = 10 + this.removedRecords.size() * 4;
        for (byte[] record : this.removedRecords) {
            serializedSize += record.length;
        }
        return super.serializedSize() + serializedSize;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.newSize);
        buffer.putInt(this.removedRecords.size());
        for (byte[] record : this.removedRecords) {
            buffer.putInt(record.length);
            buffer.put(record);
        }
        buffer.put(this.isEncrypted ? (byte)1 : 0);
        buffer.put(this.keySerializer.getId());
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.newSize = buffer.getInt();
        int records = buffer.getInt();
        this.removedRecords = new ArrayList<byte[]>();
        for (int i = 0; i < records; ++i) {
            int recordLen = buffer.getInt();
            byte[] record = new byte[recordLen];
            buffer.get(record);
            this.removedRecords.add(record);
        }
        this.isEncrypted = buffer.get() > 0;
        this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
    }
}

