/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3.CellBTreeSingleValueBucketV3;
import java.nio.ByteBuffer;

public final class CellBTreeBucketSingleValueV3AddNonLeafEntryPO
extends PageOperationRecord {
    private int index;
    private byte[] key;
    private boolean updateNeighbours;
    private int leftChild;
    private int rightChild;
    private int prevChild;

    public CellBTreeBucketSingleValueV3AddNonLeafEntryPO() {
    }

    public CellBTreeBucketSingleValueV3AddNonLeafEntryPO(int index, byte[] key, boolean updateNeighbours, int leftChild, int rightChild, int prevChild) {
        this.index = index;
        this.key = key;
        this.updateNeighbours = updateNeighbours;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.prevChild = prevChild;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getKey() {
        return this.key;
    }

    public boolean isUpdateNeighbours() {
        return this.updateNeighbours;
    }

    public int getLeftChild() {
        return this.leftChild;
    }

    public int getRightChild() {
        return this.rightChild;
    }

    public int getPrevChild() {
        return this.prevChild;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeSingleValueBucketV3 bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
        boolean added = bucket.addNonLeafEntry(this.index, this.leftChild, this.rightChild, this.key, this.updateNeighbours);
        if (!added) {
            throw new IllegalStateException("Can not redo operation of addition of non leaf entry.");
        }
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeSingleValueBucketV3 bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
        bucket.removeNonLeafEntry(this.index, this.key, this.prevChild);
    }

    @Override
    public int getId() {
        return 79;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 20 + this.key.length + 1;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.putInt(this.key.length);
        buffer.put(this.key);
        buffer.put(this.updateNeighbours ? (byte)1 : 0);
        buffer.putInt(this.leftChild);
        buffer.putInt(this.rightChild);
        buffer.putInt(this.prevChild);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        int len = buffer.getInt();
        this.key = new byte[len];
        buffer.get(this.key);
        this.updateNeighbours = buffer.get() > 0;
        this.leftChild = buffer.getInt();
        this.rightChild = buffer.getInt();
        this.prevChild = buffer.getInt();
    }
}

