/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3.CellBTreeSingleValueBucketV3;
import java.nio.ByteBuffer;

public final class CellBTreeBucketSingleValueV3UpdateValuePO
extends PageOperationRecord {
    private int index;
    private int keySize;
    private byte[] prevValue;
    private byte[] value;

    public CellBTreeBucketSingleValueV3UpdateValuePO() {
    }

    public CellBTreeBucketSingleValueV3UpdateValuePO(int index, int keySize, byte[] prevValue, byte[] value) {
        this.index = index;
        this.keySize = keySize;
        this.prevValue = prevValue;
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public byte[] getPrevValue() {
        return this.prevValue;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        CellBTreeSingleValueBucketV3 bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
        bucket.updateValue(this.index, this.value, this.keySize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        CellBTreeSingleValueBucketV3 bucket = new CellBTreeSingleValueBucketV3(cacheEntry);
        bucket.updateValue(this.index, this.prevValue, this.keySize);
    }

    @Override
    public int getId() {
        return 83;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16 + this.prevValue.length + this.value.length;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.putInt(this.keySize);
        buffer.putInt(this.prevValue.length);
        buffer.put(this.prevValue);
        buffer.putInt(this.value.length);
        buffer.put(this.value);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        this.keySize = buffer.getInt();
        int prevValueLen = buffer.getInt();
        this.prevValue = new byte[prevValueLen];
        buffer.get(this.prevValue);
        int valueLen = buffer.getInt();
        this.value = new byte[valueLen];
        buffer.get(this.value);
    }
}

