/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class ClusterPageReplaceRecordPO
extends PageOperationRecord {
    private int recordPosition;
    private int recordVersion;
    private byte[] record;
    private int oldRecordVersion;
    private byte[] oldRecord;

    public ClusterPageReplaceRecordPO() {
    }

    public ClusterPageReplaceRecordPO(int recordPosition, int recordVersion, byte[] record, int oldRecordVersion, byte[] oldRecord) {
        this.recordPosition = recordPosition;
        this.recordVersion = recordVersion;
        this.record = record;
        this.oldRecord = oldRecord;
        this.oldRecordVersion = oldRecordVersion;
    }

    public int getRecordPosition() {
        return this.recordPosition;
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    public byte[] getRecord() {
        return this.record;
    }

    public byte[] getOldRecord() {
        return this.oldRecord;
    }

    public int getOldRecordVersion() {
        return this.oldRecordVersion;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OClusterPage clusterPage = new OClusterPage(cacheEntry);
        clusterPage.replaceRecord(this.recordPosition, this.record, this.recordVersion);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OClusterPage clusterPage = new OClusterPage(cacheEntry);
        clusterPage.replaceRecord(this.recordPosition, this.oldRecord, this.oldRecordVersion);
    }

    @Override
    public int getId() {
        return 44;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 20 + this.record.length + this.oldRecord.length;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.recordPosition);
        buffer.putInt(this.recordVersion);
        buffer.putInt(this.record.length);
        buffer.put(this.record);
        buffer.putInt(this.oldRecordVersion);
        buffer.putInt(this.oldRecord.length);
        buffer.put(this.oldRecord);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.recordPosition = buffer.getInt();
        this.recordVersion = buffer.getInt();
        int recLen = buffer.getInt();
        this.record = new byte[recLen];
        buffer.get(this.record);
        this.oldRecordVersion = buffer.getInt();
        recLen = buffer.getInt();
        this.oldRecord = new byte[recLen];
        buffer.get(this.oldRecord);
    }
}

