/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class ClusterPageSetNextPagePO
extends PageOperationRecord {
    private int nextPage;
    private int oldNextPage;

    public ClusterPageSetNextPagePO() {
    }

    public ClusterPageSetNextPagePO(int nextPage, int oldNextPage) {
        this.nextPage = nextPage;
        this.oldNextPage = oldNextPage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public int getOldNextPage() {
        return this.oldNextPage;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OClusterPage clusterPage = new OClusterPage(cacheEntry);
        clusterPage.setNextPage(this.nextPage);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OClusterPage clusterPage = new OClusterPage(cacheEntry);
        clusterPage.setNextPage(this.oldNextPage);
    }

    @Override
    public int getId() {
        return 46;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.nextPage);
        buffer.putInt(this.oldNextPage);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.nextPage = buffer.getInt();
        this.oldNextPage = buffer.getInt();
    }
}

