/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v1.paginatedclusterstate;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.v1.OPaginatedClusterStateV1;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class PaginatedClusterStateV1SetRecordsSizePO
extends PageOperationRecord {
    private int oldRecordsSize;
    private int newRecordsSize;

    public PaginatedClusterStateV1SetRecordsSizePO() {
    }

    public PaginatedClusterStateV1SetRecordsSizePO(int oldRecordsSize, int newRecordsSize) {
        this.oldRecordsSize = oldRecordsSize;
        this.newRecordsSize = newRecordsSize;
    }

    public long getOldRecordsSize() {
        return this.oldRecordsSize;
    }

    public long getNewRecordsSize() {
        return this.newRecordsSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV1 paginatedClusterStateV1 = new OPaginatedClusterStateV1(cacheEntry);
        paginatedClusterStateV1.setRecordsSize(this.newRecordsSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV1 paginatedClusterStateV1 = new OPaginatedClusterStateV1(cacheEntry);
        paginatedClusterStateV1.setRecordsSize(this.oldRecordsSize);
    }

    @Override
    public int getId() {
        return 53;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.oldRecordsSize);
        buffer.putInt(this.newRecordsSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.oldRecordsSize = buffer.getInt();
        this.newRecordsSize = buffer.getInt();
    }
}

