/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v2.paginatedclusterstate;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.v2.OPaginatedClusterStateV2;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class PaginatedClusterStateV2SetRecordsSizePO
extends PageOperationRecord {
    private int oldRecordsSize;
    private int newRecordsSize;

    public PaginatedClusterStateV2SetRecordsSizePO() {
    }

    public PaginatedClusterStateV2SetRecordsSizePO(int oldRecordsSize, int newRecordsSize) {
        this.oldRecordsSize = oldRecordsSize;
        this.newRecordsSize = newRecordsSize;
    }

    public long getOldRecordsSize() {
        return this.oldRecordsSize;
    }

    public long getNewRecordsSize() {
        return this.newRecordsSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV2 paginatedClusterStateV2 = new OPaginatedClusterStateV2(cacheEntry);
        paginatedClusterStateV2.setRecordsSize(this.newRecordsSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV2 paginatedClusterStateV2 = new OPaginatedClusterStateV2(cacheEntry);
        paginatedClusterStateV2.setRecordsSize(this.oldRecordsSize);
    }

    @Override
    public int getId() {
        return 58;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.oldRecordsSize);
        buffer.putInt(this.newRecordsSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.oldRecordsSize = buffer.getInt();
        this.newRecordsSize = buffer.getInt();
    }
}

