/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directoryfirstpage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.DirectoryFirstPageV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2DirectoryFirstPageSetTombstonePO
extends PageOperationRecord {
    private int tombstone;
    private int pastTombstone;

    public LocalHashTableV2DirectoryFirstPageSetTombstonePO() {
    }

    public LocalHashTableV2DirectoryFirstPageSetTombstonePO(int tombstone, int pastTombstone) {
        this.tombstone = tombstone;
        this.pastTombstone = pastTombstone;
    }

    public int getTombstone() {
        return this.tombstone;
    }

    public int getPastTombstone() {
        return this.pastTombstone;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        DirectoryFirstPageV2 page = new DirectoryFirstPageV2(cacheEntry);
        page.setTombstone(this.tombstone);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        DirectoryFirstPageV2 page = new DirectoryFirstPageV2(cacheEntry);
        page.setTombstone(this.pastTombstone);
    }

    @Override
    public int getId() {
        return 184;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.tombstone);
        buffer.putInt(this.pastTombstone);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.tombstone = buffer.getInt();
        this.pastTombstone = buffer.getInt();
    }
}

