/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directoryfirstpage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.DirectoryFirstPageV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2DirectoryFirstPageSetTreeSizePO
extends PageOperationRecord {
    private int size;
    private int pastSize;

    public LocalHashTableV2DirectoryFirstPageSetTreeSizePO() {
    }

    public LocalHashTableV2DirectoryFirstPageSetTreeSizePO(int size, int pastSize) {
        this.size = size;
        this.pastSize = pastSize;
    }

    public int getSize() {
        return this.size;
    }

    public int getPastSize() {
        return this.pastSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        DirectoryFirstPageV2 page = new DirectoryFirstPageV2(cacheEntry);
        page.setTreeSize(this.size);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        DirectoryFirstPageV2 page = new DirectoryFirstPageV2(cacheEntry);
        page.setTreeSize(this.pastSize);
    }

    @Override
    public int getId() {
        return 183;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.size);
        buffer.putInt(this.pastSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.size = buffer.getInt();
        this.pastSize = buffer.getInt();
    }
}

