/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directorypage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.DirectoryPageV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2DirectoryPageSetMaxLeftChildDepthPO
extends PageOperationRecord {
    private int localNodeIndex;
    private byte maxLeftChildDepth;
    private byte pastMaxLeftChildDepth;

    public LocalHashTableV2DirectoryPageSetMaxLeftChildDepthPO() {
    }

    public LocalHashTableV2DirectoryPageSetMaxLeftChildDepthPO(int localNodeIndex, byte maxLeftChildDepth, byte pastMaxLeftChildDepth) {
        this.localNodeIndex = localNodeIndex;
        this.maxLeftChildDepth = maxLeftChildDepth;
        this.pastMaxLeftChildDepth = pastMaxLeftChildDepth;
    }

    public int getLocalNodeIndex() {
        return this.localNodeIndex;
    }

    public byte getMaxLeftChildDepth() {
        return this.maxLeftChildDepth;
    }

    public byte getPastMaxLeftChildDepth() {
        return this.pastMaxLeftChildDepth;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        DirectoryPageV2 page = new DirectoryPageV2(cacheEntry);
        page.setMaxLeftChildDepth(this.localNodeIndex, this.maxLeftChildDepth);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        DirectoryPageV2 page = new DirectoryPageV2(cacheEntry);
        page.setMaxLeftChildDepth(this.localNodeIndex, this.pastMaxLeftChildDepth);
    }

    @Override
    public int getId() {
        return 179;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 4 + 2;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.localNodeIndex);
        buffer.put(this.maxLeftChildDepth);
        buffer.put(this.pastMaxLeftChildDepth);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.localNodeIndex = buffer.getInt();
        this.maxLeftChildDepth = buffer.get();
        this.pastMaxLeftChildDepth = buffer.get();
    }
}

