/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeBucketV1;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class SBTreeBucketV1AddAllPO
extends PageOperationRecord {
    private int prevSize;
    private List<byte[]> rawRecords;
    private boolean isEncrypted;
    private OBinarySerializer keySerializer;
    private OBinarySerializer valueSerializer;

    public SBTreeBucketV1AddAllPO() {
    }

    public SBTreeBucketV1AddAllPO(int prevSize, List<byte[]> rawRecords, boolean isEncrypted, OBinarySerializer keySerializer, OBinarySerializer valueSerializer) {
        this.prevSize = prevSize;
        this.rawRecords = rawRecords;
        this.isEncrypted = isEncrypted;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public int getPrevSize() {
        return this.prevSize;
    }

    public List<byte[]> getRawRecords() {
        return this.rawRecords;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public OBinarySerializer getKeySerializer() {
        return this.keySerializer;
    }

    public OBinarySerializer getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
        bucket.addAll(this.rawRecords, this.isEncrypted, this.keySerializer, this.valueSerializer);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
        bucket.shrink(this.prevSize, this.isEncrypted, this.keySerializer, this.valueSerializer);
    }

    @Override
    public int getId() {
        return 99;
    }

    @Override
    public int serializedSize() {
        int serializedSize = 11 + 4 * this.rawRecords.size();
        for (byte[] record : this.rawRecords) {
            serializedSize += record.length;
        }
        return super.serializedSize() + serializedSize;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.prevSize);
        buffer.put(this.isEncrypted ? (byte)1 : 0);
        buffer.put(this.keySerializer.getId());
        buffer.put(this.valueSerializer.getId());
        buffer.putInt(this.rawRecords.size());
        for (byte[] record : this.rawRecords) {
            buffer.putInt(record.length);
            buffer.put(record);
        }
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.prevSize = buffer.getInt();
        this.isEncrypted = buffer.get() > 0;
        this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
        this.valueSerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
        this.rawRecords = new ArrayList<byte[]>();
        int recordsSize = buffer.getInt();
        for (int i = 0; i < recordsSize; ++i) {
            int recordSize = buffer.getInt();
            byte[] record = new byte[recordSize];
            buffer.get(record);
            this.rawRecords.add(record);
        }
    }
}

