/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeBucketV1;
import java.nio.ByteBuffer;

public final class SBTreeBucketV1SetLeftSiblingPO
extends PageOperationRecord {
    private int prevLeftSibling;
    private int leftSibling;

    public SBTreeBucketV1SetLeftSiblingPO() {
    }

    public SBTreeBucketV1SetLeftSiblingPO(int prevLeftSibling, int leftSibling) {
        this.prevLeftSibling = prevLeftSibling;
        this.leftSibling = leftSibling;
    }

    public int getPrevLeftSibling() {
        return this.prevLeftSibling;
    }

    public int getLeftSibling() {
        return this.leftSibling;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
        bucket.setLeftSibling(this.leftSibling);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
        bucket.setLeftSibling(this.prevLeftSibling);
    }

    @Override
    public int getId() {
        return 103;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.prevLeftSibling);
        buffer.putInt(this.leftSibling);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.prevLeftSibling = buffer.getInt();
        this.leftSibling = buffer.getInt();
    }
}

