/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v2.OSBTreeBucketV2;
import java.nio.ByteBuffer;

public final class SBTreeBucketV2SetRightSiblingPO
extends PageOperationRecord {
    private int prevRightSibling;
    private int rightSibling;

    public SBTreeBucketV2SetRightSiblingPO() {
    }

    public SBTreeBucketV2SetRightSiblingPO(int prevRightSibling, int rightSibling) {
        this.prevRightSibling = prevRightSibling;
        this.rightSibling = rightSibling;
    }

    public int getPrevRightSibling() {
        return this.prevRightSibling;
    }

    public int getRightSibling() {
        return this.rightSibling;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OSBTreeBucketV2 bucket = new OSBTreeBucketV2(cacheEntry);
        bucket.setRightSibling(this.rightSibling);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OSBTreeBucketV2 bucket = new OSBTreeBucketV2(cacheEntry);
        bucket.setRightSibling(this.prevRightSibling);
    }

    @Override
    public int getId() {
        return 115;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.prevRightSibling);
        buffer.putInt(this.rightSibling);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.prevRightSibling = buffer.getInt();
        this.rightSibling = buffer.getInt();
    }
}

