/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local.v3;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;

public final class ONullBucket<V>
extends ODurablePage {
    private final OBinarySerializer<V> valueSerializer;

    public ONullBucket(OCacheEntry cacheEntry, OBinarySerializer<V> valueSerializer, boolean isNew) {
        super(cacheEntry);
        this.valueSerializer = valueSerializer;
        if (isNew) {
            this.setByteValue(28, (byte)0);
        }
    }

    public void setValue(V value) {
        this.setByteValue(28, (byte)1);
        int valueSize = this.valueSerializer.getObjectSize(value, new Object[0]);
        byte[] serializedValue = new byte[valueSize];
        this.valueSerializer.serializeNativeObject(value, serializedValue, 0, new Object[0]);
        this.setBinaryValue(29, serializedValue);
    }

    public V getValue() {
        if (this.getByteValue(28) == 0) {
            return null;
        }
        return this.deserializeFromDirectMemory(this.valueSerializer, 29);
    }

    public void removeValue() {
        this.setByteValue(28, (byte)0);
    }
}

