/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.entrypoint.CellBTreeMultiValueV2EntryPointInitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.entrypoint.CellBTreeMultiValueV2EntryPointSetEntryIdPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.entrypoint.CellBTreeMultiValueV2EntryPointSetPagesSizePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.multivalue.v2.entrypoint.CellBTreeMultiValueV2EntryPointSetTreeSizePO;

public final class CellBTreeMultiValueV2EntryPoint<K>
extends ODurablePage {
    private static final int KEY_SERIALIZER_OFFSET = 28;
    private static final int KEY_SIZE_OFFSET = 29;
    private static final int TREE_SIZE_OFFSET = 33;
    private static final int PAGES_SIZE_OFFSET = 41;
    private static final int ENTRY_ID_OFFSET = 45;

    public CellBTreeMultiValueV2EntryPoint(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init() {
        this.setLongValue(33, 0L);
        this.setIntValue(41, 1);
        this.setLongValue(45, 0L);
        this.addPageOperation(new CellBTreeMultiValueV2EntryPointInitPO());
    }

    public void setTreeSize(long size) {
        long prevSize = this.getLongValue(33);
        this.setLongValue(33, size);
        this.addPageOperation(new CellBTreeMultiValueV2EntryPointSetTreeSizePO(size, prevSize));
    }

    public long getTreeSize() {
        return this.getLongValue(33);
    }

    public void setPagesSize(int pages) {
        int prevPages = this.getIntValue(41);
        this.setIntValue(41, pages);
        this.addPageOperation(new CellBTreeMultiValueV2EntryPointSetPagesSizePO(pages, prevPages));
    }

    public int getPagesSize() {
        return this.getIntValue(41);
    }

    public void setEntryId(long id) {
        long prevEntryId = this.getLongValue(45);
        this.setLongValue(45, id);
        this.addPageOperation(new CellBTreeMultiValueV2EntryPointSetEntryIdPO(id, prevEntryId));
    }

    public long getEntryId() {
        return this.getLongValue(45);
    }
}

