/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.MultiValueEntry;
import java.nio.ByteBuffer;

public final class MultiValueEntrySerializer
implements OBinarySerializer<MultiValueEntry> {
    public static final int ID = 27;
    public static final MultiValueEntrySerializer INSTANCE = new MultiValueEntrySerializer();

    @Override
    public int getObjectSize(MultiValueEntry object, Object ... hints) {
        return 18;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 18;
    }

    @Override
    public void serialize(MultiValueEntry object, byte[] stream, int startPosition, Object ... hints) {
        int pos = startPosition;
        OLongSerializer.INSTANCE.serialize(object.id, stream, pos, new Object[0]);
        OShortSerializer.INSTANCE.serialize((short)object.clusterId, stream, pos += 8, new Object[0]);
        OLongSerializer.INSTANCE.serialize(object.clusterPosition, stream, pos += 2, new Object[0]);
    }

    @Override
    public MultiValueEntry deserialize(byte[] stream, int startPosition) {
        int pos = startPosition;
        long id = OLongSerializer.INSTANCE.deserialize(stream, pos);
        short clusterId = OShortSerializer.INSTANCE.deserialize(stream, pos += 8);
        long clusterPosition = OLongSerializer.INSTANCE.deserialize(stream, pos += 2);
        return new MultiValueEntry(id, clusterId, clusterPosition);
    }

    @Override
    public byte getId() {
        return 27;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 18;
    }

    @Override
    public void serializeNativeObject(MultiValueEntry object, byte[] stream, int startPosition, Object ... hints) {
        int pos = startPosition;
        OLongSerializer.INSTANCE.serializeNative(object.id, stream, pos, new Object[0]);
        OShortSerializer.INSTANCE.serializeNative((short)object.clusterId, stream, pos += 8, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(object.clusterPosition, stream, pos += 2, new Object[0]);
    }

    @Override
    public MultiValueEntry deserializeNativeObject(byte[] stream, int startPosition) {
        int pos = startPosition;
        long id = OLongSerializer.INSTANCE.deserializeNative(stream, pos);
        short clusterId = OShortSerializer.INSTANCE.deserializeNative(stream, pos += 8);
        long clusterPosition = OLongSerializer.INSTANCE.deserializeNative(stream, pos += 2);
        return new MultiValueEntry(id, clusterId, clusterPosition);
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 18;
    }

    @Override
    public MultiValueEntry preprocess(MultiValueEntry value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(MultiValueEntry object, ByteBuffer buffer, Object ... hints) {
        buffer.putLong(object.id);
        buffer.putShort((short)object.clusterId);
        buffer.putLong(object.clusterPosition);
    }

    @Override
    public MultiValueEntry deserializeFromByteBufferObject(ByteBuffer buffer) {
        long id = buffer.getLong();
        short clusterId = buffer.getShort();
        long clusterPosition = buffer.getLong();
        return new MultiValueEntry(id, clusterId, clusterPosition);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 18;
    }

    @Override
    public MultiValueEntry deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        int position = offset;
        long id = walChanges.getLongValue(buffer, position);
        short clusterId = walChanges.getShortValue(buffer, position += 8);
        long clusterPosition = walChanges.getLongValue(buffer, position += 2);
        return new MultiValueEntry(id, clusterId, clusterPosition);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 18;
    }
}

