/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializerDelta;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkDistributed;
import com.orientechnologies.orient.core.tx.OTransactionDataChange;
import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OTransactionData {
    private OTransactionId transactionId;
    private List<OTransactionDataChange> changes = new ArrayList<OTransactionDataChange>();

    public OTransactionData(OTransactionId transactionId) {
        this.transactionId = transactionId;
    }

    public static OTransactionData read(DataInput dataInput) throws IOException {
        OTransactionId transactionId = OTransactionId.read(dataInput);
        int entries = dataInput.readInt();
        OTransactionData data = new OTransactionData(transactionId);
        while (entries-- > 0) {
            data.changes.add(OTransactionDataChange.deserialize(dataInput));
        }
        return data;
    }

    public void addRecord(byte[] record) {
        try {
            this.changes.add(OTransactionDataChange.deserialize(new DataInputStream(new ByteArrayInputStream(record))));
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("error reading transaction data change record"), e);
        }
    }

    public void addChange(OTransactionDataChange change) {
        this.changes.add(change);
    }

    public OTransactionId getTransactionId() {
        return this.transactionId;
    }

    public List<OTransactionDataChange> getChanges() {
        return this.changes;
    }

    public void write(DataOutput output) throws IOException {
        this.transactionId.write(output);
        output.writeInt(this.changes.size());
        for (OTransactionDataChange change : this.changes) {
            change.serialize(output);
        }
    }

    public void fill(OTransactionInternal transaction, ODatabaseDocumentInternal database) {
        transaction.fill(this.changes.stream().map(x -> {
            ORecordOperation operation = new ORecordOperation(x.getId(), x.getType());
            ORecord record = null;
            switch (x.getType()) {
                case 3: {
                    record = ORecordSerializerNetworkDistributed.INSTANCE.fromStream(x.getRecord().get(), null);
                    ORecordInternal.setRecordSerializer(record, database.getSerializer());
                    break;
                }
                case 1: {
                    if (x.getRecordType() == 100) {
                        record = (ORecord)database.load(x.getId());
                        if (record == null) {
                            record = new ODocument();
                        }
                        ((ODocument)record).deserializeFields(new String[0]);
                        ODocumentInternal.clearTransactionTrackData((ODocument)record);
                        ODocumentSerializerDelta.instance().deserializeDelta(x.getRecord().get(), (ODocument)record);
                        record.setDirty();
                        break;
                    }
                    record = ORecordSerializerNetworkDistributed.INSTANCE.fromStream(x.getRecord().get(), null);
                    ORecordInternal.setRecordSerializer(record, database.getSerializer());
                    break;
                }
                case 2: {
                    record = (ORecord)database.load(x.getId());
                    if (record != null) break;
                    record = Orient.instance().getRecordFactoryManager().newInstance(x.getRecordType(), x.getId().getClusterId(), database);
                }
            }
            ORecordInternal.setIdentity(record, (ORecordId)x.getId());
            ORecordInternal.setVersion(record, x.getVersion());
            operation.setRecord(record);
            return operation;
        }).iterator());
    }
}

