/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class OTransactionIndexChangesPerKey {
    static final int SET_ADD_THRESHOLD = 8;
    public final Object key;
    public final List<OTransactionIndexEntry> entries;
    public boolean clientTrackOnly;

    public OTransactionIndexChangesPerKey(Object iKey) {
        this.key = iKey;
        this.entries = new ArrayList<OTransactionIndexEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OIdentifiable iValue, OTransactionIndexChanges.OPERATION iOperation) {
        OTransactionIndexChangesPerKey oTransactionIndexChangesPerKey = this;
        synchronized (oTransactionIndexChangesPerKey) {
            Iterator<OTransactionIndexEntry> iter2 = this.entries.iterator();
            while (iter2.hasNext()) {
                OTransactionIndexEntry entry = iter2.next();
                if (entry.value != iValue && (entry.value == null || !entry.value.equals(iValue)) || entry.operation.equals((Object)iOperation)) continue;
                iter2.remove();
                return;
            }
            this.entries.add(new OTransactionIndexEntry(iValue != null ? iValue.getIdentity() : null, iOperation));
        }
    }

    public Iterable<OTransactionIndexEntry> interpret(Interpretation interpretation) {
        OTransactionIndexChangesPerKey oTransactionIndexChangesPerKey = this;
        synchronized (oTransactionIndexChangesPerKey) {
            switch (interpretation) {
                case Unique: {
                    return this.interpretAsUnique();
                }
                case Dictionary: {
                    return this.interpretAsDictionary();
                }
                case NonUnique: {
                    return this.interpretAsNonUnique();
                }
            }
            throw new IllegalStateException("Unexpected interpretation '" + (Object)((Object)interpretation) + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        OTransactionIndexChangesPerKey oTransactionIndexChangesPerKey = this;
        synchronized (oTransactionIndexChangesPerKey) {
            this.entries.clear();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.key).append(" [");
        boolean first = true;
        for (OTransactionIndexEntry entry : this.entries) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.value).append(" (").append((Object)entry.operation).append(")");
        }
        builder.append("]");
        return builder.toString();
    }

    private Iterable<OTransactionIndexEntry> interpretAsUnique() {
        if (this.entries.size() < 2) {
            return new ArrayList<OTransactionIndexEntry>(this.entries);
        }
        if (this.entries.size() == 2) {
            ORID ridB;
            OTransactionIndexEntry entryA = this.entries.get(0);
            OTransactionIndexEntry entryB = this.entries.get(1);
            if (entryA.operation == OTransactionIndexChanges.OPERATION.REMOVE && entryB.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                return Collections.singletonList(entryA);
            }
            ORID ridA = entryA.value == null ? null : entryA.value.getIdentity();
            ORID oRID = ridB = entryB.value == null ? null : entryB.value.getIdentity();
            if (ridA != null && ridA.equals(ridB)) {
                if (entryA.operation == entryB.operation) {
                    return Collections.singletonList(entryA);
                }
                return new ArrayList<OTransactionIndexEntry>(this.entries);
            }
            if (entryB.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                if (entryB.value == null) {
                    return Collections.singletonList(entryB);
                }
                return OTransactionIndexChangesPerKey.swap(this.entries);
            }
            return new ArrayList<OTransactionIndexEntry>(this.entries);
        }
        HashSet<OTransactionIndexEntry> interpretation = new HashSet<OTransactionIndexEntry>(this.entries.size());
        OTransactionIndexEntry firstExternalRemove = null;
        block4: for (OTransactionIndexEntry entry : this.entries) {
            OIdentifiable value = entry.value;
            switch (entry.operation) {
                case PUT: {
                    assert (value != null);
                    interpretation.add(entry);
                    continue block4;
                }
                case REMOVE: {
                    if (interpretation.remove(entry)) continue block4;
                    if (firstExternalRemove == null) {
                        firstExternalRemove = entry;
                    }
                    if (value != null) continue block4;
                    interpretation.clear();
                    continue block4;
                }
            }
            assert (false);
        }
        if (interpretation.isEmpty()) {
            if (firstExternalRemove != null) {
                return Collections.singletonList(firstExternalRemove);
            }
            return Collections.emptyList();
        }
        ArrayList<OTransactionIndexEntry> changes = new ArrayList<OTransactionIndexEntry>(3);
        if (firstExternalRemove != null) {
            changes.add(firstExternalRemove);
        }
        int counter = 0;
        for (OTransactionIndexEntry entry : interpretation) {
            changes.add(entry);
            if (++counter != 2) continue;
            break;
        }
        return changes;
    }

    private Iterable<OTransactionIndexEntry> interpretAsDictionary() {
        if (this.entries.size() < 2) {
            return new ArrayList<OTransactionIndexEntry>(this.entries);
        }
        if (this.entries.size() == 2) {
            ORID ridB;
            OTransactionIndexEntry entryA = this.entries.get(0);
            OTransactionIndexEntry entryB = this.entries.get(1);
            if (entryA.operation == OTransactionIndexChanges.OPERATION.REMOVE && entryB.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                return Collections.singletonList(entryA);
            }
            ORID ridA = entryA.value == null ? null : entryA.value.getIdentity();
            ORID oRID = ridB = entryB.value == null ? null : entryB.value.getIdentity();
            if (ridA != null && ridA.equals(ridB)) {
                if (entryA.operation == entryB.operation) {
                    return Collections.singletonList(entryA);
                }
                return new ArrayList<OTransactionIndexEntry>(this.entries);
            }
            if (entryB.operation == OTransactionIndexChanges.OPERATION.REMOVE && entryB.value == null) {
                return Collections.singletonList(entryB);
            }
            if (entryB.operation == OTransactionIndexChanges.OPERATION.PUT) {
                return Collections.singletonList(entryB);
            }
            return Collections.singletonList(entryA);
        }
        ArrayDeque<OTransactionIndexEntry> lastObservedPuts = new ArrayDeque<OTransactionIndexEntry>(this.entries.size());
        HashSet<OTransactionIndexEntry> interpretation = new HashSet<OTransactionIndexEntry>(this.entries.size());
        OTransactionIndexEntry firstExternalRemove = null;
        block4: for (OTransactionIndexEntry entry : this.entries) {
            OIdentifiable value = entry.value;
            switch (entry.operation) {
                case PUT: {
                    assert (value != null);
                    interpretation.add(entry);
                    lastObservedPuts.addLast(entry);
                    break;
                }
                case REMOVE: {
                    if (interpretation.remove(entry)) {
                        OTransactionIndexEntry last;
                        assert (value != null);
                        if (entry.equals(lastObservedPuts.peekLast())) {
                            lastObservedPuts.removeLast();
                        }
                        while ((last = (OTransactionIndexEntry)lastObservedPuts.peekLast()) != null && !interpretation.contains(last)) {
                            lastObservedPuts.removeLast();
                        }
                        continue block4;
                    }
                    if (firstExternalRemove == null) {
                        firstExternalRemove = entry;
                    }
                    if (value != null) continue block4;
                    interpretation.clear();
                    lastObservedPuts.clear();
                    break;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
        if (interpretation.isEmpty()) {
            if (firstExternalRemove != null) {
                return Collections.singletonList(firstExternalRemove);
            }
            return Collections.emptyList();
        }
        return Collections.singletonList(lastObservedPuts.getLast());
    }

    private Iterable<OTransactionIndexEntry> interpretAsNonUnique() {
        if (this.entries.size() < 2) {
            return new ArrayList<OTransactionIndexEntry>(this.entries);
        }
        if (this.entries.size() == 2) {
            ORID ridB;
            OTransactionIndexEntry entryA = this.entries.get(0);
            OTransactionIndexEntry entryB = this.entries.get(1);
            ORID ridA = entryA.value == null ? null : entryA.value.getIdentity();
            ORID oRID = ridB = entryB.value == null ? null : entryB.value.getIdentity();
            if (ridA == null) {
                assert (entryA.operation == OTransactionIndexChanges.OPERATION.REMOVE);
                if (entryB.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                    return Collections.singletonList(entryA);
                }
                return new ArrayList<OTransactionIndexEntry>(this.entries);
            }
            if (ridB == null) {
                assert (entryB.operation == OTransactionIndexChanges.OPERATION.REMOVE);
                return Collections.singletonList(entryB);
            }
            if (ridA.equals(ridB)) {
                if (entryA.operation == entryB.operation) {
                    return Collections.singletonList(entryA);
                }
                return new ArrayList<OTransactionIndexEntry>(this.entries);
            }
            return new ArrayList<OTransactionIndexEntry>(this.entries);
        }
        HashSet<OTransactionIndexEntry> changes = new HashSet<OTransactionIndexEntry>(this.entries.size());
        HashSet<OTransactionIndexEntry> interpretation = new HashSet<OTransactionIndexEntry>(this.entries.size());
        boolean seenKeyRemoval = false;
        block4: for (OTransactionIndexEntry entry : this.entries) {
            OIdentifiable value = entry.value;
            ORID rid = value == null ? null : value.getIdentity();
            switch (entry.operation) {
                case PUT: {
                    assert (rid != null);
                    interpretation.add(entry);
                    continue block4;
                }
                case REMOVE: {
                    if (rid == null) {
                        interpretation.clear();
                        changes.clear();
                        changes.add(entry);
                        seenKeyRemoval = true;
                        continue block4;
                    }
                    if (interpretation.remove(entry) || seenKeyRemoval) continue block4;
                    changes.add(entry);
                    continue block4;
                }
            }
            assert (false);
        }
        changes.removeAll(interpretation);
        if (interpretation.isEmpty()) {
            return changes;
        }
        if (!seenKeyRemoval && interpretation.size() < 8) {
            changes.addAll(interpretation);
            return changes;
        }
        OMultiCollectionIterator<OTransactionIndexEntry> result = new OMultiCollectionIterator<OTransactionIndexEntry>();
        result.setAutoConvertToRecord(false);
        result.add(changes);
        result.add(interpretation);
        return result;
    }

    private static Iterable<OTransactionIndexEntry> swap(List<OTransactionIndexEntry> list) {
        assert (list.size() == 2);
        ArrayList<OTransactionIndexEntry> result = new ArrayList<OTransactionIndexEntry>(2);
        result.add(list.get(1));
        result.add(list.get(0));
        return result;
    }

    public static enum Interpretation {
        Unique,
        Dictionary,
        NonUnique;

    }

    public static class OTransactionIndexEntry {
        public OTransactionIndexChanges.OPERATION operation;
        public OIdentifiable value;

        public OTransactionIndexEntry(OIdentifiable iValue, OTransactionIndexChanges.OPERATION iOperation) {
            this.value = iValue;
            this.operation = iOperation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != OTransactionIndexEntry.class) {
                return false;
            }
            OTransactionIndexEntry other = (OTransactionIndexEntry)obj;
            if (this.value != null) {
                return this.value.equals(other.value);
            }
            return other.value == null;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }
    }
}

