/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class OTransactionSequenceStatus {
    private final long[] status;

    public OTransactionSequenceStatus(long[] status) {
        this.status = status;
    }

    public byte[] store() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(buffer);
        OVarIntSerializer.write(dataOutput, (long)this.status.length);
        for (int i = 0; i < this.status.length; ++i) {
            OVarIntSerializer.write(dataOutput, this.status[i]);
        }
        return buffer.toByteArray();
    }

    public static OTransactionSequenceStatus read(byte[] data) throws IOException {
        DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(data));
        int len = OVarIntSerializer.readAsInt(dataInput);
        long[] newSequential = new long[len];
        for (int i = 0; i < len; ++i) {
            newSequential[i] = OVarIntSerializer.readAsLong(dataInput);
        }
        return new OTransactionSequenceStatus(newSequential);
    }

    public void writeNetwork(DataOutput dataOutput) throws IOException {
        OVarIntSerializer.write(dataOutput, (long)this.status.length);
        for (int i = 0; i < this.status.length; ++i) {
            OVarIntSerializer.write(dataOutput, this.status[i]);
        }
    }

    public static OTransactionSequenceStatus readNetwork(DataInput dataInput) throws IOException {
        int len = OVarIntSerializer.readAsInt(dataInput);
        long[] newSequential = new long[len];
        for (int i = 0; i < len; ++i) {
            newSequential[i] = OVarIntSerializer.readAsLong(dataInput);
        }
        return new OTransactionSequenceStatus(newSequential);
    }

    public long[] getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OTransactionSequenceStatus that = (OTransactionSequenceStatus)o;
        return Arrays.equals(this.status, that.status);
    }

    public int hashCode() {
        return Arrays.hashCode(this.status);
    }
}

