/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.core.tx.OTransactionSequenceStatus;
import com.orientechnologies.orient.core.tx.OTxMetadataHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

public class OTxMetadataHolderImpl
implements OTxMetadataHolder {
    private final CountDownLatch request;
    private final OTransactionSequenceStatus status;
    private final OTransactionId id;

    public OTxMetadataHolderImpl(CountDownLatch request, OTransactionId id, OTransactionSequenceStatus status) {
        this.request = request;
        this.id = id;
        this.status = status;
    }

    @Override
    public byte[] metadata() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(outputStream);
        try {
            this.id.write(output);
            byte[] status = this.status.store();
            output.writeInt(status.length);
            output.write(status, 0, status.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toByteArray();
    }

    public static OTxMetadataHolder read(byte[] data) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        DataInputStream input = new DataInputStream(inputStream);
        OTransactionId txId = null;
        try {
            txId = OTransactionId.read(input);
            int size = input.readInt();
            byte[] status = new byte[size];
            input.readFully(status);
            return new OTxMetadataHolderImpl(new CountDownLatch(0), txId, OTransactionSequenceStatus.read(status));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void notifyMetadataRead() {
        this.request.countDown();
    }

    @Override
    public OTransactionId getId() {
        return this.id;
    }

    @Override
    public OTransactionSequenceStatus getStatus() {
        return this.status;
    }
}

