/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;

public class IvyNodeUsage {
    private IvyNode node;
    private Map rootModuleConfs = new HashMap();
    private Map requiredConfs = new HashMap();
    private Map dependers = new HashMap();
    private Map blacklisted = new HashMap();

    public IvyNodeUsage(IvyNode node) {
        this.node = node;
    }

    protected Collection getRequiredConfigurations(IvyNode in, String inConf) {
        return (Collection)this.requiredConfs.get(new NodeConf(in, inConf));
    }

    protected void setRequiredConfs(IvyNode parent, String parentConf, Collection confs) {
        this.requiredConfs.put(new NodeConf(parent, parentConf), new HashSet(confs));
    }

    protected Set getConfigurations(String rootModuleConf) {
        return (Set)this.rootModuleConfs.get(rootModuleConf);
    }

    protected Set addAndGetConfigurations(String rootModuleConf) {
        HashSet depConfs = (HashSet)this.rootModuleConfs.get(rootModuleConf);
        if (depConfs == null) {
            depConfs = new HashSet();
            this.rootModuleConfs.put(rootModuleConf, depConfs);
        }
        return depConfs;
    }

    protected Set getRootModuleConfigurations() {
        return this.rootModuleConfs.keySet();
    }

    public void updateDataFrom(Collection usages, String rootModuleConf) {
        Iterator iterator = usages.iterator();
        while (iterator.hasNext()) {
            IvyNodeUsage usage = (IvyNodeUsage)iterator.next();
            this.updateDataFrom(usage, rootModuleConf);
        }
    }

    private void updateDataFrom(IvyNodeUsage usage, String rootModuleConf) {
        this.updateMapOfSet(usage.requiredConfs, this.requiredConfs);
        this.updateMapOfSetForKey(usage.rootModuleConfs, this.rootModuleConfs, rootModuleConf);
        this.updateMapOfSetForKey(usage.dependers, this.dependers, rootModuleConf);
    }

    private void updateMapOfSet(Map from, Map to) {
        Iterator iter2 = from.keySet().iterator();
        while (iter2.hasNext()) {
            Object key = iter2.next();
            this.updateMapOfSetForKey(from, to, key);
        }
    }

    private void updateMapOfSetForKey(Map from, Map to, Object key) {
        Set set = (Set)from.get(key);
        if (set != null) {
            Set toupdate = (Set)to.get(key);
            if (toupdate != null) {
                toupdate.addAll(set);
            } else {
                to.put(key, new HashSet(set));
            }
        }
    }

    private void addObjectsForConf(String rootModuleConf, Object objectToAdd, Map map) {
        HashSet<Object> set = (HashSet<Object>)map.get(rootModuleConf);
        if (set == null) {
            set = new HashSet<Object>();
            map.put(rootModuleConf, set);
        }
        set.add(objectToAdd);
    }

    public void addUsage(String rootModuleConf, DependencyDescriptor dd, String parentConf) {
        this.addObjectsForConf(rootModuleConf, new Depender(dd, parentConf), this.dependers);
    }

    protected Set getDependencyArtifactsSet(String rootModuleConf) {
        Collection dependersInConf = (Collection)this.dependers.get(rootModuleConf);
        if (dependersInConf == null) {
            return null;
        }
        HashSet<DependencyArtifactDescriptor> dependencyArtifacts = new HashSet<DependencyArtifactDescriptor>();
        Iterator iterator = dependersInConf.iterator();
        while (iterator.hasNext()) {
            Depender depender = (Depender)iterator.next();
            DependencyArtifactDescriptor[] dads = depender.dd.getDependencyArtifacts(depender.dependerConf);
            dependencyArtifacts.addAll(Arrays.asList(dads));
        }
        return dependencyArtifacts;
    }

    protected Set getDependencyIncludesSet(String rootModuleConf) {
        Collection dependersInConf = (Collection)this.dependers.get(rootModuleConf);
        if (dependersInConf == null) {
            return null;
        }
        HashSet<IncludeRule> dependencyIncludes = new HashSet<IncludeRule>();
        Iterator iterator = dependersInConf.iterator();
        while (iterator.hasNext()) {
            Depender depender = (Depender)iterator.next();
            IncludeRule[] rules = depender.dd.getIncludeRules(depender.dependerConf);
            if (rules == null || rules.length == 0) {
                return null;
            }
            dependencyIncludes.addAll(Arrays.asList(rules));
        }
        return dependencyIncludes;
    }

    protected void removeRootModuleConf(String rootModuleConf) {
        this.rootModuleConfs.remove(rootModuleConf);
    }

    protected void blacklist(IvyNodeBlacklist bdata) {
        this.blacklisted.put(bdata.getRootModuleConf(), bdata);
    }

    protected boolean isBlacklisted(String rootModuleConf) {
        return this.blacklisted.containsKey(rootModuleConf);
    }

    protected IvyNodeBlacklist getBlacklistData(String rootModuleConf) {
        return (IvyNodeBlacklist)this.blacklisted.get(rootModuleConf);
    }

    protected IvyNode getNode() {
        return this.node;
    }

    public boolean hasTransitiveDepender(String rootModuleConf) {
        Set dependersSet = (Set)this.dependers.get(rootModuleConf);
        if (dependersSet == null) {
            return false;
        }
        Iterator iterator = dependersSet.iterator();
        while (iterator.hasNext()) {
            Depender depender = (Depender)iterator.next();
            if (!depender.dd.isTransitive()) continue;
            return true;
        }
        return false;
    }

    private static final class Depender {
        private DependencyDescriptor dd;
        private String dependerConf;

        public Depender(DependencyDescriptor dd, String dependerConf) {
            this.dd = dd;
            this.dependerConf = dependerConf;
        }

        public String toString() {
            return this.dd + " [" + this.dependerConf + "]";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Depender)) {
                return false;
            }
            Depender other = (Depender)obj;
            return other.dd == this.dd && other.dependerConf.equals(this.dependerConf);
        }

        public int hashCode() {
            int hash = 33;
            hash += this.dd.hashCode() * 13;
            return hash += this.dependerConf.hashCode() * 13;
        }
    }

    private static final class NodeConf {
        private IvyNode node;
        private String conf;

        public NodeConf(IvyNode node, String conf) {
            if (node == null) {
                throw new NullPointerException("node must not null");
            }
            if (conf == null) {
                throw new NullPointerException("conf must not null");
            }
            this.node = node;
            this.conf = conf;
        }

        public final String getConf() {
            return this.conf;
        }

        public final IvyNode getNode() {
            return this.node;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeConf)) {
                return false;
            }
            return this.getNode().equals(((NodeConf)obj).getNode()) && this.getConf().equals(((NodeConf)obj).getConf());
        }

        public int hashCode() {
            int hash = 33;
            hash += this.getNode().hashCode() * 17;
            return hash += this.getConf().hashCode() * 17;
        }

        public String toString() {
            return "NodeConf(" + this.conf + ")";
        }
    }
}

