/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ivy.util.filter.ArtifactTypeFilter;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;

public final class FilterHelper {
    public static final Filter NO_FILTER = NoFilter.INSTANCE;

    private FilterHelper() {
    }

    public static Filter getArtifactTypeFilter(String types) {
        if (types == null || types.trim().equals("*")) {
            return NO_FILTER;
        }
        String[] t = types.split(",");
        return FilterHelper.getArtifactTypeFilter(t);
    }

    public static Filter getArtifactTypeFilter(String[] types) {
        if (types == null || types.length == 0) {
            return NO_FILTER;
        }
        ArrayList<String> acceptedTypes = new ArrayList<String>(types.length);
        for (int i = 0; i < types.length; ++i) {
            String current = types[i].trim();
            if ("*".equals(current)) {
                return NO_FILTER;
            }
            acceptedTypes.add(current);
        }
        return new ArtifactTypeFilter(acceptedTypes);
    }

    public static Collection filter(Collection col, Filter filter) {
        if (filter == null) {
            return col;
        }
        ArrayList ret = new ArrayList(col);
        Iterator iter2 = ret.iterator();
        while (iter2.hasNext()) {
            Object element = iter2.next();
            if (filter.accept(element)) continue;
            iter2.remove();
        }
        return ret;
    }
}

