/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.CharsetUtil;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.exception.ResponseException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;

@Deprecated
public final class NioGremlinRequestEncoder
extends MessageToByteEncoder<Object> {
    private boolean binaryEncoding = false;
    private final MessageSerializer serializer;

    public NioGremlinRequestEncoder(boolean binaryEncoding, MessageSerializer serializer) {
        this.binaryEncoding = binaryEncoding;
        this.serializer = serializer;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, Object msg, ByteBuf byteBuf) throws Exception {
        RequestMessage requestMessage = (RequestMessage)msg;
        try {
            if (this.binaryEncoding) {
                ByteBuf bytes = this.serializer.serializeRequestAsBinary(requestMessage, channelHandlerContext.alloc());
                byteBuf.writeInt(bytes.capacity());
                byteBuf.writeBytes(bytes);
            } else {
                MessageTextSerializer textSerializer = (MessageTextSerializer)this.serializer;
                byte[] bytes = textSerializer.serializeRequestAsString(requestMessage).getBytes(CharsetUtil.UTF_8);
                byteBuf.writeInt(bytes.length);
                byteBuf.writeBytes(bytes);
            }
        }
        catch (Exception ex) {
            throw new ResponseException(ResponseStatusCode.REQUEST_ERROR_SERIALIZATION, String.format("An error occurred during serialization of this request [%s] - it could not be sent to the server - Reason: %s", requestMessage, ex));
        }
    }
}

