/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.NettyBufferFactory;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;

public class RequestMessageSerializer {
    private static NettyBufferFactory bufferFactory = new NettyBufferFactory();

    public RequestMessage readValue(ByteBuf byteBuf, GraphBinaryReader context) throws SerializationException {
        Buffer buffer = bufferFactory.create(byteBuf);
        int version = buffer.readByte() & 0xFF;
        if (version >>> 7 != 1) {
            throw new SerializationException("The most significant bit should be set according to the format");
        }
        try {
            UUID id = context.readValue(buffer, UUID.class, false);
            String op = context.readValue(buffer, String.class, false);
            String processor = context.readValue(buffer, String.class, false);
            RequestMessage.Builder builder = RequestMessage.build(op).overrideRequestId(id).processor(processor);
            Map args = context.readValue(buffer, Map.class, false);
            args.forEach(builder::addArg);
            return builder.create();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeValue(RequestMessage value, ByteBuf byteBuf, GraphBinaryWriter context) throws SerializationException {
        Buffer buffer = bufferFactory.create(byteBuf);
        try {
            buffer.writeByte(-127);
            context.writeValue(value.getRequestId(), buffer, false);
            context.writeValue(value.getOp(), buffer, false);
            context.writeValue(value.getProcessor(), buffer, false);
            context.writeValue(value.getArgs(), buffer, false);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }
}

