/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.google.common.collect.Maps;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.index.OIndex;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.orientdb.ODBFeatures;
import org.apache.tinkerpop.gremlin.orientdb.OElementFactory;
import org.apache.tinkerpop.gremlin.orientdb.OGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientEdge;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphBaseFactory;
import org.apache.tinkerpop.gremlin.orientdb.OrientStandardTransaction;
import org.apache.tinkerpop.gremlin.orientdb.OrientVertex;
import org.apache.tinkerpop.gremlin.orientdb.executor.OGremlinResultSet;
import org.apache.tinkerpop.gremlin.orientdb.io.OrientIoRegistry;
import org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization.OrientGraphCountStrategy;
import org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization.OrientGraphMatchStepStrategy;
import org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization.OrientGraphStepStrategy;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Io;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureIntegrateSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessComputerSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.orientdb.gremlintest.suite.OrientDBDebugSuite")})
public class OrientStandardGraph
implements OGraph {
    protected final ThreadLocal<OrientGraph> graphInternal = new ThreadLocal();
    private final Map<Thread, OrientGraph> graphs = Maps.newConcurrentMap();
    private final Configuration config;
    private OrientGraphBaseFactory factory;
    private boolean transactional = true;
    private Transaction tx;
    private OElementFactory elementFactory;

    public OrientStandardGraph(OrientGraphBaseFactory factory, Configuration config) {
        this.factory = factory;
        this.config = config;
        if (config.containsKey("orient-transactional")) {
            this.transactional = config.getBoolean("orient-transactional");
        }
        this.tx = new OrientStandardTransaction(this);
        this.elementFactory = new OElementFactory(this);
    }

    @Override
    public Vertex addVertex(Object ... keyValues) {
        return this.graph().addVertex(keyValues);
    }

    @Override
    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        return this.graph().compute(graphComputerClass);
    }

    @Override
    public GraphComputer compute() throws IllegalArgumentException {
        return this.graph().compute();
    }

    @Override
    public Iterator<Vertex> vertices(Object ... vertexIds) {
        return this.graph().vertices(vertexIds);
    }

    @Override
    public Iterator<Edge> edges(Object ... edgeIds) {
        return this.graph().edges(edgeIds);
    }

    @Override
    public Transaction tx() {
        return this.tx;
    }

    @Override
    public void close() throws Exception {
        this.closeGraphs();
        this.factory.close();
    }

    @Override
    public Graph.Variables variables() {
        return this.graph().variables();
    }

    @Override
    public Graph.Features features() {
        if (this.transactional) {
            return ODBFeatures.OrientFeatures.INSTANCE_TX;
        }
        return ODBFeatures.OrientFeatures.INSTANCE_NOTX;
    }

    @Override
    public Configuration configuration() {
        return this.config;
    }

    protected OrientGraph graph() {
        OrientGraph graph = this.graphInternal.get();
        if (graph == null) {
            graph = this.transactional ? this.factory.getTx() : this.factory.getNoTx();
            graph.setElementFactory(this.elementFactory);
            this.graphInternal.set(graph);
            this.graphs.put(Thread.currentThread(), graph);
        }
        return graph;
    }

    @Override
    public <I extends Io> I io(Io.Builder<I> builder) {
        return (I)OGraph.super.io(builder.onMapper(mb -> mb.addRegistry(OrientIoRegistry.getInstance())));
    }

    public void drop() {
        this.closeGraphs();
        this.factory.drop();
    }

    protected void closeGraphs() {
        this.graphInternal.set(null);
        this.graphs.forEach((k, v) -> v.close());
        this.graphs.clear();
    }

    @Override
    public String labelToClassName(String label, String prefix) {
        return this.graph().labelToClassName(label, prefix);
    }

    @Override
    public String classNameToLabel(String className) {
        return this.graph().classNameToLabel(className);
    }

    @Override
    public String createEdgeClass(String label) {
        return this.graph().createEdgeClass(label);
    }

    @Override
    public String createVertexClass(String label) {
        return this.graph().createVertexClass(label);
    }

    @Override
    public Stream<OrientVertex> getIndexedVertices(OIndex index, Iterator<Object> valueIter) {
        return this.graph().getIndexedVertices(index, valueIter);
    }

    @Override
    public Stream<OrientEdge> getIndexedEdges(OIndex index, Iterator<Object> valueIter) {
        return this.graph().getIndexedEdges(index, valueIter);
    }

    @Override
    public ODatabaseDocument getRawDatabase() {
        return this.graph().getRawDatabase();
    }

    @Override
    public OGremlinResultSet executeSql(String sql, Map params) {
        return this.graph().executeSql(sql, params);
    }

    @Override
    public OGremlinResultSet querySql(String sql, Map params) {
        return this.graph().querySql(sql, params);
    }

    @Override
    public Set<String> getIndexedKeys(Class<? extends Element> elementClass, String label) {
        return this.graph().getIndexedKeys(elementClass, label);
    }

    @Override
    public boolean existClass(String label) {
        return this.graph().existClass(label);
    }

    @Override
    public OElementFactory elementFactory() {
        return this.graph().elementFactory();
    }

    public boolean isOpen() {
        return this.factory.isOpen();
    }

    public String toString() {
        return this.graph().toString();
    }

    static {
        TraversalStrategies.GlobalCache.registerStrategies(OrientStandardGraph.class, TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(OrientGraphStepStrategy.instance(), OrientGraphCountStrategy.instance(), OrientGraphMatchStepStrategy.instance()));
    }
}

