/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.orientdb.OrientStandardGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientTransaction;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.AbstractTransaction;
import org.apache.tinkerpop.gremlin.structure.util.TransactionException;

public class OrientStandardTransaction
extends AbstractTransaction {
    private OrientStandardGraph g;

    public OrientStandardTransaction(OrientStandardGraph graph) {
        super(graph);
        this.g = graph;
    }

    @Override
    protected void doOpen() {
        this.tx().doOpen();
    }

    @Override
    protected void doCommit() throws TransactionException {
        this.tx().doCommit();
        ODatabaseDocumentAbstract db = (ODatabaseDocumentAbstract)this.g.graph().getRawDatabase();
        db.internalClose(true);
        db.activateOnCurrentThread();
        db.setStatus(ODatabase.STATUS.OPEN);
    }

    @Override
    protected void doRollback() throws TransactionException {
        this.tx().doRollback();
        ODatabaseDocumentAbstract db = (ODatabaseDocumentAbstract)this.g.graph().getRawDatabase();
        db.internalClose(true);
        db.activateOnCurrentThread();
        db.setStatus(ODatabase.STATUS.OPEN);
    }

    @Override
    protected void fireOnCommit() {
        this.tx().fireOnCommit();
    }

    @Override
    protected void fireOnRollback() {
        this.tx().fireOnRollback();
    }

    @Override
    protected void doReadWrite() {
        this.tx().doReadWrite();
    }

    @Override
    protected void doClose() {
        this.tx().doClose();
    }

    @Override
    public Transaction onReadWrite(Consumer<Transaction> consumer) {
        return this.tx().onReadWrite(consumer);
    }

    @Override
    public Transaction onClose(Consumer<Transaction> consumer) {
        return this.tx().onClose(consumer);
    }

    @Override
    public void addTransactionListener(Consumer<Transaction.Status> listener) {
        this.tx().addTransactionListener(listener);
    }

    @Override
    public void removeTransactionListener(Consumer<Transaction.Status> listener) {
        this.tx().removeTransactionListener(listener);
    }

    @Override
    public void clearTransactionListeners() {
        this.tx().clearTransactionListeners();
    }

    @Override
    public boolean isOpen() {
        return this.tx().isOpen();
    }

    private OrientTransaction tx() {
        return this.g.graph().tx();
    }
}

