/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.orientdb.OrientProperty;
import org.apache.tinkerpop.gremlin.orientdb.OrientVertex;
import org.apache.tinkerpop.gremlin.orientdb.OrientVertexPropertyProperty;
import org.apache.tinkerpop.gremlin.orientdb.StreamUtils;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class OrientVertexProperty<V>
extends OrientProperty<V>
implements VertexProperty<V> {
    public OrientVertexProperty(Property<V> property, OrientVertex vertex) {
        super(property.key(), property.value(), vertex);
    }

    public OrientVertexProperty(String key, V value, OrientVertex vertex) {
        super(key, value, vertex);
    }

    @Override
    public String id() {
        return String.format("%s_%s", this.element.getIdentity(), this.key());
    }

    public <U> Property<U> property(String key, U value) {
        if (T.id.equals(key)) {
            throw VertexProperty.Exceptions.userSuppliedIdsNotSupported();
        }
        ODocument metadata = this.getMetadataDocument();
        metadata.field(key, value);
        return new OrientVertexPropertyProperty<U>(key, value, this);
    }

    @Override
    public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
        if (!this.hasMetadataDocument()) {
            return Collections.emptyIterator();
        }
        Map<String, Object> properties = this.getMetadataDocument().toMap();
        HashSet<String> keys = new HashSet<String>(Arrays.asList(propertyKeys));
        Stream<Map.Entry<String, Object>> entries = StreamUtils.asStream(properties.entrySet().iterator());
        if (keys.size() > 0) {
            entries = entries.filter(entry -> keys.contains(entry.getKey()));
        }
        Stream<Property> propertyStream = entries.filter(entry -> !((String)entry.getKey()).startsWith("@rid")).map(entry -> new OrientVertexPropertyProperty((String)entry.getKey(), entry.getValue(), this));
        return propertyStream.iterator();
    }

    private boolean hasMetadataDocument() {
        return this.element.getRawElement().getProperty(this.metadataKey()) != null;
    }

    public void removeMetadata(String key) {
        ODocument metadata = this.getMetadataDocument();
        metadata.removeField(key);
        if (metadata.fields() == 0) {
            this.element.getRawElement().removeProperty(this.metadataKey());
        }
    }

    ODocument getMetadataDocument() {
        ODocument metadata = (ODocument)this.element.getRawElement().getProperty(this.metadataKey());
        if (metadata == null) {
            metadata = new ODocument();
            OElement vertexDocument = this.element.getRawElement();
            vertexDocument.setProperty(this.metadataKey(), metadata, OType.EMBEDDED);
            vertexDocument.save();
        }
        return metadata;
    }

    @Override
    public void remove() {
        super.remove();
        this.element.getRawElement().removeProperty(this.metadataKey());
    }

    private String metadataKey() {
        return "_meta_" + this.key;
    }

    @Override
    public Vertex element() {
        return (Vertex)((Object)this.element);
    }
}

