/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ExpandableStepIterator;
import org.apache.tinkerpop.gremlin.process.traversal.util.EmptyTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public abstract class AbstractStep<S, E>
implements Step<S, E> {
    protected Set<String> labels = new LinkedHashSet<String>();
    protected String id = "halt";
    protected Traversal.Admin traversal;
    protected ExpandableStepIterator<S> starts;
    protected Traverser.Admin<E> nextEnd = null;
    protected boolean traverserStepIdAndLabelsSetByChild = false;
    protected Step<?, S> previousStep = EmptyStep.instance();
    protected Step<E, ?> nextStep = EmptyStep.instance();

    public AbstractStep(Traversal.Admin traversal) {
        this.traversal = traversal;
        this.starts = new ExpandableStepIterator(this);
    }

    @Override
    public void setId(String id) {
        Objects.requireNonNull(id);
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void addLabel(String label) {
        this.labels.add(label);
    }

    @Override
    public void removeLabel(String label) {
        this.labels.remove(label);
    }

    @Override
    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labels);
    }

    @Override
    public void reset() {
        this.starts.clear();
        this.nextEnd = null;
    }

    @Override
    public void addStarts(Iterator<Traverser.Admin<S>> starts) {
        this.starts.add(starts);
    }

    @Override
    public void addStart(Traverser.Admin<S> start) {
        this.starts.add(start);
    }

    @Override
    public void setPreviousStep(Step<?, S> step) {
        this.previousStep = step;
    }

    @Override
    public Step<?, S> getPreviousStep() {
        return this.previousStep;
    }

    @Override
    public void setNextStep(Step<E, ?> step) {
        this.nextStep = step;
    }

    @Override
    public Step<E, ?> getNextStep() {
        return this.nextStep;
    }

    @Override
    public Traverser.Admin<E> next() {
        Traverser.Admin<E> traverser;
        if (null != this.nextEnd) {
            try {
                Traverser.Admin<E> admin = this.prepareTraversalForNextStep(this.nextEnd);
                return admin;
            }
            finally {
                this.nextEnd = null;
            }
        }
        do {
            if (!Thread.interrupted()) continue;
            throw new TraversalInterruptedException();
        } while (null == (traverser = this.processNextStart()).get() || 0L == traverser.bulk());
        return this.prepareTraversalForNextStep(traverser);
    }

    @Override
    public boolean hasNext() {
        if (null != this.nextEnd) {
            return true;
        }
        try {
            while (true) {
                if (Thread.interrupted()) {
                    throw new TraversalInterruptedException();
                }
                this.nextEnd = this.processNextStart();
                if (null != this.nextEnd.get() && 0L != this.nextEnd.bulk()) {
                    return true;
                }
                this.nextEnd = null;
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    @Override
    public <A, B> Traversal.Admin<A, B> getTraversal() {
        return this.traversal;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> traversal) {
        this.traversal = traversal;
    }

    protected abstract Traverser.Admin<E> processNextStart() throws NoSuchElementException;

    public String toString() {
        return StringFactory.stepString(this, new Object[0]);
    }

    @Override
    public AbstractStep<S, E> clone() {
        try {
            AbstractStep clone = (AbstractStep)super.clone();
            clone.starts = new ExpandableStepIterator(clone);
            clone.previousStep = EmptyStep.instance();
            clone.nextStep = EmptyStep.instance();
            clone.nextEnd = null;
            clone.traversal = EmptyTraversal.instance();
            clone.labels = new LinkedHashSet<String>(this.labels);
            clone.reset();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean equals(Object other) {
        return other != null && other.getClass().equals(this.getClass()) && this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        for (String label : this.getLabels()) {
            result ^= label.hashCode();
        }
        return result;
    }

    private final Traverser.Admin<E> prepareTraversalForNextStep(Traverser.Admin<E> traverser) {
        if (!this.traverserStepIdAndLabelsSetByChild) {
            traverser.setStepId(this.nextStep.getId());
            traverser.addLabels(this.labels);
        }
        return traverser;
    }
}

